/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.containers.HashMap;
import org.jetbrains.kotlin.gnu.trove.THashMap;

public class BidirectionalMap<K, V>
implements Map<K, V> {
    private final Map<K, V> myKeyToValueMap = new THashMap();
    private final Map<V, List<K>> myValueToKeysMap = new THashMap<V, List<K>>();

    @Override
    public V put(K key, V value) {
        List<K> array;
        V oldValue = this.myKeyToValueMap.put(key, value);
        if (oldValue != null) {
            if (oldValue.equals(value)) {
                return oldValue;
            }
            array = this.myValueToKeysMap.get(oldValue);
            array.remove(key);
        }
        if ((array = this.myValueToKeysMap.get(value)) == null) {
            array = new ArrayList<K>();
            this.myValueToKeysMap.put((List<K>)value, (List<V>)array);
        }
        array.add(key);
        return oldValue;
    }

    @Override
    public void clear() {
        this.myKeyToValueMap.clear();
        this.myValueToKeysMap.clear();
    }

    @Nullable
    public List<K> getKeysByValue(V value) {
        return this.myValueToKeysMap.get(value);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myKeyToValueMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/BidirectionalMap", "keySet"));
        }
        return set;
    }

    @Override
    public int size() {
        return this.myKeyToValueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myKeyToValueMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.myKeyToValueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myValueToKeysMap.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this.myKeyToValueMap.get(key);
    }

    @Override
    public V remove(Object key) {
        V value = this.myKeyToValueMap.remove(key);
        List<K> ks = this.myValueToKeysMap.get(value);
        if (ks != null) {
            if (ks.size() > 1) {
                ks.remove(key);
            } else {
                this.myValueToKeysMap.remove(value);
            }
        }
        return value;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/util/containers/BidirectionalMap", "putAll"));
        }
        for (K k1 : t.keySet()) {
            this.put(k1, t.get(k1));
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        Set<V> set = this.myValueToKeysMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/BidirectionalMap", "values"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.myKeyToValueMap.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/BidirectionalMap", "entrySet"));
        }
        return set;
    }

    public String toString() {
        return new HashMap(this.myKeyToValueMap).toString();
    }
}

