/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceFilter;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.SlicedMapImpl;
import org.jetbrains.kotlin.util.slicedMap.TrackingSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BindingTraceContext
implements BindingTrace {
    private final MutableSlicedMap map;
    @Nullable
    private final MutableDiagnosticsWithSuppression mutableDiagnostics;
    @NotNull
    private final BindingTraceFilter filter;
    private final BindingContext bindingContext;

    public BindingTraceContext() {
        this(BindingTraceFilter.Companion.getACCEPT_ALL());
    }

    public BindingTraceContext(BindingTraceFilter filter2) {
        this(SlicedMapImpl.create(), filter2);
    }

    private BindingTraceContext(@NotNull MutableSlicedMap map2, BindingTraceFilter filter2) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/resolve/BindingTraceContext", "<init>"));
        }
        this.bindingContext = new BindingContext(){

            @Override
            @NotNull
            public Diagnostics getDiagnostics() {
                Diagnostics diagnostics = BindingTraceContext.this.mutableDiagnostics != null ? BindingTraceContext.this.mutableDiagnostics : Diagnostics.Companion.getEMPTY();
                if (diagnostics == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getDiagnostics"));
                }
                return diagnostics;
            }

            @Override
            public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
                return BindingTraceContext.this.get(slice, key);
            }

            @Override
            @NotNull
            public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
                Collection<K> collection = BindingTraceContext.this.getKeys(slice);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getKeys"));
                }
                return collection;
            }

            @Override
            @NotNull
            public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
                if (slice == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getSliceContents"));
                }
                ImmutableMap<K, V> immutableMap = BindingTraceContext.this.map.getSliceContents(slice);
                if (immutableMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getSliceContents"));
                }
                return immutableMap;
            }

            @Override
            @Nullable
            public KotlinType getType(@NotNull KtExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "getType"));
                }
                return BindingTraceContext.this.getType(expression);
            }

            @Override
            public void addOwnDataTo(@NotNull BindingTrace trace, boolean commitDiagnostics) {
                if (trace == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingTraceContext$1", "addOwnDataTo"));
                }
                BindingContextUtils.addOwnDataTo(trace, null, commitDiagnostics, BindingTraceContext.this.map, BindingTraceContext.this.mutableDiagnostics);
            }
        };
        this.map = map2;
        this.mutableDiagnostics = !filter2.getIgnoreDiagnostics() ? new MutableDiagnosticsWithSuppression(this.bindingContext, Diagnostics.Companion.getEMPTY()) : null;
        this.filter = filter2;
    }

    public static BindingTraceContext createTraceableBindingTrace() {
        return new BindingTraceContext(new TrackingSlicedMap(true), BindingTraceFilter.Companion.getACCEPT_ALL());
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/BindingTraceContext", "report"));
        }
        if (this.mutableDiagnostics == null) {
            return;
        }
        this.mutableDiagnostics.report(diagnostic);
    }

    public void clearDiagnostics() {
        if (this.mutableDiagnostics != null) {
            this.mutableDiagnostics.clear();
        }
    }

    @Override
    public boolean wantsDiagnostics() {
        return this.mutableDiagnostics != null;
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingContext;
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext", "getBindingContext"));
        }
        return bindingContext;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
        this.map.put(slice, key, value);
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return this.map.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        Collection<K> collection = this.map.getKeys(slice);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingTraceContext", "getKeys"));
        }
        return collection;
    }

    @Override
    @Nullable
    public KotlinType getType(@NotNull KtExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingTraceContext", "getType"));
        }
        KotlinTypeInfo typeInfo = this.get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        return typeInfo != null ? typeInfo.getType() : null;
    }

    @Override
    public void recordType(@NotNull KtExpression expression, @Nullable KotlinType type2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingTraceContext", "recordType"));
        }
        KotlinTypeInfo typeInfo = this.get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        typeInfo = typeInfo != null ? typeInfo.replaceType(type2) : TypeInfoFactoryKt.createTypeInfo(type2);
        this.record(BindingContext.EXPRESSION_TYPE_INFO, expression, typeInfo);
    }
}

