/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsProtoBuf;
import org.jetbrains.kotlin.serialization.js.DynamicTypeDeserializer;
import org.jetbrains.kotlin.serialization.js.JavaScriptStringTable;
import org.jetbrains.kotlin.serialization.js.JsProtoBuf;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinFileRegistry;
import org.jetbrains.kotlin.types.FlexibleType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\r\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/serialization/js/KotlinJavascriptSerializerExtension;", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "fileRegistry", "Lorg/jetbrains/kotlin/serialization/js/KotlinFileRegistry;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/serialization/js/KotlinFileRegistry;Lorg/jetbrains/kotlin/name/FqName;)V", "stringTable", "Lorg/jetbrains/kotlin/serialization/js/JavaScriptStringTable;", "getStringTable", "()Lorg/jetbrains/kotlin/serialization/js/JavaScriptStringTable;", "getFileId", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Ljava/lang/Integer;", "serializeClass", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class$Builder;", "serializeFlexibleType", "flexibleType", "Lorg/jetbrains/kotlin/types/FlexibleType;", "lowerProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type$Builder;", "upperProto", "serializeFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function$Builder;", "serializePackage", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Package$Builder;", "serializeProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Property$Builder;", "kotlin-compiler"})
public final class KotlinJavascriptSerializerExtension
extends KotlinSerializerExtensionBase {
    @NotNull
    private final JavaScriptStringTable stringTable;
    private final KotlinFileRegistry fileRegistry;
    private final FqName packageFqName;

    @Override
    @NotNull
    public JavaScriptStringTable getStringTable() {
        return this.stringTable;
    }

    @Override
    public void serializeFlexibleType(@NotNull FlexibleType flexibleType, @NotNull ProtoBuf.Type.Builder lowerProto, @NotNull ProtoBuf.Type.Builder upperProto) {
        Intrinsics.checkParameterIsNotNull(flexibleType, "flexibleType");
        Intrinsics.checkParameterIsNotNull(lowerProto, "lowerProto");
        Intrinsics.checkParameterIsNotNull(upperProto, "upperProto");
        lowerProto.setFlexibleTypeCapabilitiesId(this.getStringTable().getStringIndex(DynamicTypeDeserializer.INSTANCE.getId()));
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Integer id = this.getFileId(descriptor2);
        if (id != null) {
            proto.setExtension(JsProtoBuf.classContainingFileId, id);
        }
        super.serializeClass(descriptor2, proto);
    }

    @Override
    public void serializePackage(@NotNull ProtoBuf.Package.Builder proto) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        proto.setExtension(BuiltInsProtoBuf.packageFqName, this.getStringTable().getPackageFqNameIndex(this.packageFqName));
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Integer id = this.getFileId(descriptor2);
        if (id != null) {
            proto.setExtension(JsProtoBuf.propertyContainingFileId, id);
        }
        super.serializeProperty(descriptor2, proto);
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Integer id = this.getFileId(descriptor2);
        if (id != null) {
            proto.setExtension(JsProtoBuf.functionContainingFileId, id);
        }
        super.serializeFunction(descriptor2, proto);
    }

    private final Integer getFileId(DeclarationDescriptor descriptor2) {
        Integer n;
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor2) || !(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return null;
        }
        SourceFile file2 = ((DeclarationDescriptorWithSource)descriptor2).getSource().getContainingFile();
        if (!(file2 instanceof PsiSourceFile)) {
            return null;
        }
        PsiFile psiFile = ((PsiSourceFile)file2).getPsiFile();
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile != null) {
            KtFile ktFile2;
            KtFile it = ktFile2 = ktFile;
            n = this.fileRegistry.lookup(it);
        } else {
            n = null;
        }
        return n;
    }

    public KotlinJavascriptSerializerExtension(@NotNull KotlinFileRegistry fileRegistry, @NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull(fileRegistry, "fileRegistry");
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        super(JsSerializerProtocol.INSTANCE);
        this.fileRegistry = fileRegistry;
        this.packageFqName = packageFqName;
        this.stringTable = new JavaScriptStringTable();
    }
}

