/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.tasks.api;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.internal.tasks.compile.ApiClassExtractor;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.util.internal.Java9ClassReader;
import org.objectweb.asm.ClassReader;

@Incubating
public class ApiJar
extends DefaultTask {
    private Set<String> exportedPackages;
    private File outputFile;

    @Input
    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    public void setExportedPackages(Set<String> exportedPackages) {
        this.exportedPackages = exportedPackages;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @TaskAction
    public void createApiJar() throws IOException {
        final File[] sourceFiles = this.sortedSourceFiles();
        final ApiClassExtractor apiClassExtractor = new ApiClassExtractor(this.getExportedPackages());
        IoActions.withResource((Closeable)new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.getOutputFile()), 65536)), (Action)new ErroringAction<JarOutputStream>(){

            protected void doExecute(JarOutputStream jos) throws Exception {
                this.writeManifest(jos);
                this.writeClasses(jos);
            }

            private void writeManifest(JarOutputStream jos) throws IOException {
                this.writeEntry(jos, "META-INF/MANIFEST.MF", "Manifest-Version: 1.0\n".getBytes());
            }

            private void writeClasses(JarOutputStream jos) throws Exception {
                for (File sourceFile : sourceFiles) {
                    byte[] apiClassBytes;
                    Java9ClassReader classReader;
                    if (!ApiJar.this.isClassFile(sourceFile) || !apiClassExtractor.shouldExtractApiClassFrom((ClassReader)(classReader = new Java9ClassReader(FileUtils.readFileToByteArray((File)sourceFile)))) || (apiClassBytes = apiClassExtractor.extractApiClassFrom((ClassReader)classReader)) == null) continue;
                    String internalClassName = classReader.getClassName();
                    String entryPath = internalClassName + ".class";
                    this.writeEntry(jos, entryPath, apiClassBytes);
                }
            }

            private void writeEntry(JarOutputStream jos, String name, byte[] bytes) throws IOException {
                JarEntry je = new JarEntry(name);
                je.setTime(0L);
                je.setSize(bytes.length);
                jos.putNextEntry(je);
                jos.write(bytes);
                jos.closeEntry();
            }
        });
    }

    private boolean isClassFile(File file) {
        return org.gradle.internal.FileUtils.hasExtension((File)file, (String)".class");
    }

    private File[] sortedSourceFiles() {
        Object[] sourceFiles = (File[])this.getInputs().getSourceFiles().asType(File[].class);
        Arrays.sort(sourceFiles);
        return sourceFiles;
    }
}

