/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.Iterators;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.DiscoveredInputsListener;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotterRegistry;
import org.gradle.api.internal.changedetection.state.GenericFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertySnapshotNormalizationStrategy;
import org.gradle.api.internal.file.FileCollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveredInputsTaskStateChanges
implements TaskStateChanges,
DiscoveredInputsListener {
    private final String taskName;
    private final FileCollectionSnapshotter snapshotter;
    private final FileCollectionFactory fileCollectionFactory;
    private final TaskExecution previous;
    private final TaskExecution current;
    private Collection<File> discoveredFiles = Collections.emptySet();

    public DiscoveredInputsTaskStateChanges(@Nullable TaskExecution previous, TaskExecution current, FileCollectionSnapshotterRegistry snapshotterRegistry, FileCollectionFactory fileCollectionFactory, TaskInternal task) {
        this.taskName = task.getName();
        this.snapshotter = snapshotterRegistry.getSnapshotter(GenericFileCollectionSnapshotter.class);
        this.fileCollectionFactory = fileCollectionFactory;
        this.previous = previous;
        this.current = current;
    }

    private FileCollectionSnapshot getPrevious() {
        return this.previous != null ? this.previous.getDiscoveredInputFilesSnapshot() : null;
    }

    private FileCollectionSnapshot getCurrent() {
        if (this.getPrevious() != null) {
            return this.createSnapshot(this.snapshotter, this.fileCollectionFactory.fixed("Discovered input files", this.getPrevious().getElements()));
        }
        return null;
    }

    @Override
    public Iterator<TaskStateChange> iterator() {
        if (this.getPrevious() == null) {
            return Iterators.singletonIterator((Object)new DescriptiveChange("Discovered input file history is not available.", new Object[0]));
        }
        return this.getCurrent().iterateContentChangesSince(this.getPrevious(), "discovered input");
    }

    @Override
    public void snapshotAfterTask() {
        FileCollectionSnapshot discoveredFilesSnapshot = this.createSnapshot(this.snapshotter, this.fileCollectionFactory.fixed("Discovered input files", this.discoveredFiles));
        this.current.setDiscoveredInputFilesSnapshot(discoveredFilesSnapshot);
    }

    @Override
    public void newInputs(Set<File> files) {
        this.discoveredFiles = files;
    }

    private FileCollectionSnapshot createSnapshot(FileCollectionSnapshotter snapshotter, FileCollection fileCollection) {
        try {
            return snapshotter.snapshot(fileCollection, TaskFilePropertyCompareStrategy.UNORDERED, TaskFilePropertySnapshotNormalizationStrategy.ABSOLUTE);
        }
        catch (UncheckedIOException e) {
            throw new UncheckedIOException(String.format("Failed to capture snapshot of discovered input files for task '%s' during up-to-date check.", this.taskName), (Throwable)e);
        }
    }
}

