#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tf-random
version: 0.5
id: tf-random-0.5-CJZw1ZWS5MOJlR60HqKEZL
key: tf-random-0.5-CJZw1ZWS5MOJlR60HqKEZL
license: BSD3
maintainer: Michał Pałka <michal.palka@chalmers.se>
synopsis: High-quality splittable pseudorandom number generator
description:
    This package contains an implementation of a high-quality splittable pseudorandom number generator. The generator is based on a cryptographic hash function built on top of the ThreeFish block cipher. See the paper /Splittable Pseudorandom Number Generators Using Cryptographic Hashing/ by Claessen, Pałka for details and the rationale of the design.
    .
    The package provides the following:
    .
    * A splittable PRNG that implements the standard '\''System.Random.RandomGen'\'' class.
    .
    * The generator also implements an alternative version of the '\''System.Random.TF.Gen.RandomGen'\'' class (exported from "System.Random.TF.Gen"), which requires the generator to return pseudorandom integers from the full 32-bit range, and contains an n-way split function.
    .
    * An alternative version of the @Random@ class is provided, which is linked to the new @RandomGen@ class, together with @Random@ instances for some integral types.
    .
    * Two functions for initialising the generator with a non-deterministic seed: one using the system time, and one using the @\/dev\/urandom@ UNIX special file.
    .
    The package uses an adapted version of the reference C implementation of ThreeFish from the reference package of the Skein hash function (<https://www.schneier.com/skein.html>), originally written by Doug Whiting.
    .
    Please note that even though the generator provides very high-quality pseudorandom numbers, it has not been designed with cryptographic applications in mind.
category: Random
author: Michał Pałka <michal.palka@chalmers.se>
exposed: True
exposed-modules:
    System.Random.TF System.Random.TF.Gen System.Random.TF.Init
    System.Random.TF.Instances
abi: fab6d532ade8d834348ed9a708619e29
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/tf-random-0.5
library-dirs: /usr/lib/ghc-8.0.2/site-local/tf-random-0.5
dynamic-library-dirs: /usr/lib/arm-linux-ghc-8.0.2
data-dir: /usr/share/arm-linux-ghc-8.0.2/tf-random-0.5
hs-libraries: HStf-random-0.5-CJZw1ZWS5MOJlR60HqKEZL
depends:
    base-4.9.1.0 primitive-0.6.2.0-4578caNkWQ54Gt1mxLF2Yh
    random-1.1-9tceXaeYIMZ4JrKq20Egog time-1.6.0.1
haddock-interfaces: /usr/share/doc/haskell-tf-random/html/tf-random.haddock
haddock-html: /usr/share/doc/haskell-tf-random/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
