/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.AboutDialog;
import com.inet.jortho.AutoSpellChecker;
import com.inet.jortho.Dictionary;
import com.inet.jortho.DictionaryEditDialog;
import com.inet.jortho.SpellChecker;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.Suggestion;
import com.inet.jortho.Tokenizer;
import com.inet.jortho.UserDictionaryProvider;
import com.inet.jortho.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

class SpellCheckerDialog
extends JDialog
implements ActionListener {
    private JTextComponent jText;
    private Dictionary dictionary;
    private Tokenizer tok;
    private boolean isDictionaryModify;
    private final SpellCheckerOptions options;
    private final JLabel notFound = Utils.getLabel(null);
    private final JTextField word = Utils.getTextField();
    private final JList suggestionsList = Utils.getList();
    private final JButton ignore = Utils.getButton("ignore");
    private final JButton ignoreAll = Utils.getButton("ignoreAll");
    private final JButton addToDic = Utils.getButton("addToDictionary");
    private final JButton editDic = Utils.getButton("editDictionary");
    private final JButton change = Utils.getButton("change");
    private final JButton changeAll = Utils.getButton("changeAll");
    private final JButton about = Utils.getButton("about");
    private final JButton close = Utils.getButton("close");
    private final ArrayList<String> ignoreWords = new ArrayList();
    private final HashMap<String, String> changeWords = new HashMap();

    SpellCheckerDialog(Dialog dialog) throws HeadlessException {
        this(dialog, false, null);
    }

    SpellCheckerDialog(Dialog dialog, boolean bl, SpellCheckerOptions spellCheckerOptions) {
        super(dialog, bl);
        this.options = spellCheckerOptions == null ? SpellChecker.getOptions() : spellCheckerOptions;
        this.init();
    }

    SpellCheckerDialog(Frame frame) {
        this(frame, false, null);
    }

    SpellCheckerDialog(Frame frame, boolean bl, SpellCheckerOptions spellCheckerOptions) {
        super(frame, bl);
        this.options = spellCheckerOptions == null ? SpellChecker.getOptions() : spellCheckerOptions;
        this.init();
    }

    private final void init() {
        Utils.setDialogIcon(this);
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        Insets insets = new Insets(8, 8, 0, 8);
        Insets insets2 = new Insets(8, 0, 0, 8);
        container.add((Component)Utils.getLabel(Utils.getResource("notInDictionary") + ":"), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 16, 0, insets, 0, 0));
        this.notFound.setForeground(Color.RED);
        this.notFound.setText("xxxxxxxxxx");
        container.add((Component)this.notFound, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 16, 0, insets, 0, 0));
        container.add((Component)this.word, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        container.add((Component)Utils.getLabel(Utils.getResource("suggestions") + ":"), new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 16, 0, insets, 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.suggestionsList);
        container.add((Component)jScrollPane, new GridBagConstraints(1, 4, 2, 6, 1.0, 1.0, 18, 1, new Insets(8, 8, 8, 8), 0, 0));
        container.add((Component)this.ignore, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 2, insets2, 0, 0));
        container.add((Component)this.ignoreAll, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 18, 2, insets2, 0, 0));
        container.add((Component)this.addToDic, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 18, 2, insets2, 0, 0));
        container.add((Component)this.editDic, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 18, 2, insets2, 0, 0));
        container.add((Component)this.change, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 18, 2, insets2, 0, 0));
        container.add((Component)this.changeAll, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 18, 2, insets2, 0, 0));
        container.add((Component)this.about, new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 18, 2, insets2, 0, 0));
        container.add((Component)this.close, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 18, 2, insets2, 0, 0));
        container.add((Component)Utils.getLabel(null), new GridBagConstraints(3, 9, 1, 1, 0.0, 1.0, 18, 2, insets2, 0, 0));
        this.ignore.addActionListener(this);
        this.ignoreAll.addActionListener(this);
        this.addToDic.addActionListener(this);
        this.editDic.addActionListener(this);
        this.change.addActionListener(this);
        this.changeAll.addActionListener(this);
        this.about.addActionListener(this);
        this.close.addActionListener(this);
        this.close.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "ESCAPE");
        this.close.getActionMap().put("ESCAPE", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellCheckerDialog.this.dispose();
            }
        });
        this.word.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                SpellCheckerDialog.this.addToDic.setEnabled(false);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                SpellCheckerDialog.this.addToDic.setEnabled(false);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SpellCheckerDialog.this.addToDic.setEnabled(false);
            }
        });
        this.suggestionsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && SpellCheckerDialog.this.suggestionsList.getSelectedIndex() >= 0) {
                    SpellCheckerDialog.this.word.setText((String)SpellCheckerDialog.this.suggestionsList.getSelectedValue());
                    SpellCheckerDialog.this.addToDic.setEnabled(true);
                }
            }
        });
        this.suggestionsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && SpellCheckerDialog.this.suggestionsList.getSelectedIndex() >= 0) {
                    SpellCheckerDialog.this.word.setText((String)SpellCheckerDialog.this.suggestionsList.getSelectedValue());
                    SpellCheckerDialog.this.actionPerformed(new ActionEvent(SpellCheckerDialog.this.suggestionsList, 0, null));
                }
            }
        });
        boolean bl = SpellChecker.getUserDictionaryProvider() != null;
        this.addToDic.setEnabled(bl);
        this.editDic.setEnabled(bl);
        this.pack();
    }

    public void show(JTextComponent jTextComponent, Dictionary dictionary, Locale locale) {
        this.jText = jTextComponent;
        this.dictionary = dictionary;
        this.change.requestFocus();
        this.setTitle(Utils.getResource("spelling") + ": " + locale.getDisplayLanguage());
        this.tok = new Tokenizer(jTextComponent, dictionary, locale, this.options);
        if (this.searchNext()) {
            Container container;
            for (container = jTextComponent; container != null && !(container instanceof JScrollPane); container = container.getParent()) {
                if (container instanceof JComponent) {
                    JComponent jComponent = container;
                    if (jComponent.getVisibleRect().height == jComponent.getBounds().height) break;
                }
                if (container.getParent() == null) break;
            }
            this.setLocationRelativeTo(container);
            this.setVisible(true);
        }
    }

    private boolean searchNext() {
        Object object;
        String string;
        while (true) {
            if ((string = this.tok.nextInvalidWord()) == null) {
                this.dispose();
                object = SpellChecker.getApplicationName();
                if (object == null) {
                    object = this.getTitle();
                }
                SpellChecker.getMessageHandler().handleInformation(this.getParent(), (String)object, Utils.getResource("msgFinish"));
                return false;
            }
            if (this.ignoreWords.contains(string)) continue;
            object = this.changeWords.get(string);
            if (object == null) break;
            this.replaceWord(string, (String)object);
        }
        this.word.setText(string);
        this.notFound.setText(string);
        object = this.dictionary.searchSuggestions(string);
        boolean bl = this.tok.isFirstWordInSentence() && Utils.isFirstCapitalized(string);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < object.size() && i < this.options.getSuggestionsLimitDialog(); ++i) {
            Suggestion suggestion = (Suggestion)object.get(i);
            String string2 = suggestion.getWord();
            if (bl) {
                string2 = Utils.getCapitalized(string2);
            }
            if (i == 0) {
                this.word.setText(string2);
            }
            vector.add(string2);
        }
        this.suggestionsList.setListData(vector);
        this.addToDic.setEnabled(true);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ignore) {
            this.searchNext();
        } else if (object == this.about) {
            new AboutDialog(this).setVisible(true);
        } else if (object == this.close) {
            this.dispose();
        } else {
            String string = this.word.getText();
            String string2 = this.notFound.getText();
            if (object == this.ignoreAll) {
                this.ignoreWords.add(string2);
                this.searchNext();
            } else if (object == this.addToDic) {
                UserDictionaryProvider userDictionaryProvider = SpellChecker.getUserDictionaryProvider();
                if (userDictionaryProvider != null) {
                    userDictionaryProvider.addWord(string2);
                }
                this.dictionary.add(string2);
                this.dictionary.trimToSize();
                this.isDictionaryModify = true;
                this.searchNext();
            } else if (object == this.editDic) {
                new DictionaryEditDialog(this).setVisible(true);
            } else if (object == this.change || object == this.suggestionsList) {
                this.replaceWord(string2, string);
                this.searchNext();
            } else if (object == this.changeAll) {
                this.changeWords.put(string2, string);
                this.replaceWord(string2, string);
                this.searchNext();
            }
        }
    }

    private void replaceWord(String string, String string2) {
        this.jText.setSelectionStart(this.tok.getWordOffset());
        this.jText.setSelectionEnd(this.tok.getWordOffset() + string.length());
        this.jText.replaceSelection(string2);
        this.tok.updatePhrase();
    }

    public void dispose() {
        super.dispose();
        if (this.isDictionaryModify) {
            AutoSpellChecker.refresh(this.jText);
        }
    }
}

