

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Include Only Points Within Radius (radius){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Include Only Points Within Radius (radius)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="filter_arc.html">Prev</a> </td><th width="60%" align="center">Chapter 4. Data Filters</th><td width="20%" align="right"> <a accesskey="n" href="filter_interpolate.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="filter_radius"></a>Include Only Points Within Radius (radius)</h2></div></div></div><p> 
This filter includes or excludes waypoints based on their proximity to a 
central point.  All waypoints more than the specified distance from the 
specified point will be removed from the dataset.
</p><p>
By default, all remaining points are sorted so that points closer to the 
center appear earlier in the output file.
</p><div class="example"><a id="radius_to_find_points_close"></a><p class="title"><strong>Example 4.4. Using the radius filter to find points close to a given point</strong></p><div class="example-contents"><p>This example command line would include only points within 1 1/2 miles
       of N30.000 W 90.000</p><p><strong class="userinput"><code>gpsbabel -i geo -f 1.loc -x radius,distance=1.5M,lat=30.0,lon=-90.0 -o mapsend -F 2.wpt</code></strong></p></div></div><br class="example-break" /><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_radius_o_lat"></a>lat option</h3></div></div></div><p>
      Latitude for center point (D.DDDDD).
    </p><p>
This option is required.
</p><p>
This option specifies the latitude of the central point in decimal degrees.
South latitudes should be expressed as a negative number.  Valid values for
this option are from -90 to 90.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_radius_o_lon"></a>lon option</h3></div></div></div><p>
      Longitude for center point (D.DDDDD).
    </p><p>
This option is required.
</p><p>
This option specifies the longitude of the central point in decimal degrees.
West longitudes should be expressed as a negative number.  Valid values for
this option are from -180 to 180.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_radius_o_distance"></a>distance option</h3></div></div></div><p>
      Maximum distance from center.
    </p><p>
This option is required.
</p><p>
This option specifies the maximum distance a point may be from the central
point in order to remain in the dataset.  Points closer than this distance
will be kept and points further away will be removed (unless the 
<code class="option">exclude</code> option is specified.)
</p><p>
Distances may be expressed in miles (3M) or kilometers (4K).  If no units
are provided, the distance is assumed to be in miles.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_radius_o_exclude"></a>exclude option</h3></div></div></div><p>
      Exclude points close to center.
    </p><p>
If this option is included, the action of the radius filter will be reversed:
points within the given distance will be removed, and points further away
will be kept.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_radius_o_nosort"></a>nosort option</h3></div></div></div><p>
      Inhibit sort by distance to center.
    </p><p>
If this option is specified, the radius filter will not sort the remaining
points by distance from the center.  They will remain in whatever order they
were originally.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_radius_o_maxcount"></a>maxcount option</h3></div></div></div><p>
      Output no more than this number of points.
    </p><p>
This option specifies the maximum number of points that the radius filter may
keep.  If there are more than this number of points within the specified 
distance of the center, the more distant points will be discarded even though
they are within the specified distance.  If this option is not specified, 
all points are kept regardless of how many there are.
</p><p>
Note that if the <code class="option">nosort</code> option is also specified, this 
option will instead keep points based on their position within the input
file rather than on their distance from the center.  This may or may not be
what you want.
</p><p>
Note, too, that this option may be used with the <code class="option">exclude</code> 
option, but the results might not be what you expect.  In particular, the 
results will not be the same as if you had kept all of the points you'd 
otherwise throw away.  You will still get no more than 
<code class="varname">maxcount</code> points, but they will all be at least 
<code class="varname">distance</code> away from the center.  (And possibly sorted.)
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_radius_o_asroute"></a>asroute option</h3></div></div></div><p>
      Put resulting waypoints in route of this name.
    </p><p>
This option specifies the name of a route.  If this option is specified, the
radius filter puts all points that are kept into a route with the given name.
The order of points in the route is by distance from the center (unless the
<code class="option">nosort</code> option is also specified.)
</p><p>
Note that this route is not necessarily the most efficient route to visit 
all of the points.  In fact, for some data sets, it might be the least 
efficient route.
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="filter_arc.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Data_Filters.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="filter_interpolate.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Include Only Points Within Distance of Arc (arc) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Interpolate between trackpoints (interpolate)</td></tr></table></div>
  
      {/literal}{/block}
  