/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import tim.prune.data.DataPoint;
import tim.prune.data.Track;

public class TrackDetails {
    private Track _track = null;
    private double _trackSpan = -1.0;
    private boolean[] _segmentStarts = null;
    private boolean[] _segmentEnds = null;
    private double _meanRadians = 0.0;

    public TrackDetails(Track track) {
        this._track = track;
    }

    public void initialise() {
        double d;
        double d2 = this._track.getXRange().getRange();
        this._trackSpan = d2 > (d = this._track.getYRange().getRange()) ? d2 : d;
        int n = this._track.getNumPoints();
        this._segmentStarts = new boolean[n];
        this._segmentEnds = new boolean[n];
        int n2 = -1;
        int n3 = 0;
        double d3 = 0.0;
        int n4 = 0;
        while (n4 < n) {
            DataPoint dataPoint = this._track.getPoint(n4);
            if (!dataPoint.isWaypoint()) {
                if (dataPoint.getSegmentStart()) {
                    this._segmentStarts[n4] = true;
                    if (n2 >= 0) {
                        this._segmentEnds[n2] = true;
                    }
                } else if (n2 >= 0) {
                    ++n3;
                    d3 += DataPoint.calculateRadiansBetween(this._track.getPoint(n2), dataPoint);
                }
                n2 = n4;
            }
            ++n4;
        }
        this._segmentEnds[n2] = true;
        this._meanRadians = d3 / (double)n3;
    }

    public double getTrackSpan() {
        if (this._trackSpan < 0.0) {
            this.initialise();
        }
        return this._trackSpan;
    }

    public boolean isSegmentStart(int n) {
        if (this._segmentStarts == null || this._segmentStarts.length != this._track.getNumPoints()) {
            this.initialise();
        }
        return this._segmentStarts[n];
    }

    public boolean isSegmentEnd(int n) {
        if (this._segmentEnds == null || this._segmentEnds.length != this._track.getNumPoints()) {
            this.initialise();
        }
        return this._segmentEnds[n];
    }

    public double getMeanRadians() {
        if (this._meanRadians == 0.0) {
            this.initialise();
        }
        return this._meanRadians;
    }
}

