/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.T3;
import org.jmol.java.BS;
import org.jmol.util.TriangleData;

public class Triangulator
extends TriangleData {
    public static final int[][] fullCubePolygon = new int[][]{{0, 4, 5, 3}, {5, 1, 0, 3}, {1, 5, 6, 2}, {6, 2, 1, 3}, {2, 6, 7, 2}, {7, 3, 2, 3}, {3, 7, 4, 2}, {4, 0, 3, 2}, {6, 5, 4, 0}, {4, 7, 6, 0}, {0, 1, 2, 0}, {2, 3, 0, 0}};

    public Lst<Object> intersectPlane(P4 plane, T3[] vertices, int flags) {
        int i;
        Lst<Object> v = new Lst<Object>();
        P3[] edgePoints = new P3[12];
        int insideMask = 0;
        float[] values = new float[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            values[i2] = plane.x * vertices[i2].x + plane.y * vertices[i2].y + plane.z * vertices[i2].z + plane.w;
            if (!(values[i2] < 0.0f)) continue;
            insideMask |= Pwr2[i2];
        }
        byte[] triangles = triangleTable2[insideMask];
        if (triangles == null) {
            return null;
        }
        for (i = 0; i < 24; i += 2) {
            byte v1 = edgeVertexes[i];
            byte v2 = edgeVertexes[i + 1];
            P3 result = P3.newP(vertices[v2]);
            result.sub(vertices[v1]);
            result.scale(values[v1] / (values[v1] - values[v2]));
            result.add(vertices[v1]);
            edgePoints[i >> 1] = result;
        }
        if (flags == 0) {
            BS bsPoints = new BS();
            for (int i3 = 0; i3 < triangles.length; ++i3) {
                bsPoints.set(triangles[i3]);
                if (i3 % 4 != 2) continue;
                ++i3;
            }
            int nPoints = bsPoints.cardinality();
            P3[] pts = new P3[nPoints];
            v.addLast(pts);
            int[] list = new int[12];
            int ptList = 0;
            for (int i4 = 0; i4 < triangles.length; ++i4) {
                byte pt = triangles[i4];
                if (bsPoints.get(pt)) {
                    bsPoints.clear(pt);
                    pts[ptList] = edgePoints[pt];
                    list[pt] = (byte)ptList++;
                }
                if (i4 % 4 != 2) continue;
                ++i4;
            }
            int[][] polygons = AU.newInt2(triangles.length >> 2);
            v.addLast(polygons);
            for (int i5 = 0; i5 < triangles.length; ++i5) {
                polygons[i5 >> 2] = new int[]{list[triangles[i5++]], list[triangles[i5++]], list[triangles[i5++]], triangles[i5]};
            }
            return v;
        }
        for (i = 0; i < triangles.length; ++i) {
            P3 pt1 = edgePoints[triangles[i++]];
            P3 pt2 = edgePoints[triangles[i++]];
            P3 pt3 = edgePoints[triangles[i++]];
            if ((flags & 1) == 1) {
                v.addLast(new P3[]{pt1, pt2, pt3});
            }
            if ((flags & 2) != 2) continue;
            byte b = triangles[i];
            if ((b & 1) == 1) {
                v.addLast(new P3[]{pt1, pt2});
            }
            if ((b & 2) == 2) {
                v.addLast(new P3[]{pt2, pt3});
            }
            if ((b & 4) != 4) continue;
            v.addLast(new P3[]{pt1, pt3});
        }
        return v;
    }
}

