/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.V3;

public class SimpleUnitCell {
    protected float[] unitCellParams;
    public M4 matrixCartesianToFractional;
    public M4 matrixFractionalToCartesian;
    public double volume;
    protected static final float toRadians = (float)Math.PI / 180;
    private int na;
    private int nb;
    private int nc;
    protected float a;
    protected float b;
    protected float c;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected double cosAlpha;
    protected double sinAlpha;
    protected double cosBeta;
    protected double sinBeta;
    protected double cosGamma;
    protected double sinGamma;
    protected double cA_;
    protected double cB_;
    protected double a_;
    protected double b_;
    protected double c_;
    protected int dimension;
    private P3 fractionalOrigin = new P3();
    protected M4 matrixCtoFANoOffset;
    protected M4 matrixFtoCNoOffset;
    public static final int INFO_DIMENSIONS = 6;
    public static final int INFO_GAMMA = 5;
    public static final int INFO_BETA = 4;
    public static final int INFO_ALPHA = 3;
    public static final int INFO_C = 2;
    public static final int INFO_B = 1;
    public static final int INFO_A = 0;
    public static final float SLOP = 0.02f;
    private static final float SLOP1 = 0.98f;

    public boolean isSupercell() {
        return this.na > 1 || this.nb > 1 || this.nc > 1;
    }

    public static boolean isValid(float[] parameters) {
        return parameters != null && (parameters[0] > 0.0f || parameters.length > 14 && !Float.isNaN(parameters[14]));
    }

    protected SimpleUnitCell() {
    }

    public static SimpleUnitCell newA(float[] params) {
        SimpleUnitCell c = new SimpleUnitCell();
        c.init(params);
        return c;
    }

    protected void init(float[] params) {
        if (params == null) {
            params = new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f};
        }
        if (!SimpleUnitCell.isValid(params)) {
            return;
        }
        this.unitCellParams = AU.arrayCopyF(params, params.length);
        this.a = params[0];
        this.b = params[1];
        this.c = params[2];
        this.alpha = params[3];
        this.beta = params[4];
        this.gamma = params[5];
        this.na = Math.max(1, params.length >= 25 && !Float.isNaN(params[22]) ? (int)params[22] : 1);
        float fa = this.na;
        this.nb = Math.max(1, params.length >= 25 && !Float.isNaN(params[23]) ? (int)params[23] : 1);
        float fb = this.nb;
        this.nc = Math.max(1, params.length >= 25 && !Float.isNaN(params[24]) ? (int)params[24] : 1);
        float fc = this.nc;
        if (params.length > 25 && !Float.isNaN(params[25])) {
            float fScale = params[25];
            fa *= fScale;
            fb *= fScale;
            fc *= fScale;
        } else {
            fc = 1.0f;
            fb = 1.0f;
            fa = 1.0f;
        }
        if (this.a <= 0.0f) {
            V3 va = V3.new3(params[6], params[7], params[8]);
            V3 vb = V3.new3(params[9], params[10], params[11]);
            V3 vc = V3.new3(params[12], params[13], params[14]);
            this.setABC(va, vb, vc);
            if (this.c < 0.0f) {
                float[] n = AU.arrayCopyF(params, -1);
                if (this.b < 0.0f) {
                    vb.set(0.0f, 0.0f, 1.0f);
                    vb.cross(vb, va);
                    if (vb.length() < 0.001f) {
                        vb.set(0.0f, 1.0f, 0.0f);
                    }
                    vb.normalize();
                    n[9] = vb.x;
                    n[10] = vb.y;
                    n[11] = vb.z;
                }
                if (this.c < 0.0f) {
                    vc.cross(va, vb);
                    vc.normalize();
                    n[12] = vc.x;
                    n[13] = vc.y;
                    n[14] = vc.z;
                }
                params = n;
            }
        }
        this.a *= fa;
        if (this.b <= 0.0f) {
            this.c = 1.0f;
            this.b = 1.0f;
            this.dimension = 1;
        } else if (this.c <= 0.0f) {
            this.c = 1.0f;
            this.b *= fb;
            this.dimension = 2;
        } else {
            this.b *= fb;
            this.c *= fc;
            this.dimension = 3;
        }
        this.setCellParams();
        if (params.length > 21 && !Float.isNaN(params[21])) {
            float[] scaleMatrix = new float[16];
            for (int i = 0; i < 16; ++i) {
                float f;
                switch (i % 4) {
                    case 0: {
                        f = fa;
                        break;
                    }
                    case 1: {
                        f = fb;
                        break;
                    }
                    case 2: {
                        f = fc;
                        break;
                    }
                    default: {
                        f = 1.0f;
                    }
                }
                scaleMatrix[i] = params[6 + i] * f;
            }
            this.matrixCartesianToFractional = M4.newA16(scaleMatrix);
            this.matrixCartesianToFractional.getTranslation(this.fractionalOrigin);
            this.matrixFractionalToCartesian = M4.newM4(this.matrixCartesianToFractional).invert();
            if (params[0] == 1.0f) {
                this.setParamsFromMatrix();
            }
        } else if (params.length > 14 && !Float.isNaN(params[14])) {
            M4 m = this.matrixFractionalToCartesian = new M4();
            m.setColumn4(0, params[6] * fa, params[7] * fa, params[8] * fa, 0.0f);
            m.setColumn4(1, params[9] * fb, params[10] * fb, params[11] * fb, 0.0f);
            m.setColumn4(2, params[12] * fc, params[13] * fc, params[14] * fc, 0.0f);
            m.setColumn4(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = M4.newM4(this.matrixFractionalToCartesian).invert();
        } else {
            M4 m = this.matrixFractionalToCartesian = new M4();
            m.setColumn4(0, this.a, 0.0f, 0.0f, 0.0f);
            m.setColumn4(1, (float)((double)this.b * this.cosGamma), (float)((double)this.b * this.sinGamma), 0.0f, 0.0f);
            m.setColumn4(2, (float)((double)this.c * this.cosBeta), (float)((double)this.c * (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma), (float)(this.volume / ((double)(this.a * this.b) * this.sinGamma)), 0.0f);
            m.setColumn4(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = M4.newM4(this.matrixFractionalToCartesian).invert();
        }
        this.matrixCtoFANoOffset = this.matrixCartesianToFractional;
        this.matrixFtoCNoOffset = this.matrixFractionalToCartesian;
    }

    private void setParamsFromMatrix() {
        V3 va = V3.new3(1.0f, 0.0f, 0.0f);
        V3 vb = V3.new3(0.0f, 1.0f, 0.0f);
        V3 vc = V3.new3(0.0f, 0.0f, 1.0f);
        this.matrixFractionalToCartesian.rotate(va);
        this.matrixFractionalToCartesian.rotate(vb);
        this.matrixFractionalToCartesian.rotate(vc);
        this.setABC(va, vb, vc);
        this.setCellParams();
    }

    private void setABC(V3 va, V3 vb, V3 vc) {
        this.a = va.length();
        this.b = vb.length();
        this.c = vc.length();
        if (this.a == 0.0f) {
            return;
        }
        if (this.b == 0.0f) {
            this.c = -1.0f;
            this.b = -1.0f;
        } else if (this.c == 0.0f) {
            this.c = -1.0f;
        }
        this.alpha = this.b < 0.0f || this.c < 0.0f ? 90.0f : vb.angle(vc) / ((float)Math.PI / 180);
        this.beta = this.c < 0.0f ? 90.0f : va.angle(vc) / ((float)Math.PI / 180);
        this.gamma = this.b < 0.0f ? 90.0f : va.angle(vb) / ((float)Math.PI / 180);
    }

    private void setCellParams() {
        this.cosAlpha = Math.cos((float)Math.PI / 180 * this.alpha);
        this.sinAlpha = Math.sin((float)Math.PI / 180 * this.alpha);
        this.cosBeta = Math.cos((float)Math.PI / 180 * this.beta);
        this.sinBeta = Math.sin((float)Math.PI / 180 * this.beta);
        this.cosGamma = Math.cos((float)Math.PI / 180 * this.gamma);
        this.sinGamma = Math.sin((float)Math.PI / 180 * this.gamma);
        double unitVolume = Math.sqrt(this.sinAlpha * this.sinAlpha + this.sinBeta * this.sinBeta + this.sinGamma * this.sinGamma + 2.0 * this.cosAlpha * this.cosBeta * this.cosGamma - 2.0);
        this.volume = (double)(this.a * this.b * this.c) * unitVolume;
        this.cA_ = (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma;
        this.cB_ = unitVolume / this.sinGamma;
        this.a_ = (double)(this.b * this.c) * this.sinAlpha / this.volume;
        this.b_ = (double)(this.a * this.c) * this.sinBeta / this.volume;
        this.c_ = (double)(this.a * this.b) * this.sinGamma / this.volume;
    }

    public T3 getFractionalOrigin() {
        return this.fractionalOrigin;
    }

    public P3 toSupercell(P3 fpt) {
        fpt.x /= (float)this.na;
        fpt.y /= (float)this.nb;
        fpt.z /= (float)this.nc;
        return fpt;
    }

    public final void toCartesian(T3 pt, boolean ignoreOffset) {
        if (this.matrixFractionalToCartesian != null) {
            (ignoreOffset ? this.matrixFtoCNoOffset : this.matrixFractionalToCartesian).rotTrans(pt);
        }
    }

    public void toFractionalM(M4 m) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        m.mul(this.matrixFractionalToCartesian);
        m.mul2(this.matrixCartesianToFractional, m);
    }

    public final void toFractional(T3 pt, boolean ignoreOffset) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        (ignoreOffset ? this.matrixCtoFANoOffset : this.matrixCartesianToFractional).rotTrans(pt);
    }

    public boolean isPolymer() {
        return this.dimension == 1;
    }

    public boolean isSlab() {
        return this.dimension == 2;
    }

    public final float[] getUnitCellParams() {
        return this.unitCellParams;
    }

    public final float[] getUnitCellAsArray(boolean vectorsOnly) {
        float[] fArray;
        M4 m = this.matrixFractionalToCartesian;
        if (vectorsOnly) {
            float[] fArray2 = new float[9];
            fArray2[0] = m.m00;
            fArray2[1] = m.m10;
            fArray2[2] = m.m20;
            fArray2[3] = m.m01;
            fArray2[4] = m.m11;
            fArray2[5] = m.m21;
            fArray2[6] = m.m02;
            fArray2[7] = m.m12;
            fArray = fArray2;
            fArray2[8] = m.m22;
        } else {
            float[] fArray3 = new float[17];
            fArray3[0] = this.a;
            fArray3[1] = this.b;
            fArray3[2] = this.c;
            fArray3[3] = this.alpha;
            fArray3[4] = this.beta;
            fArray3[5] = this.gamma;
            fArray3[6] = m.m00;
            fArray3[7] = m.m10;
            fArray3[8] = m.m20;
            fArray3[9] = m.m01;
            fArray3[10] = m.m11;
            fArray3[11] = m.m21;
            fArray3[12] = m.m02;
            fArray3[13] = m.m12;
            fArray3[14] = m.m22;
            fArray3[15] = this.dimension;
            fArray = fArray3;
            fArray3[16] = (float)this.volume;
        }
        return fArray;
    }

    public final float getInfo(int infoType) {
        switch (infoType) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.alpha;
            }
            case 4: {
                return this.beta;
            }
            case 5: {
                return this.gamma;
            }
            case 6: {
                return this.dimension;
            }
        }
        return Float.NaN;
    }

    public static void ijkToPoint3f(int nnn, P3 cell, int offset) {
        int f = nnn > 1000000000 ? 1000 : (nnn > 1000000 ? 100 : 10);
        int f2 = f * f;
        cell.x = nnn / f2 % f + (offset -= offset >= 0 ? 5 * f / 10 : offset);
        cell.y = nnn % f2 / f + offset;
        cell.z = nnn % f + offset;
    }

    public static float getCellWeight(P3 pt) {
        float f = 1.0f;
        if (pt.x <= 0.02f || pt.x >= 0.98f) {
            f /= 2.0f;
        }
        if (pt.y <= 0.02f || pt.y >= 0.98f) {
            f /= 2.0f;
        }
        if (pt.z <= 0.02f || pt.z >= 0.98f) {
            f /= 2.0f;
        }
        return f;
    }

    public static T3[] getReciprocal(T3[] abc, T3[] ret, float scale) {
        int i;
        T3[] rabc = new P3[4];
        int off = abc.length == 4 ? 1 : 0;
        rabc[0] = off == 1 ? P3.newP(abc[0]) : new P3();
        for (i = 0; i < 3; ++i) {
            rabc[i + 1] = new P3();
            rabc[i + 1].cross(abc[(i + off) % 3 + off], abc[(i + off + 1) % 3 + off]);
            rabc[i + 1].scale(scale / abc[i + off].dot(rabc[i + 1]));
        }
        if (ret == null) {
            return rabc;
        }
        for (i = 0; i < 4; ++i) {
            ret[i] = rabc[i];
        }
        return ret;
    }

    public static T3[] setOabc(String abcabg, float[] params, T3[] ucnew) {
        if (abcabg != null) {
            String[] tokens;
            if (params == null) {
                params = new float[6];
            }
            if ((tokens = PT.split(abcabg.replace(',', '='), "=")).length >= 12) {
                for (int i = 0; i < 6; ++i) {
                    params[i] = PT.parseFloat(tokens[i * 2 + 1]);
                }
            }
        }
        if (ucnew == null) {
            return null;
        }
        float[] f = SimpleUnitCell.newA(params).getUnitCellAsArray(true);
        ucnew[1].set(f[0], f[1], f[2]);
        ucnew[2].set(f[3], f[4], f[5]);
        ucnew[3].set(f[6], f[7], f[8]);
        return ucnew;
    }
}

