/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.ImageView;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class JosmImageView
extends ImageView {
    private static final int LOADING_FLAG = 1;
    private static final int WIDTH_FLAG = 4;
    private static final int HEIGHT_FLAG = 8;
    private static final int RELOAD_FLAG = 16;
    private static final int RELOAD_IMAGE_FLAG = 32;
    private final Field imageField = ImageView.class.getDeclaredField("image");
    private final Field stateField = ImageView.class.getDeclaredField("state");
    private final Field widthField = ImageView.class.getDeclaredField("width");
    private final Field heightField = ImageView.class.getDeclaredField("height");

    public JosmImageView(Element element) throws NoSuchFieldException {
        super(element);
        Utils.setObjectsAccessible(this.imageField, this.stateField, this.widthField, this.heightField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSync() {
        block6: {
            try {
                int n = (Integer)this.stateField.get(this);
                if ((n & 0x20) != 0) {
                    this.doRefreshImage();
                }
                if (((n = ((Integer)this.stateField.get(this)).intValue()) & 0x10) == 0) break block6;
                JosmImageView josmImageView = this;
                synchronized (josmImageView) {
                    this.stateField.set(this, ((Integer)this.stateField.get(this) | 0x10) ^ 0x10);
                }
                this.setPropertiesFromAttributes();
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                Main.error(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefreshImage() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this;
        synchronized (object) {
            this.stateField.set(this, ((Integer)this.stateField.get(this) | 1 | 0x20 | 4 | 8) ^ 0x2C);
            this.imageField.set(this, null);
            this.widthField.set(this, 0);
            this.heightField.set(this, 0);
        }
        try {
            this.doLoadImage();
            object = ImageView.class.getDeclaredMethod("updateImageSize", new Class[0]);
            Utils.setObjectsAccessible(new AccessibleObject[]{object});
            ((Method)object).invoke((Object)this, new Object[0]);
        }
        finally {
            object = this;
            synchronized (object) {
                this.stateField.set(this, ((Integer)this.stateField.get(this) | 1) ^ 1);
            }
        }
    }

    private void doLoadImage() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        URL uRL = this.getImageURL();
        if (uRL != null) {
            String string = uRL.toExternalForm();
            if (string.endsWith(".svg") || string.endsWith(".svg?format=raw")) {
                ImageIcon imageIcon = new ImageProvider(string).setOptional(true).get();
                this.imageField.set(this, imageIcon != null ? imageIcon.getImage() : null);
            } else {
                Method method = ImageView.class.getDeclaredMethod("loadImage", new Class[0]);
                Utils.setObjectsAccessible(method);
                method.invoke((Object)this, new Object[0]);
            }
        } else {
            this.imageField.set(this, null);
        }
    }

    @Override
    public Image getImage() {
        this.doSync();
        return super.getImage();
    }

    @Override
    public AttributeSet getAttributes() {
        this.doSync();
        return super.getAttributes();
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        this.doSync();
        super.paint(graphics, shape);
    }

    @Override
    public float getPreferredSpan(int n) {
        this.doSync();
        return super.getPreferredSpan(n);
    }

    @Override
    public void setSize(float f, float f2) {
        this.doSync();
        super.setSize(f, f2);
    }
}

