/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.diagram.DiagramHandler;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.command.AddElement;
import com.baselet.gui.command.ClipBoard;
import com.baselet.gui.command.Command;
import com.baselet.gui.command.RemoveElement;
import java.awt.Point;
import java.util.Vector;

public class Cut
extends Command {
    private Vector<GridElement> entities;
    private Point origin;

    @Override
    public void execute(DiagramHandler handler) {
        super.execute(handler);
        if (this.entities == null) {
            this.entities = new Vector();
            this.entities.addAll(handler.getDrawPanel().getSelector().getSelectedElements());
        }
        if (this.entities.isEmpty()) {
            return;
        }
        ClipBoard.getInstance().copyAndZoomToDefaultLevel(this.entities, handler);
        new RemoveElement(this.entities, false).execute(handler);
        this.origin = handler.getDrawPanel().getOriginAtDefaultZoom();
        handler.getDrawPanel().updatePanelAndScrollbars();
    }

    @Override
    public void undo(DiagramHandler handler) {
        super.undo(handler);
        int oldZoom = handler.getGridSize();
        handler.setGridAndZoom(10, false);
        int offsetX = this.origin.x - handler.getDrawPanel().getOriginAtDefaultZoom().x;
        int offsetY = this.origin.y - handler.getDrawPanel().getOriginAtDefaultZoom().y;
        for (GridElement e : this.entities) {
            new AddElement(e, handler.realignToGrid(true, e.getRectangle().x + offsetX), handler.realignToGrid(true, e.getRectangle().y + offsetY), false).execute(handler);
        }
        handler.getDrawPanel().repaint();
        handler.setGridAndZoom(oldZoom, false);
        handler.getDrawPanel().getSelector().select(this.entities);
        handler.getDrawPanel().updatePanelAndScrollbars();
    }
}

