/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.io.File;
import org.zaproxy.zap.db.sql.HsqldbDatabaseServer;
import org.zaproxy.zap.db.sql.SqlDatabase;
import org.zaproxy.zap.db.sql.SqlDatabaseServer;

public class HsqldbDatabase
extends SqlDatabase {
    @Override
    public void deleteSession(String string) {
        super.deleteSession(string);
        this.logger.debug((Object)("deleteSession " + string));
        this.deleteDbFile(new File(string));
        this.deleteDbFile(new File(string + ".data"));
        this.deleteDbFile(new File(string + ".script"));
        this.deleteDbFile(new File(string + ".properties"));
        this.deleteDbFile(new File(string + ".backup"));
        this.deleteDbFile(new File(string + ".lobs"));
    }

    private void deleteDbFile(File file) {
        this.logger.debug((Object)("Deleting " + file.getAbsolutePath()));
        if (file.exists() && !file.delete()) {
            this.logger.error((Object)("Failed to delete " + file.getAbsolutePath()));
        }
    }

    @Override
    protected SqlDatabaseServer createDatabaseServer(String string) throws Exception {
        return new HsqldbDatabaseServer(string);
    }

    @Override
    public void close(boolean bl, boolean bl2) {
        this.logger.debug((Object)"close");
        super.close(bl, bl2);
        if (this.getDatabaseServer() == null) {
            return;
        }
        try {
            ((HsqldbDatabaseServer)this.getDatabaseServer()).shutdown(bl);
        }
        catch (Exception exception) {
            this.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public boolean isFileBased() {
        return true;
    }
}

