/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class PythonAPIGenerator
extends AbstractAPIGenerator {
    private static final String DEFAULT_OUTPUT_DIR = "../zap-api-python/src/zapv2/";
    private final String HEADER = "# Zed Attack Proxy (ZAP) and its related class files.\n#\n# ZAP is an HTTP/HTTPS proxy for assessing web application security.\n#\n# Copyright 2016 the ZAP development team\n#\n# Licensed under the Apache License, Version 2.0 (the \"License\");\n# you may not use this file except in compliance with the License.\n# You may obtain a copy of the License at\n#\n#   http://www.apache.org/licenses/LICENSE-2.0\n#\n# Unless required by applicable law or agreed to in writing, software\n# distributed under the License is distributed on an \"AS IS\" BASIS,\n# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n# See the License for the specific language governing permissions and\n# limitations under the License.\n\"\"\"\nThis file was automatically generated.\n\"\"\"\n\n";
    private static final Map<String, String> nameMap;

    public PythonAPIGenerator() {
        super(DEFAULT_OUTPUT_DIR);
    }

    public PythonAPIGenerator(String string, boolean bl) {
        super(string, bl);
    }

    @Deprecated
    public void generatePythonFiles(List<ApiImplementor> list) throws IOException {
        this.generateAPIFiles((List)list);
    }

    private void generatePythonElement(ApiElement apiElement, String string, String string2, Writer writer) throws IOException {
        String string32;
        boolean bl;
        block28: {
            boolean bl2 = bl = apiElement.getMandatoryParamNames() != null && apiElement.getMandatoryParamNames().size() > 0 || apiElement.getOptionalParamNames() != null && apiElement.getOptionalParamNames().size() > 0;
            if (!bl && string2.equals("view")) {
                writer.write("    @property\n");
            }
            writer.write("    def " + PythonAPIGenerator.createFunctionName(apiElement.getName()) + "(self");
            if (apiElement.getMandatoryParamNames() != null) {
                for (String string32 : apiElement.getMandatoryParamNames()) {
                    writer.write(", " + string32.toLowerCase());
                }
            }
            if (apiElement.getOptionalParamNames() != null) {
                for (String string32 : apiElement.getOptionalParamNames()) {
                    writer.write(", " + string32.toLowerCase() + "=None");
                }
            }
            if (string2.equals("action") || string2.equals("other")) {
                writer.write(", " + API.API_KEY_PARAM + "=''");
                bl = true;
            }
            writer.write("):\n");
            Object object = apiElement.getDescriptionTag();
            if (object == null) {
                object = string + ".api." + string2 + "." + apiElement.getName();
            }
            try {
                string32 = this.getMessages().getString((String)object);
                writer.write("        \"\"\"\n");
                writer.write("        " + string32 + "\n");
                if (this.isOptional()) {
                    writer.write("        This component is optional and therefore the API will only work if it is installed\n");
                }
                writer.write("        \"\"\"\n");
            }
            catch (Exception exception) {
                System.out.println("No i18n for: " + (String)object);
                if (!this.isOptional()) break block28;
                writer.write("        \"\"\"\n");
                writer.write("        This component is optional and therefore the API will only work if it is installed\n");
                writer.write("        \"\"\"\n");
            }
        }
        string32 = "_request";
        String string4 = "base";
        if (string2.equals("other")) {
            string32 = string32 + "_other";
            string4 = string4 + "_other";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("{");
            boolean bl3 = true;
            if (apiElement.getMandatoryParamNames() != null) {
                for (String string5 : apiElement.getMandatoryParamNames()) {
                    if (bl3) {
                        bl3 = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("'" + string5 + "' : " + string5.toLowerCase());
                }
            }
            if (string2.equals("action") || string2.equals("other")) {
                if (!bl3) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("'").append(API.API_KEY_PARAM).append("' : ").append(API.API_KEY_PARAM);
            }
            stringBuilder.append("}");
            if (apiElement.getOptionalParamNames() != null && !apiElement.getOptionalParamNames().isEmpty()) {
                writer.write("        params = ");
                writer.write(stringBuilder.toString());
                writer.write("\n");
                stringBuilder.replace(0, stringBuilder.length(), "params");
                for (String string5 : apiElement.getOptionalParamNames()) {
                    writer.write("        if " + string5.toLowerCase() + " is not None:\n");
                    writer.write("            params['" + string5 + "'] = " + string5.toLowerCase() + "\n");
                }
            }
        }
        if (string2.equals("other")) {
            writer.write("        return (");
        } else {
            writer.write("        return next(");
        }
        writer.write("self.zap." + string32 + "(self.zap." + string4 + " + '" + string + "/" + string2 + "/" + apiElement.getName() + "/'");
        if (bl) {
            writer.write(", ");
            writer.write(stringBuilder.toString());
            writer.write(")");
            if (!string2.equals("other")) {
                writer.write(".itervalues())");
            } else {
                writer.write(")");
            }
        } else if (!string2.equals("other")) {
            writer.write(").itervalues())");
        } else {
            writer.write(")");
        }
        writer.write("\n\n");
    }

    @Override
    protected void generateAPIFiles(ApiImplementor apiImplementor) throws IOException {
        Path path = this.getDirectory().resolve(PythonAPIGenerator.createFileName(apiImplementor.getPrefix()));
        System.out.println("Generating " + path.toAbsolutePath());
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            bufferedWriter.write("# Zed Attack Proxy (ZAP) and its related class files.\n#\n# ZAP is an HTTP/HTTPS proxy for assessing web application security.\n#\n# Copyright 2016 the ZAP development team\n#\n# Licensed under the Apache License, Version 2.0 (the \"License\");\n# you may not use this file except in compliance with the License.\n# You may obtain a copy of the License at\n#\n#   http://www.apache.org/licenses/LICENSE-2.0\n#\n# Unless required by applicable law or agreed to in writing, software\n# distributed under the License is distributed on an \"AS IS\" BASIS,\n# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n# See the License for the specific language governing permissions and\n# limitations under the License.\n\"\"\"\nThis file was automatically generated.\n\"\"\"\n\n");
            bufferedWriter.write("class " + PythonAPIGenerator.safeName(apiImplementor.getPrefix()) + "(object):\n\n");
            bufferedWriter.write("    def __init__(self, zap):\n");
            bufferedWriter.write("        self.zap = zap\n");
            bufferedWriter.write("\n");
            for (ApiElement apiElement : apiImplementor.getApiViews()) {
                this.generatePythonElement(apiElement, apiImplementor.getPrefix(), "view", bufferedWriter);
            }
            for (ApiElement apiElement : apiImplementor.getApiActions()) {
                this.generatePythonElement(apiElement, apiImplementor.getPrefix(), "action", bufferedWriter);
            }
            for (ApiElement apiElement : apiImplementor.getApiOthers()) {
                this.generatePythonElement(apiElement, apiImplementor.getPrefix(), "other", bufferedWriter);
            }
            bufferedWriter.write("\n");
        }
    }

    private static String safeName(String string) {
        if (nameMap.containsKey(string)) {
            return nameMap.get(string);
        }
        return string;
    }

    private static String createFileName(String string) {
        return PythonAPIGenerator.safeName(string) + ".py";
    }

    private static String createFunctionName(String string) {
        return PythonAPIGenerator.removeAllFullStopCharacters(PythonAPIGenerator.camelCaseToLcUnderscores(PythonAPIGenerator.safeName(string)));
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    public static String camelCaseToLcUnderscores(String string) {
        return PythonAPIGenerator.safeName(string).replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), "_").toLowerCase();
    }

    public static void main(String[] stringArray) throws Exception {
        if (!Files.exists(Paths.get(DEFAULT_OUTPUT_DIR, new String[0]), new LinkOption[0])) {
            System.err.println("The directory does not exist: " + Paths.get(DEFAULT_OUTPUT_DIR, new String[0]).toAbsolutePath());
            System.exit(1);
        }
        PythonAPIGenerator pythonAPIGenerator = new PythonAPIGenerator();
        pythonAPIGenerator.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("break", "brk");
        hashMap.put("continue", "cont");
        nameMap = Collections.unmodifiableMap(hashMap);
    }
}

