/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.sew;

import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitPoint
implements Comparable<SplitPoint> {
    private SplitPoint _nextPoint = null;
    private Coordinate _longitude = null;
    private Coordinate _latitude = null;
    private int _pointIndex = 0;
    private double _distToPrevPoint = 0.0;
    private double _distToNextPoint = -1.0;

    public SplitPoint(DataPoint dataPoint, int n) {
        this._longitude = dataPoint.getLongitude();
        this._latitude = dataPoint.getLatitude();
        this._pointIndex = n;
    }

    public void setDistanceToPrevPoint(double d) {
        this._distToPrevPoint = d;
    }

    public double getDistanceToPrevPoint() {
        return this._distToPrevPoint;
    }

    public void setDistanceToNextPoint(double d) {
        this._distToNextPoint = d;
    }

    public double getDistanceToNextPoint() {
        return this._distToNextPoint;
    }

    public boolean closerToNext() {
        return this._distToNextPoint > 0.0 && this._distToNextPoint < this._distToPrevPoint;
    }

    public int getPointIndex() {
        return this._pointIndex;
    }

    public void setNextPoint(SplitPoint splitPoint) {
        this._nextPoint = splitPoint;
    }

    public SplitPoint getNextPoint() {
        return this._nextPoint;
    }

    public boolean atSamePointAs(SplitPoint splitPoint) {
        return splitPoint != null && this._latitude.equals(splitPoint._latitude) && this._longitude.equals(splitPoint._longitude);
    }

    @Override
    public int compareTo(SplitPoint splitPoint) {
        if (splitPoint == null) {
            return -1;
        }
        if (!this._latitude.equals(splitPoint._latitude)) {
            return this._latitude.getDouble() < splitPoint._latitude.getDouble() ? -1 : 1;
        }
        if (!this._longitude.equals(splitPoint._longitude)) {
            return this._longitude.getDouble() < splitPoint._longitude.getDouble() ? -1 : 1;
        }
        return this._pointIndex - splitPoint._pointIndex;
    }
}

