/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import java.io.IOException;

public final class BufferBoundsException
extends IOException {
    private static final long serialVersionUID = 2911102837808946396L;

    public BufferBoundsException(int n, int n2, long l) {
        super(BufferBoundsException.getMessage(n, n2, l));
    }

    public BufferBoundsException(String string) {
        super(string);
    }

    private static String getMessage(int n, int n2, long l) {
        if (n < 0) {
            return String.format("Attempt to read from buffer using a negative index (%d)", n);
        }
        if (n2 < 0) {
            return String.format("Number of requested bytes cannot be negative (%d)", n2);
        }
        if ((long)n + (long)n2 - 1L > Integer.MAX_VALUE) {
            return String.format("Number of requested bytes summed with starting index exceed maximum range of signed 32 bit integers (requested index: %d, requested count: %d)", n, n2);
        }
        return String.format("Attempt to read from beyond end of underlying data source (requested index: %d, requested count: %d, max index: %d)", n, n2, l - 1L);
    }
}

