/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.tools.Utils;

public class LineElement
extends StyleElement {
    public static final LineElement UNTAGGED_WAY = LineElement.createSimpleLineStyle(null, false);
    private final BasicStroke line;
    public Color color;
    public Color dashesBackground;
    public float offset;
    public float realWidth;
    public boolean wayDirectionArrows;
    private final BasicStroke dashesLine;

    protected LineElement(Cascade cascade, float f, BasicStroke basicStroke, Color color, BasicStroke basicStroke2, Color color2, float f2, float f3, boolean bl) {
        super(cascade, f);
        this.line = basicStroke;
        this.color = color;
        this.dashesLine = basicStroke2;
        this.dashesBackground = color2;
        this.offset = f2;
        this.realWidth = f3;
        this.wayDirectionArrows = bl;
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.defaultSelectedHandling ? !this.isModifier && (bl || mapPaintSettings.isShowDirectionArrow()) && !mapPaintSettings.isUseRealWidth() : this.wayDirectionArrows;
        boolean bl5 = !this.isModifier && !bl && !mapPaintSettings.isUseRealWidth() && mapPaintSettings.isShowOnewayArrow() && osmPrimitive.hasDirectionKeys();
        boolean bl6 = osmPrimitive.reversedDirection();
        boolean bl7 = bl4 && !bl && mapPaintSettings.isShowHeadArrowOnly();
        Color color = this.dashesBackground;
        BasicStroke basicStroke = this.line;
        BasicStroke basicStroke2 = this.dashesLine;
        if (this.realWidth > 0.0f && mapPaintSettings.isUseRealWidth() && !bl4) {
            float f = (int)(100.0f / (float)(styledMapRenderer.getCircum() / (double)this.realWidth));
            if (f < this.line.getLineWidth()) {
                f = this.line.getLineWidth();
            }
            basicStroke = new BasicStroke(f, this.line.getEndCap(), this.line.getLineJoin(), this.line.getMiterLimit(), this.line.getDashArray(), this.line.getDashPhase());
            if (this.dashesLine != null) {
                basicStroke2 = new BasicStroke(f, this.dashesLine.getEndCap(), this.dashesLine.getLineJoin(), this.dashesLine.getMiterLimit(), this.dashesLine.getDashArray(), this.dashesLine.getDashPhase());
            }
        }
        Color color2 = this.color;
        if (this.defaultSelectedHandling && bl) {
            color2 = mapPaintSettings.getSelectedColor(this.color.getAlpha());
        } else if (bl3 || bl2) {
            color2 = mapPaintSettings.getRelationSelectedColor(this.color.getAlpha());
        } else if (osmPrimitive.isDisabled()) {
            color2 = mapPaintSettings.getInactiveColor();
            color = mapPaintSettings.getInactiveColor();
        }
        if (osmPrimitive instanceof Way) {
            Way way = (Way)osmPrimitive;
            styledMapRenderer.drawWay(way, color2, basicStroke, basicStroke2, color, this.offset, bl4, bl7, bl5, bl6);
            if ((mapPaintSettings.isShowOrderNumber() || mapPaintSettings.isShowOrderNumberOnSelectedWay() && bl) && !styledMapRenderer.isInactiveMode()) {
                int n = 0;
                Node node = null;
                for (Node node2 : way.getNodes()) {
                    if (node != null) {
                        styledMapRenderer.drawOrderNumber(node, node2, ++n, color2);
                    }
                    node = node2;
                }
            }
        }
    }

    @Override
    public boolean isProperLineStyle() {
        return !this.isModifier;
    }

    public String linejoinToString(int n) {
        switch (n) {
            case 2: {
                return "bevel";
            }
            case 1: {
                return "round";
            }
            case 0: {
                return "miter";
            }
        }
        return null;
    }

    public String linecapToString(int n) {
        switch (n) {
            case 0: {
                return "none";
            }
            case 1: {
                return "round";
            }
            case 2: {
                return "square";
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        LineElement lineElement = (LineElement)object;
        return this.offset == lineElement.offset && this.realWidth == lineElement.realWidth && this.wayDirectionArrows == lineElement.wayDirectionArrows && Objects.equals(this.line, lineElement.line) && Objects.equals(this.color, lineElement.color) && Objects.equals(this.dashesLine, lineElement.dashesLine) && Objects.equals(this.dashesBackground, lineElement.dashesBackground);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.line, this.color, this.dashesBackground, Float.valueOf(this.offset), Float.valueOf(this.realWidth), this.wayDirectionArrows, this.dashesLine);
    }

    @Override
    public String toString() {
        return "LineElemStyle{" + super.toString() + "width=" + this.line.getLineWidth() + " realWidth=" + this.realWidth + " color=" + Utils.toString(this.color) + " dashed=" + Arrays.toString(this.line.getDashArray()) + (this.line.getDashPhase() == 0.0f ? "" : " dashesOffses=" + this.line.getDashPhase()) + " dashedColor=" + Utils.toString(this.dashesBackground) + " linejoin=" + this.linejoinToString(this.line.getLineJoin()) + " linecap=" + this.linecapToString(this.line.getEndCap()) + (this.offset == 0.0f ? "" : " offset=" + this.offset) + '}';
    }

    public static LineElement createSimpleLineStyle(Color color, boolean bl) {
        MultiCascade multiCascade = new MultiCascade();
        Cascade cascade = multiCascade.getOrCreateCascade("default");
        cascade.put("width", Keyword.DEFAULT);
        cascade.put("color", color != null ? color : PaintColors.UNTAGGED.get());
        cascade.put("opacity", Float.valueOf(1.0f));
        if (bl) {
            cascade.put("z-index", Float.valueOf(-3.0f));
        }
        Way way = new Way();
        return LineElement.createLine(new Environment(way, multiCascade, "default", null));
    }

    public static LineElement createLine(Environment environment) {
        return LineElement.createImpl(environment, LineType.NORMAL);
    }

    public static LineElement createLeftCasing(Environment environment) {
        LineElement lineElement = LineElement.createImpl(environment, LineType.LEFT_CASING);
        if (lineElement != null) {
            lineElement.isModifier = true;
        }
        return lineElement;
    }

    public static LineElement createRightCasing(Environment environment) {
        LineElement lineElement = LineElement.createImpl(environment, LineType.RIGHT_CASING);
        if (lineElement != null) {
            lineElement.isModifier = true;
        }
        return lineElement;
    }

    public static LineElement createCasing(Environment environment) {
        LineElement lineElement = LineElement.createImpl(environment, LineType.CASING);
        if (lineElement != null) {
            lineElement.isModifier = true;
        }
        return lineElement;
    }

    private static LineElement createImpl(Environment environment, LineType lineType) {
        float f;
        Integer n;
        Cascade cascade;
        Cascade cascade2 = environment.mc.getCascade(environment.layer);
        Float f2 = LineElement.computeWidth(lineType, cascade2, cascade = environment.mc.getCascade("default"));
        if (f2 == null) {
            return null;
        }
        float f3 = LineElement.computeRealWidth(environment, lineType, cascade2);
        Float f4 = LineElement.computeOffset(lineType, cascade2, cascade, f2);
        int n2 = 255;
        Color color = cascade2.get(lineType.prefix + "color", null, Color.class);
        if (color != null) {
            n2 = color.getAlpha();
        }
        if (lineType == LineType.NORMAL && color == null) {
            color = cascade2.get("fill-color", null, Color.class);
        }
        if (color == null) {
            color = PaintColors.UNTAGGED.get();
        }
        if ((n = Utils.colorFloat2int(cascade2.get(lineType.prefix + "opacity", null, Float.class))) != null) {
            n2 = n;
        }
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), n2);
        float[] fArray = cascade2.get(lineType.prefix + "dashes", null, float[].class, true);
        if (fArray != null) {
            boolean bl = false;
            for (float f5 : fArray) {
                if (f5 > 0.0f) {
                    bl = true;
                }
                if (!(f5 < 0.0f)) continue;
                fArray = null;
                break;
            }
            if (!bl || fArray != null && fArray.length == 0) {
                fArray = null;
            }
        }
        float f6 = cascade2.get(lineType.prefix + "dashes-offset", Float.valueOf(0.0f), Float.class).floatValue();
        Object object = cascade2.get(lineType.prefix + "dashes-background-color", null, Color.class);
        if (object != null) {
            n = Utils.colorFloat2int(cascade2.get(lineType.prefix + "dashes-background-opacity", null, Float.class));
            if (n != null) {
                n2 = n;
            }
            object = new Color(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), n2);
        }
        Integer n3 = null;
        Keyword keyword = cascade2.get(lineType.prefix + "linecap", null, Keyword.class);
        if (keyword != null) {
            if ("none".equals(keyword.val)) {
                n3 = 0;
            } else if ("round".equals(keyword.val)) {
                n3 = 1;
            } else if ("square".equals(keyword.val)) {
                n3 = 2;
            }
        }
        if (n3 == null) {
            n3 = fArray != null ? 0 : 1;
        }
        Integer n4 = null;
        Keyword keyword2 = cascade2.get(lineType.prefix + "linejoin", null, Keyword.class);
        if (keyword2 != null) {
            if ("round".equals(keyword2.val)) {
                n4 = 1;
            } else if ("miter".equals(keyword2.val)) {
                n4 = 0;
            } else if ("bevel".equals(keyword2.val)) {
                n4 = 2;
            }
        }
        if (n4 == null) {
            n4 = 1;
        }
        if ((f = cascade2.get(lineType.prefix + "miterlimit", Float.valueOf(10.0f), Float.class).floatValue()) < 1.0f) {
            f = 10.0f;
        }
        BasicStroke basicStroke = new BasicStroke(f2.floatValue(), n3, n4, f, fArray, f6);
        BasicStroke basicStroke2 = null;
        if (fArray != null && object != null) {
            float[] fArray2 = new float[fArray.length];
            System.arraycopy(fArray, 0, fArray2, 1, fArray.length - 1);
            fArray2[0] = fArray[fArray.length - 1];
            basicStroke2 = new BasicStroke(f2.floatValue(), n3, n4, f, fArray2, fArray2[0] + f6);
        }
        boolean bl = cascade2.get(lineType.prefix + "way-direction-arrows", environment.osm.isSelected(), Boolean.class);
        return new LineElement(cascade2, lineType.defaultMajorZIndex, basicStroke, color, basicStroke2, (Color)object, f4.floatValue(), f3, bl);
    }

    private static Float computeWidth(LineType lineType, Cascade cascade, Cascade cascade2) {
        Float f;
        switch (lineType) {
            case NORMAL: {
                f = LineElement.getWidth(cascade, "width", LineElement.getWidth(cascade2, "width", null));
                break;
            }
            case CASING: {
                Instruction.RelativeFloat relativeFloat;
                Float f2 = cascade.get(lineType.prefix + "width", null, Float.class, true);
                if (f2 == null && (relativeFloat = cascade.get(lineType.prefix + "width", null, Instruction.RelativeFloat.class, true)) != null) {
                    f2 = Float.valueOf(relativeFloat.val / 2.0f);
                }
                if (f2 == null) {
                    return null;
                }
                f = Float.valueOf(Optional.ofNullable(LineElement.getWidth(cascade, "width", LineElement.getWidth(cascade2, "width", null))).orElse(Float.valueOf(0.0f)).floatValue() + 2.0f * f2.floatValue());
                break;
            }
            case LEFT_CASING: 
            case RIGHT_CASING: {
                f = LineElement.getWidth(cascade, lineType.prefix + "width", null);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return f;
    }

    private static float computeRealWidth(Environment environment, LineType lineType, Cascade cascade) {
        String string;
        float f = cascade.get(lineType.prefix + "real-width", Float.valueOf(0.0f), Float.class).floatValue();
        if (f > 0.0f && MapPaintSettings.INSTANCE.isUseRealWidth() && (string = Optional.ofNullable(environment.osm.get("width")).orElseGet(() -> environment.osm.get("est_width"))) != null) {
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                Main.warn(numberFormatException);
            }
        }
        return f;
    }

    private static Float computeOffset(LineType lineType, Cascade cascade, Cascade cascade2, Float f) {
        Float f2 = cascade.get("offset", Float.valueOf(0.0f), Float.class);
        switch (lineType) {
            case NORMAL: {
                break;
            }
            case CASING: {
                f2 = Float.valueOf(f2.floatValue() + cascade.get(lineType.prefix + "offset", Float.valueOf(0.0f), Float.class).floatValue());
                break;
            }
            case LEFT_CASING: 
            case RIGHT_CASING: {
                Float f3 = LineElement.getWidth(cascade2, "width", null);
                Float f4 = LineElement.getWidth(cascade, "width", f3);
                if (f4 == null || f4.floatValue() < 2.0f) {
                    f4 = Float.valueOf(2.0f);
                }
                float f5 = cascade.get(lineType.prefix + "offset", Float.valueOf(0.0f), Float.class).floatValue();
                f5 += f4.floatValue() / 2.0f + f.floatValue() / 2.0f;
                if (lineType == LineType.RIGHT_CASING) {
                    f5 *= -1.0f;
                }
                f2 = Float.valueOf(f2.floatValue() + f5);
            }
        }
        return f2;
    }

    public static enum LineType {
        NORMAL("", 3.0f),
        CASING("casing-", 2.0f),
        LEFT_CASING("left-casing-", 2.1f),
        RIGHT_CASING("right-casing-", 2.1f);

        public final String prefix;
        public final float defaultMajorZIndex;

        private LineType(String string2, float f) {
            this.prefix = string2;
            this.defaultMajorZIndex = f;
        }
    }
}

