/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.provider.DSAKeyFactory;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;
import sun.security.provider.DSAPublicKeyImpl;
import sun.security.provider.ParameterCache;

public class DSAKeyPairGenerator
extends KeyPairGenerator
implements java.security.interfaces.DSAKeyPairGenerator {
    private int plen;
    private int qlen;
    private boolean forceNewParameters;
    private DSAParameterSpec params;
    private SecureRandom random;

    public DSAKeyPairGenerator() {
        super("DSA");
        this.initialize(1024, null);
    }

    private static void checkStrength(int sizeP, int sizeQ) {
        if ((sizeP < 512 || sizeP > 1024 || sizeP % 64 != 0 || sizeQ != 160) && (sizeP != 2048 || sizeQ != 224 && sizeQ != 256)) {
            throw new InvalidParameterException("Unsupported prime and subprime size combination: " + sizeP + ", " + sizeQ);
        }
    }

    @Override
    public void initialize(int modlen, SecureRandom random) {
        this.initialize(modlen, false, random);
    }

    @Override
    public void initialize(int modlen, boolean genParams, SecureRandom random) {
        int subPrimeLen = -1;
        if (modlen <= 1024) {
            subPrimeLen = 160;
        } else if (modlen == 2048) {
            subPrimeLen = 224;
        }
        DSAKeyPairGenerator.checkStrength(modlen, subPrimeLen);
        if (genParams) {
            this.params = null;
        } else {
            this.params = ParameterCache.getCachedDSAParameterSpec(modlen, subPrimeLen);
            if (this.params == null) {
                throw new InvalidParameterException("No precomputed parameters for requested modulus size available");
            }
        }
        this.plen = modlen;
        this.qlen = subPrimeLen;
        this.random = random;
        this.forceNewParameters = genParams;
    }

    @Override
    public void initialize(DSAParams params, SecureRandom random) {
        if (params == null) {
            throw new InvalidParameterException("Params must not be null");
        }
        DSAParameterSpec spec = new DSAParameterSpec(params.getP(), params.getQ(), params.getG());
        this.initialize0(spec, random);
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter");
        }
        this.initialize0((DSAParameterSpec)params, random);
    }

    private void initialize0(DSAParameterSpec params, SecureRandom random) {
        int sizeP = params.getP().bitLength();
        int sizeQ = params.getQ().bitLength();
        DSAKeyPairGenerator.checkStrength(sizeP, sizeQ);
        this.plen = sizeP;
        this.qlen = sizeQ;
        this.params = params;
        this.random = random;
        this.forceNewParameters = false;
    }

    @Override
    public KeyPair generateKeyPair() {
        DSAParameterSpec spec;
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        try {
            if (this.forceNewParameters) {
                spec = ParameterCache.getNewDSAParameterSpec(this.plen, this.qlen, this.random);
            } else {
                if (this.params == null) {
                    this.params = ParameterCache.getDSAParameterSpec(this.plen, this.qlen, this.random);
                }
                spec = this.params;
            }
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
        return this.generateKeyPair(spec.getP(), spec.getQ(), spec.getG(), this.random);
    }

    public KeyPair generateKeyPair(BigInteger p, BigInteger q, BigInteger g, SecureRandom random) {
        BigInteger x = this.generateX(random, q);
        BigInteger y = this.generateY(x, p, g);
        try {
            DSAPublicKey pub = DSAKeyFactory.SERIAL_INTEROP ? new DSAPublicKey(y, p, q, g) : new DSAPublicKeyImpl(y, p, q, g);
            DSAPrivateKey priv = new DSAPrivateKey(x, p, q, g);
            KeyPair pair = new KeyPair(pub, priv);
            return pair;
        }
        catch (InvalidKeyException e) {
            throw new ProviderException(e);
        }
    }

    private BigInteger generateX(SecureRandom random, BigInteger q) {
        BigInteger x = null;
        byte[] temp = new byte[this.qlen];
        do {
            random.nextBytes(temp);
        } while ((x = new BigInteger(1, temp).mod(q)).signum() <= 0 || x.compareTo(q) >= 0);
        return x;
    }

    BigInteger generateY(BigInteger x, BigInteger p, BigInteger g) {
        BigInteger y = g.modPow(x, p);
        return y;
    }
}

