/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.ManualMethodSelect;
import org.netbeans.modules.profiler.ui.panels.Bundle;
import org.netbeans.modules.profiler.ui.panels.FileSelectRootMethodsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class RootMethodsPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "RootMethodsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("RootMethodsPanel.HelpCtx");
    private static RootMethodsPanel defaultInstance;
    private static MethodNameFormatterFactory formatterFactory;
    private ArrayList selectedRoots = new ArrayList();
    private DefaultListModel rootsListModel;
    private HTMLTextArea hintArea;
    private JButton addFromJarButton;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private JList rootsList;
    private Lookup.Provider project;
    private boolean globalAttach = false;

    private RootMethodsPanel() {
        this.initComponents();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static ClientUtils.SourceCodeSelection[] getSelectedRootMethods(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray, Lookup.Provider provider) {
        RootMethodsPanel rootMethodsPanel = RootMethodsPanel.getDefault();
        rootMethodsPanel.project = provider;
        rootMethodsPanel.globalAttach = rootMethodsPanel.project == null;
        rootMethodsPanel.addFromJarButton.setEnabled(rootMethodsPanel.globalAttach);
        rootMethodsPanel.refreshList(sourceCodeSelectionArray);
        return RootMethodsPanel.performDisplay(rootMethodsPanel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addFromJarButton) {
            this.addFromJarButton.setEnabled(false);
            FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(RootMethodsPanel.class);
            final File file = fileChooserBuilder.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = null;
                    String string2 = file.getName();
                    int n = string2.lastIndexOf(".");
                    if (n > -1) {
                        string = string2.substring(n + 1);
                    }
                    return string != null && string.equalsIgnoreCase("jar");
                }

                @Override
                public String getDescription() {
                    return Bundle.RootMethodsPanel_FoldersJarsFileFilter();
                }
            }).showOpenDialog();
            if (file == null) {
                return;
            }
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = FileSelectRootMethodsPanel.getDefault().getRootMethods(FileUtil.toFileObject((File)file), RootMethodsPanel.this.selectedRoots.toArray(new ClientUtils.SourceCodeSelection[0]));
                        if (sourceCodeSelectionArray != null) {
                            RootMethodsPanel.this.addNewRootMethods(sourceCodeSelectionArray, true);
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RootMethodsPanel.this.addFromJarButton.setEnabled(true);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
        } else if (actionEvent.getSource() == this.addButton) {
            ClientUtils.SourceCodeSelection sourceCodeSelection = ManualMethodSelect.selectMethod();
            if (sourceCodeSelection != null) {
                String string = null;
                try {
                    string = formatterFactory.getFormatter().formatMethodName(sourceCodeSelection).toFormatted();
                    if (!this.selectedRoots.contains(sourceCodeSelection)) {
                        this.selectedRoots.add(sourceCodeSelection);
                        this.rootsListModel.addElement(string);
                        this.rootsList.setSelectedValue(string, true);
                    }
                }
                catch (Exception exception) {
                    ProfilerDialogs.displayError((String)Bundle.RootMethodsPanel_IncorrectManualRootMsg());
                }
            }
        } else if (actionEvent.getSource() == this.editButton) {
            ClientUtils.SourceCodeSelection sourceCodeSelection = (ClientUtils.SourceCodeSelection)this.selectedRoots.get(this.rootsList.getSelectedIndex());
            ClientUtils.SourceCodeSelection sourceCodeSelection2 = ManualMethodSelect.selectMethod(sourceCodeSelection);
            if (sourceCodeSelection2 != null) {
                String string = null;
                try {
                    string = formatterFactory.getFormatter().formatMethodName(sourceCodeSelection2).toFormatted();
                    if (!this.selectedRoots.contains(sourceCodeSelection2)) {
                        int n = this.selectedRoots.indexOf(sourceCodeSelection);
                        this.selectedRoots.remove(n);
                        this.selectedRoots.add(n, sourceCodeSelection2);
                        this.rootsListModel.remove(n);
                        this.rootsListModel.add(n, string);
                        this.rootsList.setSelectedIndex(n);
                    }
                }
                catch (Exception exception) {
                    ProfilerDialogs.displayError((String)Bundle.RootMethodsPanel_IncorrectManualRootMsg());
                }
            }
        } else if (actionEvent.getSource() == this.removeButton) {
            int[] nArray = this.rootsList.getSelectedIndices();
            Object[] objectArray = this.rootsList.getSelectedValues();
            for (Object object : objectArray) {
                this.rootsListModel.removeElement(object);
            }
            ArrayList arrayList = new ArrayList();
            for (int n : nArray) {
                arrayList.add(this.selectedRoots.get(n));
            }
            this.selectedRoots.removeAll(arrayList);
            int n = -1;
            if (nArray.length > 0) {
                n = nArray[0];
            }
            if (n >= this.rootsListModel.size()) {
                n = this.rootsListModel.size() - 1;
            }
            this.rootsList.setSelectedIndex(n);
            this.updateButtons();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    private static RootMethodsPanel getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new RootMethodsPanel();
        }
        return defaultInstance;
    }

    private static ClientUtils.SourceCodeSelection[] performDisplay(RootMethodsPanel rootMethodsPanel) {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)rootMethodsPanel, Bundle.RootMethodsPanel_SpecifyRootMethodsDialogCaption());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        if (rootMethodsPanel.addFromJarButton.isEnabled()) {
            rootMethodsPanel.addFromJarButton.grabFocus();
        }
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = new ClientUtils.SourceCodeSelection[rootMethodsPanel.selectedRoots.size()];
            rootMethodsPanel.selectedRoots.toArray(sourceCodeSelectionArray);
            return sourceCodeSelectionArray;
        }
        return null;
    }

    private void addNewRootMethods(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray, boolean bl) {
        if (bl) {
            this.selectedRoots.clear();
            this.rootsListModel.clear();
        }
        MethodNameFormatter methodNameFormatter = formatterFactory.getFormatter();
        for (int i = 0; i < sourceCodeSelectionArray.length; ++i) {
            ClientUtils.SourceCodeSelection sourceCodeSelection = sourceCodeSelectionArray[i];
            if (this.selectedRoots.contains(sourceCodeSelection)) continue;
            this.selectedRoots.add(sourceCodeSelection);
            this.rootsListModel.addElement(methodNameFormatter.formatMethodName(sourceCodeSelection).toFormatted());
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        JLabel jLabel = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.rootsList = new JList();
        JPanel jPanel = new JPanel();
        this.addFromJarButton = new JButton();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)Bundle.RootMethodsPanel_RootMethodsLabelText());
        jLabel.setLabelFor(this.rootsList);
        jLabel.setIconTextGap(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 5, 12);
        this.add((Component)jLabel, gridBagConstraints);
        this.rootsList.getAccessibleContext().setAccessibleName(Bundle.RootMethodsPanel_RootsListAccessName());
        jScrollPane.setViewportView(this.rootsList);
        jScrollPane.setPreferredSize(new Dimension(330, jScrollPane.getPreferredSize().height));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 24, 0, 12);
        this.add((Component)jScrollPane, gridBagConstraints);
        jPanel.setLayout(new GridLayout(4, 1, 0, 5));
        jPanel.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)this.addFromJarButton, (String)Bundle.RootMethodsPanel_AddFromJarButtonText());
        this.addFromJarButton.getAccessibleContext().setAccessibleDescription(Bundle.RootMethodsPanel_AddFromJarButtonAccessDescr());
        jPanel.add(this.addFromJarButton);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)Bundle.RootMethodsPanel_AddManualButtonText());
        this.addButton.getAccessibleContext().setAccessibleDescription(Bundle.RootMethodsPanel_AddManuallyButtonAccessDescr());
        jPanel.add(this.addButton);
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)Bundle.RootMethodsPanel_EditButtonText());
        this.editButton.getAccessibleContext().setAccessibleDescription(Bundle.RootMethodsPanel_EditButtonAccessDescr());
        jPanel.add(this.editButton);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)Bundle.RootMethodsPanel_RemoveButtonText());
        this.removeButton.getAccessibleContext().setAccessibleDescription(Bundle.RootMethodsPanel_RemoveButtonAccessDescr());
        jPanel.add(this.removeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)jPanel, gridBagConstraints);
        Color color = UIManager.getColor("Panel.background");
        Color color2 = UIUtils.getSafeColor((int)(color.getRed() - 10), (int)(color.getGreen() - 10), (int)(color.getBlue() - 10));
        this.hintArea.setText(Bundle.RootMethodsPanel_MessageAreaText());
        this.hintArea.setEnabled(false);
        this.hintArea.setDisabledTextColor(Color.darkGray);
        this.hintArea.setBackground(color2);
        this.hintArea.setBorder((Border)BorderFactory.createMatteBorder(10, 10, 10, 10, color2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.add((Component)this.hintArea, gridBagConstraints);
        this.addFromJarButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.rootsList.addListSelectionListener(this);
    }

    private void refreshList(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        this.selectedRoots.clear();
        for (int i = 0; i < sourceCodeSelectionArray.length; ++i) {
            ClientUtils.SourceCodeSelection sourceCodeSelection = sourceCodeSelectionArray[i];
            if (sourceCodeSelection == null) continue;
            this.selectedRoots.add(sourceCodeSelection);
        }
        this.rootsListModel = new DefaultListModel();
        this.updateList();
        this.rootsList.setModel(this.rootsListModel);
        this.updateButtons();
    }

    private void updateButtons() {
        this.editButton.setEnabled(this.rootsList.getSelectedIndices().length == 1);
        this.removeButton.setEnabled(this.rootsList.getSelectedIndices().length > 0);
    }

    private void updateList() {
        this.rootsListModel.removeAllElements();
        MethodNameFormatter methodNameFormatter = formatterFactory.getFormatter();
        for (ClientUtils.SourceCodeSelection sourceCodeSelection : this.selectedRoots) {
            this.rootsListModel.addElement(methodNameFormatter.formatMethodName(sourceCodeSelection).toFormatted());
        }
    }

    static {
        formatterFactory = MethodNameFormatterFactory.getDefault((MethodNameFormatter)new DefaultMethodNameFormatter(5));
    }
}

