/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.Icon;

public class ArrowIcon
implements Icon {
    private int size;
    private Orientation orientation;

    public ArrowIcon(int size, Orientation orientation) {
        this.size = size;
        this.orientation = orientation;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(new Color(Integer.MIN_VALUE, true));
        Polygon triangle = new Polygon();
        switch (this.orientation) {
            case DOWN: {
                triangle.addPoint(x, y);
                triangle.addPoint(x + this.size, y);
                triangle.addPoint(x + this.size / 2, y + this.size);
                break;
            }
            case RIGHT: {
                triangle.addPoint(x, y);
                triangle.addPoint(x, y + this.size);
                triangle.addPoint(x + this.size, y + this.size / 2);
                break;
            }
        }
        g.fillPolygon(triangle);
    }

    public static enum Orientation {
        DOWN,
        RIGHT;

    }
}

