require 'spec_helper'

describe Admin::GroupsController do
  let(:group) { create(:group) }
  let(:project) { create(:empty_project, namespace: group) }
  let(:admin) { create(:admin) }

  before do
    sign_in(admin)
  end

  describe 'DELETE #destroy' do
    it 'schedules a group destroy' do
      Sidekiq::Testing.fake! do
        expect { delete :destroy, id: project.group.path }.to change(GroupDestroyWorker.jobs, :size).by(1)
      end
    end

    it 'redirects to the admin group path' do
      delete :destroy, id: project.group.path

      expect(response).to redirect_to(admin_groups_path)
    end
  end
end
