/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import com.google.common.hash.HashCode;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.jar.DefaultJarSnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotter;
import org.gradle.internal.Factory;

public class CachingJarSnapshotter
implements JarSnapshotter {
    private final DefaultJarSnapshotter snapshotter;
    private final FileHasher hasher;
    private final JarSnapshotCache cache;

    public CachingJarSnapshotter(FileHasher hasher, ClassDependenciesAnalyzer analyzer, JarSnapshotCache cache) {
        this.snapshotter = new DefaultJarSnapshotter(hasher, analyzer);
        this.hasher = hasher;
        this.cache = cache;
    }

    @Override
    public JarSnapshot createSnapshot(final JarArchive jarArchive) {
        final HashCode hash = this.getHash(jarArchive);
        return (JarSnapshot)this.cache.get(hash, (Factory)new Factory<JarSnapshot>(){

            public JarSnapshot create() {
                return CachingJarSnapshotter.this.snapshotter.createSnapshot(hash, jarArchive);
            }
        });
    }

    private HashCode getHash(JarArchive jarArchive) {
        return this.hasher.hash(jarArchive.file);
    }
}

