/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import com.google.common.base.Objects;
import com.google.common.hash.HashCode;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotData;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;

public class JarClasspathSnapshotDataSerializer
extends AbstractSerializer<JarClasspathSnapshotData> {
    private final MapSerializer<File, HashCode> mapSerializer = new MapSerializer(BaseSerializerFactory.FILE_SERIALIZER, (Serializer)new HashCodeSerializer());
    private final SetSerializer<String> setSerializer = new SetSerializer(BaseSerializerFactory.STRING_SERIALIZER, false);

    public JarClasspathSnapshotData read(Decoder decoder) throws Exception {
        Set duplicates = (Set)this.setSerializer.read(decoder);
        Map hashes = this.mapSerializer.read(decoder);
        return new JarClasspathSnapshotData(hashes, duplicates);
    }

    public void write(Encoder encoder, JarClasspathSnapshotData value) throws Exception {
        this.setSerializer.write(encoder, value.getDuplicateClasses());
        this.mapSerializer.write(encoder, value.getJarHashes());
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        JarClasspathSnapshotDataSerializer rhs = (JarClasspathSnapshotDataSerializer)((Object)obj);
        return Objects.equal(this.mapSerializer, rhs.mapSerializer) && Objects.equal(this.setSerializer, rhs.setSerializer);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mapSerializer, this.setSerializer});
    }
}

