/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.serializer;

import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressStartEventSerializer
implements Serializer<ProgressStartEvent> {
    public void write(Encoder encoder, ProgressStartEvent event) throws Exception {
        encoder.writeSmallLong(event.getOperationId().getId());
        if (event.getParentId() == null) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            encoder.writeSmallLong(event.getParentId().getId());
        }
        encoder.writeLong(event.getTimestamp());
        encoder.writeString((CharSequence)event.getCategory());
        encoder.writeString((CharSequence)event.getDescription());
        encoder.writeNullableString((CharSequence)event.getShortDescription());
        encoder.writeNullableString((CharSequence)event.getLoggingHeader());
        encoder.writeString((CharSequence)event.getStatus());
    }

    public ProgressStartEvent read(Decoder decoder) throws Exception {
        OperationIdentifier id = new OperationIdentifier(decoder.readSmallLong());
        OperationIdentifier parentId = decoder.readBoolean() ? new OperationIdentifier(decoder.readSmallLong()) : null;
        long timestamp = decoder.readLong();
        String category = decoder.readString();
        String description = decoder.readString();
        String shortDescription = decoder.readNullableString();
        String loggingHeader = decoder.readNullableString();
        String status = decoder.readString();
        return new ProgressStartEvent(id, parentId, timestamp, category, description, shortDescription, loggingHeader, status);
    }
}

