#! /bin/sh
#
# Copyright by The HDF Group.
# All rights reserved.
#
# This file is part of HDF5.  The full HDF5 copyright notice, including
# terms governing use, modification, and redistribution, is contained in
# the files COPYING and Copyright.html.  COPYING can be found at the root
# of the source code distribution tree; Copyright.html can be found at the
# root level of an installed copy of the electronic HDF5 document set and
# is linked from the top-level documents page.  It can also be found at
# http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have
# access to either file, you may request a copy from help@hdfgroup.org.

#
#  This file:  run-hlfortran-ex.sh
# Written by:  Larry Knox
#       Date:  May 11, 2010
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#                                                                               #
# This script will compile and run the fortran examples from source files       #
# installed in .../share/hdf5_examples/fortran using h5fc or h5pfc.  The        #
# order for running programs with RunTest in the MAIN section below is taken    #
# from the Makefile.  The order is important since some of the test programs    #
# use data files created by earlier test programs.  Any future additions should #
# be placed accordingly.                                                        #
#                                                                               #
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

# Initializations
EXIT_SUCCESS=0
EXIT_FAILURE=1

# Where the tool is installed.
# default is relative path to installed location of the tools
prefix="${prefix:-../../..}"
PARALLEL=yes             # Am I in parallel mode?
AR="ar"
RANLIB="ranlib"
if [ "$PARALLEL" = no ]; then
    H5TOOL="h5fc"               # The tool name
else
    H5TOOL="h5pfc"               # The tool name
fi
H5TOOL_BIN="${prefix}/bin/${H5TOOL}"   # The path of the tool binary


#### Run test ####
RunTest()
{
    TEST_EXEC=$1
    Test=$1".f90"

    echo
    echo "#################  $1  #################"
    ${H5TOOL_BIN} -o $TEST_EXEC $Test
    if [ $? -ne 0 ]
    then
        echo "messed up compiling $Test"
        exit 1
    fi
    ./$TEST_EXEC
}

F2003_ENABLED=@HAVE_FORTRAN_2003@

##################  MAIN  ##################

# Run tests
if [ $? -eq 0 ]
then
    if (RunTest h5_crtdat &&\
        rm h5_crtdat &&\
        RunTest h5_rdwt &&\
        rm h5_rdwt &&\
        RunTest h5_crtatt &&\
        rm h5_crtatt &&\
        RunTest h5_crtgrp &&\
        rm h5_crtgrp &&\
        RunTest h5_crtgrpar &&\
        rm h5_crtgrpar &&\
        RunTest h5_crtgrpd &&\
        rm h5_crtgrpd &&\
        RunTest h5_extend &&\
        rm h5_extend &&\
        RunTest h5_subset &&\
        rm h5_subset &&\
        RunTest h5_cmprss &&\
        rm h5_cmprss &&\
        RunTest hyperslab &&\
        rm hyperslab &&\
        RunTest selectele &&\
        rm selectele &&\
        RunTest refobjexample &&\
        rm refobjexample &&\
        RunTest refregexample &&\
        rm refregexample &&\
        RunTest mountexample &&\
        rm mountexample &&\
        RunTest compound &&\
        rm compound); then
        EXIT_VALUE=${EXIT_SUCCESS}
    else
        EXIT_VALUE=${EXIT_FAILURE}
    fi
fi

if [ $EXIT_VALUE -eq ${EXIT_SUCCESS} -a "$F2003_ENABLED" = "yes" ]
then
# Add attention tests for Fortran 2003 features
    if (RunTest rwdset_fortran2003 &&\
        rm rwdset_fortran2003 &&\
        RunTest nested_derived_type &&\
        rm nested_derived_type &&\
        RunTest compound_fortran2003 &&\
        rm compound_fortran2003 &&\
        RunTest compound_complex_fortran2003 &&\
        rm compound_complex_fortran2003); then
        EXIT_VALUE=${EXIT_SUCCESS}
    else
        EXIT_VALUE=${EXIT_FAILURE}
    fi
fi
  

# Cleanup
rm *.o
rm *.h5
echo

exit $EXIT_VALUE 

