/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.OpenLocationAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MainPanel;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.ProgramArguments;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.gui.preferences.display.LafPreference;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitorExecutor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.RedirectInputMap;
import org.openstreetmap.josm.io.FileWatcher;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.OverpassTurboQueryWizard;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public abstract class Main {
    private static final String JOSM_WEBSITE = "https://josm.openstreetmap.de";
    private static final String OSM_WEBSITE = "https://www.openstreetmap.org";
    public static Component parent;
    public static volatile Main main;
    public static final ExecutorService worker;
    public static final Preferences pref;
    public static MapFrame map;
    private static final MainLayerManager layerManager;
    public static volatile ToolbarPreferences toolbar;
    public final UndoRedoHandler undoRedo = new UndoRedoHandler();
    public static PleaseWaitProgressMonitor currentProgressMonitor;
    public MainMenu menu;
    public MainPanel panel;
    protected static MainPanel mainPanel;
    protected static JComponent contentPanePrivate;
    public static final FileWatcher fileWatcher;
    private static final Map<String, Throwable> NETWORK_ERRORS;
    private static final Set<OnlineResource> OFFLINE_RESOURCES;
    @Deprecated
    public static int logLevel;
    public static volatile PlatformHook platform;
    private static volatile InitStatusListener initListener;
    protected final OsmDataLayer.CommandQueueListener redoUndoListener = (n, n2) -> {
        this.menu.undo.setEnabled(n > 0);
        this.menu.redo.setEnabled(n2 > 0);
    };
    private static volatile Projection proj;
    private static final List<WeakReference<ProjectionChangeListener>> listeners;

    public static boolean isDisplayingMapView() {
        return map != null && Main.map.mapView != null;
    }

    public static final Collection<String> getLastErrorAndWarnings() {
        return Logging.getLastErrorAndWarnings();
    }

    public static void clearLastErrorAndWarnings() {
        Logging.clearLastErrorAndWarnings();
    }

    public static void error(String string) {
        Logging.error(string);
    }

    public static void warn(String string) {
        Logging.warn(string);
    }

    public static void info(String string) {
        Logging.info(string);
    }

    public static void debug(String string) {
        Logging.debug(string);
    }

    public static void trace(String string) {
        Logging.trace(string);
    }

    public static boolean isDebugEnabled() {
        return Logging.isLoggingEnabled(Logging.LEVEL_DEBUG);
    }

    public static boolean isTraceEnabled() {
        return Logging.isLoggingEnabled(Logging.LEVEL_TRACE);
    }

    public static void error(String string, Object ... objectArray) {
        Logging.error(string, objectArray);
    }

    public static void warn(String string, Object ... objectArray) {
        Logging.warn(string, objectArray);
    }

    public static void info(String string, Object ... objectArray) {
        Logging.info(string, objectArray);
    }

    public static void debug(String string, Object ... objectArray) {
        Logging.debug(string, objectArray);
    }

    public static void trace(String string, Object ... objectArray) {
        Logging.trace(string, objectArray);
    }

    public static void error(Throwable throwable) {
        Logging.logWithStackTrace(Logging.LEVEL_ERROR, throwable);
    }

    public static void warn(Throwable throwable) {
        Logging.logWithStackTrace(Logging.LEVEL_WARN, throwable);
    }

    public static void debug(Throwable throwable) {
        Logging.log(Logging.LEVEL_DEBUG, throwable);
    }

    public static void trace(Throwable throwable) {
        Logging.log(Logging.LEVEL_TRACE, throwable);
    }

    public static void error(Throwable throwable, boolean bl) {
        if (bl) {
            Logging.log(Logging.LEVEL_ERROR, throwable);
        } else {
            Logging.logWithStackTrace(Logging.LEVEL_ERROR, throwable);
        }
    }

    public static void error(Throwable throwable, String string) {
        Logging.log(Logging.LEVEL_ERROR, string, throwable);
    }

    public static void warn(Throwable throwable, boolean bl) {
        if (bl) {
            Logging.log(Logging.LEVEL_WARN, throwable);
        } else {
            Logging.logWithStackTrace(Logging.LEVEL_WARN, throwable);
        }
    }

    public static void warn(Throwable throwable, String string) {
        Logging.log(Logging.LEVEL_WARN, string, throwable);
    }

    public static String getErrorMessage(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return Logging.getErrorMessage(throwable);
    }

    public static void setInitStatusListener(InitStatusListener initStatusListener) {
        CheckParameterUtil.ensureParameterNotNull(initStatusListener);
        initListener = initStatusListener;
    }

    protected Main() {
        Main.setInstance(this);
    }

    private static void setInstance(Main main) {
        Main.main = main;
    }

    public void initialize() {
        fileWatcher.start();
        new InitializationTask(I18n.tr("Executing platform startup hook", new Object[0]), platform::startupHook).call();
        new InitializationTask(I18n.tr("Building main menu", new Object[0]), this::initializeMainWindow).call();
        this.undoRedo.addCommandQueueListener(this.redoUndoListener);
        GuiHelper.runInEDTAndWait(() -> contentPanePrivate.add((Component)Main.toolbar.control, "North"));
        Main.registerActionShortcut(this.menu.help, Shortcut.registerShortcut("system:help", I18n.tr("Help", new Object[0]), 112, 5003));
        try {
            new InitializationTask(I18n.tr("Initializing internal boundaries data", new Object[0]), Territories::initialize).call();
        }
        catch (JosmRuntimeException josmRuntimeException) {
            BugReport.intercept(josmRuntimeException).warn();
        }
        ArrayList<InitializationTask> arrayList = new ArrayList<InitializationTask>();
        arrayList.add(new InitializationTask(I18n.tr("Initializing OSM API", new Object[0]), () -> {
            try {
                OsmApi.getOsmApi().initialize(null, true);
            }
            catch (OsmApiInitializationException | OsmTransferCanceledException osmTransferException) {
                Main.warn(Main.getErrorMessage(Utils.getRootCause(osmTransferException)));
            }
        }));
        arrayList.add(new InitializationTask(I18n.tr("Initializing internal traffic data", new Object[0]), RightAndLefthandTraffic::initialize));
        arrayList.add(new InitializationTask(I18n.tr("Initializing validator", new Object[0]), OsmValidator::initialize));
        arrayList.add(new InitializationTask(I18n.tr("Initializing presets", new Object[0]), TaggingPresets::initialize));
        arrayList.add(new InitializationTask(I18n.tr("Initializing map styles", new Object[0]), MapPaintPreference::initialize));
        arrayList.add(new InitializationTask(I18n.tr("Loading imagery preferences", new Object[0]), ImageryPreference::initialize));
        try {
            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), Utils.newThreadFactory("main-init-%d", 5));
            for (Future future : executorService.invokeAll(arrayList)) {
                future.get();
            }
            executorService.submit(TMSLayer::getCache);
            executorService.submit(OsmValidator::initializeTests);
            executorService.submit(OverpassTurboQueryWizard::getInstance);
            executorService.shutdown();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new JosmRuntimeException(exception);
        }
        FeatureAdapter.registerBrowserAdapter(OpenBrowser::displayUrl);
        FeatureAdapter.registerTranslationAdapter(I18n.getTranslationAdapter());
        FeatureAdapter.registerLoggingAdapter(string -> Logging.getLogger());
        new InitializationTask(I18n.tr("Updating user interface", new Object[0]), () -> GuiHelper.runInEDTAndWait(() -> {
            toolbar.refreshToolbarControl();
            Main.toolbar.control.updateUI();
            contentPanePrivate.updateUI();
        })).call();
    }

    protected abstract void initializeMainWindow();

    public static MainLayerManager getLayerManager() {
        return layerManager;
    }

    public Collection<OsmPrimitive> getInProgressSelection() {
        if (map != null && Main.map.mapMode instanceof DrawAction) {
            return ((DrawAction)Main.map.mapMode).getInProgressSelection();
        }
        DataSet dataSet = Main.getLayerManager().getEditDataSet();
        if (dataSet == null) {
            return null;
        }
        return dataSet.getSelected();
    }

    public static void redirectToMainContentPane(JComponent jComponent) {
        RedirectInputMap.redirect(jComponent, contentPanePrivate);
    }

    public static void registerActionShortcut(JosmAction josmAction) {
        Main.registerActionShortcut(josmAction, josmAction.getShortcut());
    }

    public static void registerActionShortcut(Action action, Shortcut shortcut) {
        KeyStroke keyStroke = shortcut.getKeyStroke();
        if (keyStroke == null) {
            return;
        }
        InputMap inputMap = contentPanePrivate.getInputMap(2);
        Object object = inputMap.get(keyStroke);
        if (object != null && !object.equals(action)) {
            Main.info(String.format("Keystroke %s is already assigned to %s, will be overridden by %s", keyStroke, object, action));
        }
        inputMap.put(keyStroke, action);
        contentPanePrivate.getActionMap().put(action, action);
    }

    public static void unregisterShortcut(Shortcut shortcut) {
        contentPanePrivate.getInputMap(2).remove(shortcut.getKeyStroke());
    }

    public static void unregisterActionShortcut(JosmAction josmAction) {
        Main.unregisterActionShortcut(josmAction, josmAction.getShortcut());
    }

    public static void unregisterActionShortcut(Action action, Shortcut shortcut) {
        Main.unregisterShortcut(shortcut);
        contentPanePrivate.getActionMap().remove(action);
    }

    public static Action getRegisteredActionShortcut(Shortcut shortcut) {
        KeyStroke keyStroke = shortcut.getKeyStroke();
        if (keyStroke == null) {
            return null;
        }
        Object object = contentPanePrivate.getInputMap(2).get(keyStroke);
        if (object instanceof Action) {
            return (Action)object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void preConstructorInit() {
        ProjectionPreference.setProjection();
        String string = platform.getDefaultStyle();
        String string2 = LafPreference.LAF.get();
        try {
            UIManager.setLookAndFeel(string2);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            void var3_9;
            Main.trace(throwable);
            Object object = null;
            for (ClassLoader classLoader : PluginHandler.getResourceClassLoaders()) {
                try {
                    Class<?> clazz = classLoader.loadClass(string2);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Main.trace(classNotFoundException);
                }
            }
            if (var3_9 != null && LookAndFeel.class.isAssignableFrom((Class<?>)var3_9)) {
                try {
                    UIManager.setLookAndFeel((LookAndFeel)var3_9.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    Main.warn((Throwable)reflectiveOperationException, "Cannot set Look and Feel: " + string2 + ": " + reflectiveOperationException.getMessage());
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    Main.info("Look and Feel not supported: " + string2);
                    LafPreference.LAF.put(string);
                    Main.trace(unsupportedLookAndFeelException);
                }
            } else {
                Main.info("Look and Feel not found: " + string2);
                LafPreference.LAF.put(string);
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            Main.info("Look and Feel not supported: " + string2);
            LafPreference.LAF.put(string);
            Main.trace(unsupportedLookAndFeelException);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            Main.error(reflectiveOperationException);
        }
        toolbar = new ToolbarPreferences();
        UIManager.put("OptionPane.okIcon", ImageProvider.get("ok"));
        UIManager.put("OptionPane.yesIcon", UIManager.get("OptionPane.okIcon"));
        UIManager.put("OptionPane.cancelIcon", ImageProvider.get("cancel"));
        UIManager.put("OptionPane.noIcon", UIManager.get("OptionPane.cancelIcon"));
        for (String string3 : Arrays.asList("EditorPane", "FormattedTextField", "PasswordField", "TextArea", "TextField", "TextPane")) {
            UIManager.put(string3 + ".caretForeground", UIManager.getColor(string3 + ".foreground"));
        }
        I18n.translateJavaInternalMessages();
        try {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.valueOf(pref.get("coordinates")));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Main.trace(illegalArgumentException);
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.DECIMAL_DEGREES);
        }
    }

    protected static List<Future<?>> postConstructorProcessCmdLine(ProgramArguments programArguments) {
        ArrayList arrayList = new ArrayList();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (String string : programArguments.get(ProgramArguments.Option.DOWNLOAD)) {
            arrayList.addAll(DownloadParamType.paramType(string).download(string, arrayList2));
        }
        if (!arrayList2.isEmpty()) {
            arrayList.add(OpenFileAction.openFiles(arrayList2, true));
        }
        for (String string : programArguments.get(ProgramArguments.Option.DOWNLOADGPS)) {
            arrayList.addAll(DownloadParamType.paramType(string).downloadGps(string));
        }
        Collection<String> collection = programArguments.get(ProgramArguments.Option.SELECTION);
        if (!collection.isEmpty()) {
            arrayList.add(worker.submit(() -> {
                for (String string : collection) {
                    SearchAction.search(string, SearchAction.SearchMode.add);
                }
            }));
        }
        return arrayList;
    }

    public static boolean exitJosm(boolean bl, int n, SaveLayersDialog.Reason reason) {
        boolean bl2 = Boolean.TRUE.equals(GuiHelper.runInEDTAndWaitAndReturn(() -> SaveLayersDialog.saveUnsavedModifications(Main.getLayerManager().getLayers(), reason != null ? reason : SaveLayersDialog.Reason.EXIT)));
        if (bl2) {
            if (main != null) {
                main.shutdown();
            }
            if (bl) {
                System.exit(n);
            }
            return true;
        }
        return false;
    }

    protected void shutdown() {
        if (!GraphicsEnvironment.isHeadless()) {
            worker.shutdown();
            ImageProvider.shutdown(false);
            JCSCacheManager.shutdown();
        }
        if (map != null) {
            map.rememberToggleDialogWidth();
        }
        Main.getLayerManager().resetState();
        try {
            pref.saveDefaults();
        }
        catch (IOException iOException) {
            Main.warn((Throwable)iOException, I18n.tr("Failed to save default preferences.", new Object[0]));
        }
        if (!GraphicsEnvironment.isHeadless()) {
            worker.shutdownNow();
            ImageProvider.shutdown(true);
        }
    }

    private static List<Future<?>> downloadFromParamBounds(boolean bl, Bounds bounds) {
        AbstractDownloadTask abstractDownloadTask = bl ? new DownloadGpsTask() : new DownloadOsmTask();
        Future<?> future = abstractDownloadTask.download(true, bounds, null);
        return Collections.singletonList(worker.submit(new PostDownloadHandler(abstractDownloadTask, future)));
    }

    public static void determinePlatformHook() {
        String string = System.getProperty("os.name");
        if (string == null) {
            Main.warn("Your operating system has no name, so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase(Locale.ENGLISH).startsWith("windows")) {
            platform = new PlatformHookWindows();
        } else if ("Linux".equals(string) || "Solaris".equals(string) || "SunOS".equals(string) || "AIX".equals(string) || "FreeBSD".equals(string) || "NetBSD".equals(string) || "OpenBSD".equals(string)) {
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase(Locale.ENGLISH).startsWith("mac os x")) {
            platform = new PlatformHookOsx();
        } else {
            Main.warn("I don't know your operating system '" + string + "', so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        }
    }

    public static Projection getProjection() {
        return proj;
    }

    public static void setProjection(Projection projection) {
        CheckParameterUtil.ensureParameterNotNull(projection);
        Projection projection2 = proj;
        Bounds bounds = Main.isDisplayingMapView() ? Main.map.mapView.getRealBounds() : null;
        proj = projection;
        Main.fireProjectionChanged(projection2, proj, bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fireProjectionChanged(Projection projection, Projection projection2, Bounds bounds) {
        if (!(projection2 == null ^ projection == null) && (projection2 == null || projection == null || Objects.equals(projection2.toCode(), projection.toCode()))) return;
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Iterator<WeakReference<ProjectionChangeListener>> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<ProjectionChangeListener> weakReference = iterator.next();
                ProjectionChangeListener projectionChangeListener = (ProjectionChangeListener)weakReference.get();
                if (projectionChangeListener == null) {
                    iterator.remove();
                    continue;
                }
                projectionChangeListener.projectionChanged(projection, projection2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (projection2 == null || bounds == null) return;
            Main.map.mapView.zoomTo(bounds);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addProjectionChangeListener(ProjectionChangeListener projectionChangeListener) {
        if (projectionChangeListener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            for (WeakReference<ProjectionChangeListener> weakReference : listeners) {
                if (weakReference.get() != projectionChangeListener) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            listeners.add(new WeakReference<ProjectionChangeListener>(projectionChangeListener));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProjectionChangeListener(ProjectionChangeListener projectionChangeListener) {
        if (projectionChangeListener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            listeners.removeIf(weakReference -> weakReference.get() == null || weakReference.get() == projectionChangeListener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean addAndFireMapFrameListener(MapFrameListener mapFrameListener) {
        return mainPanel.addAndFireMapFrameListener(mapFrameListener);
    }

    public static boolean addMapFrameListener(MapFrameListener mapFrameListener) {
        return mainPanel.addMapFrameListener(mapFrameListener);
    }

    public static boolean removeMapFrameListener(MapFrameListener mapFrameListener) {
        return mainPanel.removeMapFrameListener(mapFrameListener);
    }

    public static Throwable addNetworkError(URL uRL, Throwable throwable) {
        if (uRL != null && throwable != null) {
            Throwable throwable2 = Main.addNetworkError(uRL.toExternalForm(), throwable);
            if (throwable2 != null) {
                Main.warn("Already here " + throwable2);
            }
            return throwable2;
        }
        return null;
    }

    public static Throwable addNetworkError(String string, Throwable throwable) {
        if (string != null && throwable != null) {
            return NETWORK_ERRORS.put(string, throwable);
        }
        return null;
    }

    public static Map<String, Throwable> getNetworkErrors() {
        return new HashMap<String, Throwable>(NETWORK_ERRORS);
    }

    public static void clearNetworkErrors() {
        NETWORK_ERRORS.clear();
    }

    public static String getJOSMWebsite() {
        if (pref != null) {
            return pref.get("josm.url", JOSM_WEBSITE);
        }
        return JOSM_WEBSITE;
    }

    public static String getXMLBase() {
        return "http://josm.openstreetmap.de";
    }

    public static String getOSMWebsite() {
        if (pref != null) {
            return pref.get("osm.url", OSM_WEBSITE);
        }
        return OSM_WEBSITE;
    }

    private static String getOSMWebsiteDependingOnSelectedApi() {
        String string = OsmApi.getOsmApi().getServerUrl();
        if ("https://api.openstreetmap.org/api".equals(string)) {
            return Main.getOSMWebsite();
        }
        return string.replaceAll("/api$", "");
    }

    public static String getBaseBrowseUrl() {
        if (pref != null) {
            return pref.get("osm-browse.url", Main.getOSMWebsiteDependingOnSelectedApi());
        }
        return Main.getOSMWebsiteDependingOnSelectedApi();
    }

    public static String getBaseUserUrl() {
        if (pref != null) {
            return pref.get("osm-user.url", Main.getOSMWebsiteDependingOnSelectedApi() + "/user");
        }
        return Main.getOSMWebsiteDependingOnSelectedApi() + "/user";
    }

    public static boolean isPlatformOsx() {
        return platform instanceof PlatformHookOsx;
    }

    public static boolean isPlatformWindows() {
        return platform instanceof PlatformHookWindows;
    }

    public static boolean isOffline(OnlineResource onlineResource) {
        return OFFLINE_RESOURCES.contains((Object)onlineResource) || OFFLINE_RESOURCES.contains((Object)OnlineResource.ALL);
    }

    public static boolean setOffline(OnlineResource onlineResource) {
        return OFFLINE_RESOURCES.add(onlineResource);
    }

    public static boolean setOnline(OnlineResource onlineResource) {
        return OFFLINE_RESOURCES.remove((Object)onlineResource);
    }

    public static Set<OnlineResource> getOfflineResources() {
        return EnumSet.copyOf(OFFLINE_RESOURCES);
    }

    static {
        worker = new ProgressMonitorExecutor("main-worker-%d", 5);
        pref = new Preferences();
        layerManager = new MainLayerManager();
        fileWatcher = new FileWatcher();
        NETWORK_ERRORS = new HashMap<String, Throwable>();
        OFFLINE_RESOURCES = EnumSet.noneOf(OnlineResource.class);
        logLevel = 3;
        listeners = new ArrayList<WeakReference<ProjectionChangeListener>>();
    }

    public static interface WindowSwitchListener {
        public void toOtherApplication();

        public void fromOtherApplication();
    }

    static enum DownloadParamType {
        httpUrl{

            @Override
            List<Future<?>> download(String string, Collection<File> collection) {
                return new OpenLocationAction().openUrl(false, string);
            }

            @Override
            List<Future<?>> downloadGps(String string) {
                Bounds bounds = OsmUrlToBounds.parse(string);
                if (bounds == null) {
                    JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed URL: \"{0}\"", string), I18n.tr("Warning", new Object[0]), 2);
                    return Collections.emptyList();
                }
                return Main.downloadFromParamBounds(true, bounds);
            }
        }
        ,
        fileUrl{

            @Override
            List<Future<?>> download(String string, Collection<File> collection) {
                File file = null;
                try {
                    file = new File(new URI(string));
                }
                catch (URISyntaxException uRISyntaxException) {
                    Main.warn(uRISyntaxException);
                    JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed file URL: \"{0}\"", string), I18n.tr("Warning", new Object[0]), 2);
                }
                if (file != null) {
                    collection.add(file);
                }
                return Collections.emptyList();
            }
        }
        ,
        bounds{

            private List<Future<?>> downloadFromParamBounds(boolean bl, String string) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                if (stringTokenizer.countTokens() == 4) {
                    return Main.downloadFromParamBounds(bl, new Bounds(new LatLon(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken())), new LatLon(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()))));
                }
                return Collections.emptyList();
            }

            @Override
            List<Future<?>> download(String string, Collection<File> collection) {
                return this.downloadFromParamBounds(false, string);
            }

            @Override
            List<Future<?>> downloadGps(String string) {
                return this.downloadFromParamBounds(true, string);
            }
        }
        ,
        fileName{

            @Override
            List<Future<?>> download(String string, Collection<File> collection) {
                collection.add(new File(string));
                return Collections.emptyList();
            }
        };


        abstract List<Future<?>> download(String var1, Collection<File> var2);

        List<Future<?>> downloadGps(String string) {
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(parent, I18n.tr("Parameter \"downloadgps\" does not accept file names or file URLs", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            }
            return Collections.emptyList();
        }

        static DownloadParamType paramType(String string) {
            if (string.startsWith("http:") || string.startsWith("https:")) {
                return httpUrl;
            }
            if (string.startsWith("file:")) {
                return fileUrl;
            }
            String string2 = "\\s*[+-]?[0-9]+(\\.[0-9]+)?\\s*";
            if (string.matches(string2 + "(," + string2 + "){3}")) {
                return bounds;
            }
            return fileName;
        }
    }

    static final class InitializationTask
    implements Callable<Void> {
        private final String name;
        private final Runnable task;

        protected InitializationTask(String string, Runnable runnable) {
            this.name = string;
            this.task = runnable;
        }

        @Override
        public Void call() {
            Object object = null;
            if (initListener != null) {
                object = initListener.updateStatus(this.name);
            }
            this.task.run();
            if (initListener != null) {
                initListener.finish(object);
            }
            return null;
        }
    }

    public static interface InitStatusListener {
        public Object updateStatus(String var1);

        public void finish(Object var1);
    }
}

