/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddCommand
extends Command {
    private final OsmPrimitive osm;

    public AddCommand(OsmPrimitive osmPrimitive) {
        this.osm = Objects.requireNonNull(osmPrimitive, "osm");
    }

    public AddCommand(OsmDataLayer osmDataLayer, OsmPrimitive osmPrimitive) {
        super(osmDataLayer);
        this.osm = Objects.requireNonNull(osmPrimitive, "osm");
    }

    public AddCommand(DataSet dataSet, OsmPrimitive osmPrimitive) {
        super(dataSet);
        this.osm = Objects.requireNonNull(osmPrimitive, "osm");
    }

    protected static final void checkNodeStyles(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Way) {
            ((Way)osmPrimitive).clearCachedNodeStyles();
        }
    }

    @Override
    public boolean executeCommand() {
        this.getAffectedDataSet().addPrimitive(this.osm);
        this.osm.setModified(true);
        AddCommand.checkNodeStyles(this.osm);
        return true;
    }

    @Override
    public void undoCommand() {
        this.getAffectedDataSet().removePrimitive((PrimitiveId)this.osm);
        AddCommand.checkNodeStyles(this.osm);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection3.add(this.osm);
    }

    @Override
    public String getDescriptionText() {
        String string;
        switch (OsmPrimitiveType.from(this.osm)) {
            case NODE: {
                string = I18n.marktr("Add node {0}");
                break;
            }
            case WAY: {
                string = I18n.marktr("Add way {0}");
                break;
            }
            case RELATION: {
                string = I18n.marktr("Add relation {0}");
                break;
            }
            default: {
                string = "";
            }
        }
        return I18n.tr(string, this.osm.getDisplayName(DefaultNameFormatter.getInstance()));
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(this.osm.getDisplayType());
    }

    public Collection<OsmPrimitive> getParticipatingPrimitives() {
        return Collections.singleton(this.osm);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.osm);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AddCommand addCommand = (AddCommand)object;
        return Objects.equals(this.osm, addCommand.osm);
    }
}

