/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Utils;

public class BBox {
    protected double xmin = Double.POSITIVE_INFINITY;
    protected double xmax = Double.NEGATIVE_INFINITY;
    protected double ymin = Double.POSITIVE_INFINITY;
    protected double ymax = Double.NEGATIVE_INFINITY;

    public BBox() {
    }

    public BBox(double d, double d2) {
        this.add(d, d2);
    }

    public BBox(LatLon latLon, LatLon latLon2) {
        this(latLon.lon(), latLon.lat(), latLon2.lon(), latLon2.lat());
    }

    public BBox(BBox bBox) {
        this.xmin = bBox.xmin;
        this.xmax = bBox.xmax;
        this.ymin = bBox.ymin;
        this.ymax = bBox.ymax;
    }

    public BBox(double d, double d2, double d3, double d4) {
        if (!(Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4))) {
            this.add(d, d2);
            this.add(d3, d4);
        }
    }

    public BBox(Way way) {
        way.getNodes().forEach(this::add);
    }

    public BBox(Node node) {
        this((ILatLon)node);
    }

    public BBox(ILatLon iLatLon) {
        this.add(iLatLon);
    }

    public final void add(LatLon latLon) {
        this.add((ILatLon)latLon);
    }

    public final void add(ILatLon iLatLon) {
        if (iLatLon != null) {
            this.add(iLatLon.lon(), iLatLon.lat());
        }
    }

    public final void add(double d, double d2) {
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            this.xmin = Math.min(this.xmin, d);
            this.xmax = Math.max(this.xmax, d);
            this.ymin = Math.min(this.ymin, d2);
            this.ymax = Math.max(this.ymax, d2);
        }
    }

    public final void add(BBox bBox) {
        if (bBox.isValid()) {
            this.xmin = Math.min(this.xmin, bBox.xmin);
            this.xmax = Math.max(this.xmax, bBox.xmax);
            this.ymin = Math.min(this.ymin, bBox.ymin);
            this.ymax = Math.max(this.ymax, bBox.ymax);
        }
    }

    public void addPrimitive(OsmPrimitive osmPrimitive, double d) {
        BBox bBox = osmPrimitive.getBBox();
        this.add(bBox.xmin - d, bBox.ymin - d);
        this.add(bBox.xmax + d, bBox.ymax + d);
    }

    public double height() {
        if (this.isValid()) {
            return this.ymax - this.ymin;
        }
        return 0.0;
    }

    public double width() {
        if (this.isValid()) {
            return this.xmax - this.xmin;
        }
        return 0.0;
    }

    public boolean bounds(BBox bBox) {
        return this.xmin <= bBox.xmin && this.xmax >= bBox.xmax && this.ymin <= bBox.ymin && this.ymax >= bBox.ymax;
    }

    public boolean bounds(LatLon latLon) {
        return this.xmin <= latLon.lon() && this.xmax >= latLon.lon() && this.ymin <= latLon.lat() && this.ymax >= latLon.lat();
    }

    public boolean intersects(BBox bBox) {
        return this.xmin <= bBox.xmax && this.xmax >= bBox.xmin && this.ymin <= bBox.ymax && this.ymax >= bBox.ymin;
    }

    public LatLon getTopLeft() {
        return new LatLon(this.ymax, this.xmin);
    }

    public double getTopLeftLat() {
        return this.ymax;
    }

    public double getTopLeftLon() {
        return this.xmin;
    }

    public LatLon getBottomRight() {
        return new LatLon(this.ymin, this.xmax);
    }

    public double getBottomRightLat() {
        return this.ymin;
    }

    public double getBottomRightLon() {
        return this.xmax;
    }

    public LatLon getCenter() {
        return new LatLon(this.ymin + (this.ymax - this.ymin) / 2.0, this.xmin + (this.xmax - this.xmin) / 2.0);
    }

    byte getIndex(int n) {
        byte by = QuadTiling.index(this.ymin, this.xmin, n);
        byte by2 = QuadTiling.index(this.ymin, this.xmax, n);
        if (by == -1) {
            by = by2;
        } else if (by != by2) {
            return -1;
        }
        byte by3 = QuadTiling.index(this.ymax, this.xmin, n);
        if (by == -1) {
            by = by3;
        } else if (by != by3) {
            return -1;
        }
        byte by4 = QuadTiling.index(this.ymax, this.xmax, n);
        if (by == -1) {
            by = by4;
        } else if (by != by4) {
            return -1;
        }
        return by;
    }

    public Rectangle2D toRectangle() {
        return new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public int hashCode() {
        return Objects.hash(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BBox bBox = (BBox)object;
        return Double.compare(bBox.xmax, this.xmax) == 0 && Double.compare(bBox.ymax, this.ymax) == 0 && Double.compare(bBox.xmin, this.xmin) == 0 && Double.compare(bBox.ymin, this.ymin) == 0;
    }

    public boolean isValid() {
        return this.xmin <= this.xmax && this.ymin <= this.ymax;
    }

    public boolean isInWorld() {
        return this.xmin >= -180.0 && this.xmax <= 180.0 && this.ymin >= -90.0 && this.ymax <= 90.0 && this.isValid();
    }

    public String toString() {
        return "[ x: " + this.xmin + " -> " + this.xmax + ", y: " + this.ymin + " -> " + this.ymax + " ]";
    }

    public String toStringCSV(String string) {
        return Utils.join(string, Arrays.asList(LatLon.cDdFormatter.format(this.xmin), LatLon.cDdFormatter.format(this.ymin), LatLon.cDdFormatter.format(this.xmax), LatLon.cDdFormatter.format(this.ymax)));
    }
}

