/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.IScaleFactorProvider;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class Mercator
extends AbstractProj
implements IScaleFactorProvider {
    private static final double EPSILON = 1.0E-6;
    protected double scaleFactor;

    @Override
    public String getName() {
        return I18n.tr("Mercator", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "merc";
    }

    @Override
    public void initialize(ProjParameters projParameters) throws ProjectionConfigurationException {
        double d;
        super.initialize(projParameters);
        this.scaleFactor = 1.0;
        if (projParameters.lat_ts != null) {
            d = Utils.toRadians(projParameters.lat_ts);
            this.scaleFactor = this.spherical ? (this.scaleFactor *= Math.cos(d)) : (this.scaleFactor *= this.msfn(Math.sin(d), Math.cos(d)));
        }
        if (projParameters.lat0 != null) {
            d = Utils.toRadians(projParameters.lat0);
            double d2 = Math.sin(d);
            this.scaleFactor *= Math.cos(d) / Math.sqrt(1.0 - this.e2 * d2 * d2);
        }
    }

    @Override
    public double[] project(double d, double d2) {
        if (Math.abs(d) > 1.5707953267948966) {
            return new double[]{0.0, 0.0};
        }
        d = this.spherical ? Math.log(Math.tan(0.7853981633974483 + 0.5 * d)) : -Math.log(this.tsfn(d, Math.sin(d)));
        return new double[]{d2, d};
    }

    @Override
    public double[] invproject(double d, double d2) {
        if (this.spherical) {
            d2 = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-d2));
        } else {
            d2 = Math.exp(-d2);
            d2 = this.cphi2(d2);
        }
        return new double[]{d2, d};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -180.0, 89.0, 180.0, false);
    }

    @Override
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public boolean lonIsLinearToEast() {
        return true;
    }
}

