/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class Coastlines
extends Test {
    protected static final int UNORDERED_COASTLINE = 901;
    protected static final int REVERSED_COASTLINE = 902;
    protected static final int UNCONNECTED_COASTLINE = 903;
    protected static final int WRONG_ORDER_COASTLINE = 904;
    private List<Way> coastlineWays;

    public Coastlines() {
        super(I18n.tr("Coastlines", new Object[0]), I18n.tr("This test checks that coastlines are correct.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.coastlineWays = new LinkedList<Way>();
    }

    @Override
    public void endTest() {
        this.checkConnections();
        this.checkDirection();
        this.coastlineWays = null;
        super.endTest();
    }

    private void checkConnections() {
        Area area = null;
        for (Way way : this.coastlineWays) {
            if (area == null) {
                area = way.getDataSet().getDataSourceArea();
            }
            int n = way.getNodesCount();
            for (int i = 0; i < n; ++i) {
                Node node = way.getNode(i);
                List<OsmPrimitive> list = node.getReferrers();
                HashSet<Way> hashSet = new HashSet<Way>();
                for (OsmPrimitive osmPrimitive : list) {
                    if (osmPrimitive == way || !Coastlines.isCoastline(osmPrimitive)) continue;
                    hashSet.add((Way)osmPrimitive);
                }
                if (i == 0) {
                    if (hashSet.isEmpty() && node != way.lastNode() && node.getCoor().isIn(area)) {
                        this.addError(903, way, null, node);
                    }
                    if (hashSet.size() == 1 && node != ((Way)hashSet.iterator().next()).lastNode()) {
                        this.checkIfReversed(way, (Way)hashSet.iterator().next(), node);
                    }
                    if (hashSet.size() != 1 || !way.isClosed() || !((Way)hashSet.iterator().next()).isClosed()) continue;
                    this.addError(901, way, hashSet, node);
                    continue;
                }
                if (i == n - 1) {
                    if (hashSet.isEmpty() && node != way.firstNode() && node.getCoor().isIn(area)) {
                        this.addError(903, way, null, node);
                    }
                    if (hashSet.size() != 1 || node == ((Way)hashSet.iterator().next()).firstNode()) continue;
                    this.checkIfReversed(way, (Way)hashSet.iterator().next(), node);
                    continue;
                }
                if (hashSet.isEmpty()) continue;
                this.addError(901, way, hashSet, node);
            }
        }
    }

    private void checkDirection() {
        HashSet<Way> hashSet = new HashSet<Way>();
        for (Way way : this.coastlineWays) {
            if (hashSet.contains(way)) continue;
            ArrayList<Way> arrayList = new ArrayList<Way>();
            hashSet.add(way);
            arrayList.add(way);
            ArrayList<Node> arrayList2 = new ArrayList<Node>(way.getNodes());
            Way way2 = way;
            while (arrayList2.get(0) != arrayList2.get(arrayList2.size() - 1)) {
                boolean bl = false;
                for (OsmPrimitive osmPrimitive : way2.lastNode().getReferrers()) {
                    Way way3;
                    if (osmPrimitive == way2 || !Coastlines.isCoastline(osmPrimitive) || hashSet.contains(way3 = (Way)osmPrimitive) || way3.firstNode() != way2.lastNode()) continue;
                    bl = true;
                    way2 = way3;
                    hashSet.add(way2);
                    arrayList.add(way2);
                    arrayList2.remove(arrayList2.size() - 1);
                    arrayList2.addAll(way2.getNodes());
                    break;
                }
                if (bl) continue;
                break;
            }
            if (arrayList.size() <= 1 || arrayList2.get(0) != arrayList2.get(arrayList2.size() - 1) || !Geometry.isClockwise(arrayList2)) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 904).message(I18n.tr("Reversed coastline: land not on left side", new Object[0])).primitives(arrayList).build());
        }
    }

    private void checkIfReversed(Way way, Way way2, Node node) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        Way way3 = null;
        for (int i = 0; i < 2; ++i) {
            Node node2 = i == 0 ? way.firstNode() : way.lastNode();
            List<OsmPrimitive> list = node2.getReferrers();
            for (OsmPrimitive osmPrimitive : list) {
                if (osmPrimitive == way || !Coastlines.isCoastline(osmPrimitive)) continue;
                Way way4 = (Way)osmPrimitive;
                if (i == 0 && way4.firstNode() == node2) {
                    bl = true;
                    way3 = way4;
                    continue;
                }
                if (i == 1 && way4.lastNode() == node2) {
                    if (way4 == way3) continue;
                    bl2 = true;
                    continue;
                }
                ++n;
            }
        }
        if (n == 0 && bl && bl2) {
            this.addError(902, way, null, null);
        } else {
            this.addError(901, way, Collections.singletonList(way2), node);
        }
    }

    private void addError(int n, Way way, Collection<Way> collection, Node node) {
        String string;
        switch (n) {
            case 903: {
                string = I18n.tr("Unconnected coastline", new Object[0]);
                break;
            }
            case 901: {
                string = I18n.tr("Unordered coastline", new Object[0]);
                break;
            }
            case 902: {
                string = I18n.tr("Reversed coastline", new Object[0]);
                break;
            }
            default: {
                string = I18n.tr("invalid coastline", new Object[0]);
            }
        }
        HashSet<Way> hashSet = new HashSet<Way>();
        hashSet.add(way);
        if (collection != null) {
            hashSet.addAll(collection);
        }
        for (TestError testError : this.errors) {
            if (testError.getCode() != n || n != 902 && !testError.getHighlighted().contains(node) || testError.getPrimitives().size() != hashSet.size() || !testError.getPrimitives().containsAll(hashSet)) continue;
            return;
        }
        if (n != 902) {
            this.errors.add(TestError.builder(this, Severity.ERROR, n).message(string).primitives(hashSet).highlight(node).build());
        } else {
            this.errors.add(TestError.builder(this, Severity.ERROR, n).message(string).primitives(hashSet).build());
        }
    }

    @Override
    public void visit(Way way) {
        if (!way.isUsable()) {
            return;
        }
        if (Coastlines.isCoastline(way)) {
            this.coastlineWays.add(way);
        }
    }

    private static boolean isCoastline(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Way && osmPrimitive.hasTag("natural", "coastline");
    }

    @Override
    public Command fixError(TestError testError) {
        Iterator<? extends OsmPrimitive> iterator;
        if (this.isFixable(testError) && (iterator = testError.getPrimitives().iterator()).hasNext()) {
            Way way = (Way)iterator.next();
            Way way2 = new Way(way);
            List<Node> list = way2.getNodes();
            Collections.reverse(list);
            way2.setNodes(list);
            return new ChangeCommand(way, way2);
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof Coastlines) {
            return testError.getCode() == 902;
        }
        return false;
    }
}

