/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.output.outputUtils.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.facade.K2JSTranslator;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.kotlin.utils.StringsKt;

public class K2JSCompiler
extends CLICompiler<K2JSCompilerArguments> {
    private static final Map<String, ModuleKind> moduleKindMap = new HashMap<String, ModuleKind>();

    public static void main(String ... args) {
        K2JSCompiler.doMain(new K2JSCompiler(), args);
    }

    @Override
    @NotNull
    protected K2JSCompilerArguments createArguments() {
        K2JSCompilerArguments k2JSCompilerArguments = new K2JSCompilerArguments();
        if (k2JSCompilerArguments == null) {
            K2JSCompiler.$$$reportNull$$$0(0);
        }
        return k2JSCompilerArguments;
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable) {
        TranslationResult translationResult;
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            K2JSCompiler.$$$reportNull$$$0(2);
        }
        if (rootDisposable == null) {
            K2JSCompiler.$$$reportNull$$$0(3);
        }
        final MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.freeArgs.isEmpty()) {
            if (arguments2.version) {
                ExitCode exitCode = ExitCode.OK;
                if (exitCode == null) {
                    K2JSCompiler.$$$reportNull$$$0(4);
                }
                return exitCode;
            }
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                K2JSCompiler.$$$reportNull$$$0(5);
            }
            return exitCode;
        }
        ContentRootsKt.addKotlinSourceRoots(configuration, arguments2.freeArgs);
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project project = environmentForJS.getProject();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        environmentForJS.getConfiguration().put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.allowKotlinPackage);
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS, sourcesFiles)) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                K2JSCompiler.$$$reportNull$$$0(6);
            }
            return exitCode;
        }
        if (arguments2.outputFile == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify output file via -output", null);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                K2JSCompiler.$$$reportNull$$$0(7);
            }
            return exitCode;
        }
        if (messageCollector2.hasErrors()) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                K2JSCompiler.$$$reportNull$$$0(8);
            }
            return exitCode;
        }
        if (sourcesFiles.isEmpty()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "No source files", null);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                K2JSCompiler.$$$reportNull$$$0(9);
            }
            return exitCode;
        }
        if (arguments2.verbose) {
            K2JSCompiler.reportCompiledSourcesList(messageCollector2, sourcesFiles);
        }
        File outputFile = new File(arguments2.outputFile);
        configuration.put(CommonConfigurationKeys.MODULE_NAME, FileUtil.getNameWithoutExtension(outputFile));
        JsConfig config = new JsConfig(project, configuration);
        if (config.checkLibFilesAndReportErrors(new JsConfig.Reporter(){

            @Override
            public void error(@NotNull String message) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                messageCollector2.report(CompilerMessageSeverity.ERROR, message, null);
            }

            @Override
            public void warning(@NotNull String message) {
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                messageCollector2.report(CompilerMessageSeverity.STRONG_WARNING, message, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "message";
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "warning";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                K2JSCompiler.$$$reportNull$$$0(10);
            }
            return exitCode;
        }
        AnalyzerWithCompilerReport analyzerWithCompilerReport = K2JSCompiler.analyzeAndReportErrors(messageCollector2, sourcesFiles, config);
        if (analyzerWithCompilerReport.hasErrors()) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                K2JSCompiler.$$$reportNull$$$0(11);
            }
            return exitCode;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        AnalysisResult analysisResult = analyzerWithCompilerReport.getAnalysisResult();
        assert (analysisResult instanceof JsAnalysisResult) : "analysisResult should be instance of JsAnalysisResult, but " + analysisResult;
        JsAnalysisResult jsAnalysisResult = (JsAnalysisResult)analysisResult;
        File outputPrefixFile = null;
        if (arguments2.outputPrefix != null && !(outputPrefixFile = new File(arguments2.outputPrefix)).exists()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Output prefix file '" + arguments2.outputPrefix + "' not found", null);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                K2JSCompiler.$$$reportNull$$$0(12);
            }
            return exitCode;
        }
        File outputPostfixFile = null;
        if (arguments2.outputPostfix != null && !(outputPostfixFile = new File(arguments2.outputPostfix)).exists()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Output postfix file '" + arguments2.outputPostfix + "' not found", null);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                K2JSCompiler.$$$reportNull$$$0(13);
            }
            return exitCode;
        }
        MainCallParameters mainCallParameters = K2JSCompiler.createMainCallParameters(arguments2.main);
        K2JSTranslator translator = new K2JSTranslator(config);
        try {
            translationResult = translator.translate(sourcesFiles, mainCallParameters, jsAnalysisResult);
        }
        catch (Exception e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        AnalyzerWithCompilerReport.Companion.reportDiagnostics(translationResult.getDiagnostics(), messageCollector2);
        if (!(translationResult instanceof TranslationResult.Success)) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                K2JSCompiler.$$$reportNull$$$0(14);
            }
            return exitCode;
        }
        TranslationResult.Success successResult = (TranslationResult.Success)translationResult;
        OutputFileCollection outputFiles = successResult.getOutputFiles(outputFile, outputPrefixFile, outputPostfixFile);
        if (outputFile.isDirectory()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Cannot open output file '" + outputFile.getPath() + "': is a directory", null);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                K2JSCompiler.$$$reportNull$$$0(15);
            }
            return exitCode;
        }
        File outputDir2 = outputFile.getParentFile();
        if (outputDir2 == null) {
            outputDir2 = outputFile.getAbsoluteFile().getParentFile();
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        OutputUtilsKt.writeAll(outputFiles, outputDir2, messageCollector2, configuration.getBoolean(CommonConfigurationKeys.REPORT_OUTPUT_FILES));
        ExitCode exitCode = ExitCode.OK;
        if (exitCode == null) {
            K2JSCompiler.$$$reportNull$$$0(16);
        }
        return exitCode;
    }

    private static void reportCompiledSourcesList(@NotNull MessageCollector messageCollector2, @NotNull List<KtFile> sourceFiles2) {
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$0(17);
        }
        if (sourceFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$0(18);
        }
        List<String> fileNames = CollectionsKt.map(sourceFiles2, file2 -> {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile != null) {
                return FileUtil.toSystemDependentName(virtualFile.getPath());
            }
            return file2.getName() + "(no virtual file)";
        });
        messageCollector2.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + StringsKt.join(fileNames, ", "), null);
    }

    private static AnalyzerWithCompilerReport analyzeAndReportErrors(@NotNull MessageCollector messageCollector2, final @NotNull List<KtFile> sources, final @NotNull JsConfig config) {
        if (messageCollector2 == null) {
            K2JSCompiler.$$$reportNull$$$0(19);
        }
        if (sources == null) {
            K2JSCompiler.$$$reportNull$$$0(20);
        }
        if (config == null) {
            K2JSCompiler.$$$reportNull$$$0(21);
        }
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(messageCollector2);
        analyzerWithCompilerReport.analyzeAndReport(sources, new AnalyzerWithCompilerReport.Analyzer(){

            @Override
            @NotNull
            public AnalysisResult analyze() {
                JsAnalysisResult jsAnalysisResult = TopDownAnalyzerFacadeForJS.analyzeFiles(sources, config);
                if (jsAnalysisResult == null) {
                    2.$$$reportNull$$$0(0);
                }
                return jsAnalysisResult;
            }

            @Override
            public void reportEnvironmentErrors() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler$2", "analyze"));
            }
        });
        return analyzerWithCompilerReport;
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String moduleKindName;
        ModuleKind moduleKind;
        if (configuration == null) {
            K2JSCompiler.$$$reportNull$$$0(22);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(23);
        }
        if (services == null) {
            K2JSCompiler.$$$reportNull$$$0(24);
        }
        MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.target != null) assert (arguments2.target == "v5") : "Unsupported ECMA version: " + arguments2.target;
        configuration.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.sourceMap) {
            configuration.put(JSConfigurationKeys.SOURCE_MAP, true);
        }
        if (arguments2.metaInfo) {
            configuration.put(JSConfigurationKeys.META_INFO, true);
        }
        SmartList<String> libraries = new SmartList<String>();
        if (!arguments2.noStdlib) {
            libraries.add(0, PathUtil.getKotlinPathsForCompiler().getJsStdLibJarPath().getAbsolutePath());
        }
        if (arguments2.libraries != null) {
            ContainerUtil.addAll(libraries, ArraysKt.filterNot(arguments2.libraries.split(File.pathSeparator), String::isEmpty));
        }
        configuration.put(JSConfigurationKeys.LIBRARIES, libraries);
        if (arguments2.typedArrays) {
            configuration.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, true);
        }
        configuration.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.friendModulesDisabled);
        if (!arguments2.friendModulesDisabled && arguments2.friendModules != null) {
            List<String> friendPaths = ArraysKt.filterNot(arguments2.friendModules.split(File.pathSeparator), String::isEmpty);
            configuration.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        ModuleKind moduleKind2 = moduleKind = (moduleKindName = arguments2.moduleKind) != null ? moduleKindMap.get(moduleKindName) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
        }
        configuration.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
    }

    private static MainCallParameters createMainCallParameters(String main2) {
        if ("noCall".equals(main2)) {
            return MainCallParameters.noCall();
        }
        return MainCallParameters.mainWithoutArguments();
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        if ("kotlinc-js" == null) {
            K2JSCompiler.$$$reportNull$$$0(25);
        }
        return "kotlinc-js";
    }

    static {
        moduleKindMap.put("plain", ModuleKind.PLAIN);
        moduleKindMap.put("commonjs", ModuleKind.COMMON_JS);
        moduleKindMap.put("amd", ModuleKind.AMD);
        moduleKindMap.put("umd", ModuleKind.UMD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDisposable";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageCollector";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createArguments";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "executableScriptFileName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reportCompiledSourcesList";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "analyzeAndReportErrors";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setupPlatformSpecificArgumentsAndServices";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

