/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCase;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\u00020\b*\u00020\u0006H\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/DynamicOperatorCallCase;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallCase;", "()V", "canApply", "", "callInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "dispatchReceiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "kotlin-compiler"})
public final class DynamicOperatorCallCase
extends FunctionCallCase {
    public static final DynamicOperatorCallCase INSTANCE;

    public final boolean canApply(@NotNull FunctionCallInfo callInfo) {
        KtToken ktToken;
        KtToken it;
        KtElement ktElement;
        KtElement it2;
        Intrinsics.checkParameterIsNotNull(callInfo, "callInfo");
        return DynamicCallsKt.isDynamic(CallInfoExtensionsKt.getCallableDescriptor(callInfo)) && (it2 = (ktElement = callInfo.getResolvedCall().getCall().getCallElement())) instanceof KtOperationExpression && (Intrinsics.areEqual(it = (ktToken = PsiUtils.getOperationToken((KtOperationExpression)it2)), KtTokens.NOT_IN) || OperatorTable.hasCorrespondingOperator(it));
    }

    @Override
    @NotNull
    protected JsExpression dispatchReceiver(@NotNull FunctionCallInfo $receiver) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        KtElement ktElement = $receiver.getResolvedCall().getCall().getCallElement();
        if (ktElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtOperationExpression");
        }
        KtOperationExpression callElement = (KtOperationExpression)ktElement;
        KtToken operationToken = PsiUtils.getOperationToken(callElement);
        List<JsExpression> arguments2 = $receiver.getArgumentsInfo().getTranslateArguments();
        KtOperationExpression ktOperationExpression = callElement;
        if (ktOperationExpression instanceof KtBinaryExpression) {
            KtToken operationTokenToFind = Intrinsics.areEqual(operationToken, KtTokens.NOT_IN) ? (KtToken)KtTokens.IN_KEYWORD : operationToken;
            JsBinaryOperator binaryOperator = OperatorTable.getBinaryOperator(operationTokenToFind);
            jsExpression = Intrinsics.areEqual(operationTokenToFind, KtTokens.IN_KEYWORD) ? new JsBinaryOperation(binaryOperator, arguments2.get(0), $receiver.getDispatchReceiver()) : new JsBinaryOperation(binaryOperator, $receiver.getDispatchReceiver(), arguments2.get(0));
        } else if (ktOperationExpression instanceof KtPrefixExpression) {
            jsExpression = new JsPrefixOperation(OperatorTable.getUnaryOperator(operationToken), $receiver.getDispatchReceiver());
        } else if (ktOperationExpression instanceof KtPostfixExpression) {
            jsExpression = new JsPostfixOperation(OperatorTable.getUnaryOperator(operationToken), $receiver.getDispatchReceiver());
        } else {
            Void void_ = this.unsupported((CallInfo)$receiver, "Unsupported callElement type: " + callElement.getClass() + ", callElement: " + callElement + ", callInfo: " + $receiver);
            throw null;
        }
        return jsExpression;
    }

    private DynamicOperatorCallCase() {
        INSTANCE = this;
    }

    static {
        new DynamicOperatorCallCase();
    }
}

