/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecT163FieldElement;
import org.bouncycastle.math.ec.custom.sec.SecT163R2Point;
import org.bouncycastle.util.encoders.Hex;

public class SecT163R2Curve
extends ECCurve.AbstractF2m {
    private static final int SecT163R2_DEFAULT_COORDS = 6;
    protected SecT163R2Point infinity = new SecT163R2Point(this, null, null);

    public SecT163R2Curve() {
        super(163, 3, 6, 7);
        this.a = this.fromBigInteger(BigInteger.valueOf(1L));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("020A601907B8C953CA1481EB10512F78744A3205FD")));
        this.order = new BigInteger(1, Hex.decode("040000000000000000000292FE77E70C12A4234C33"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT163R2Curve();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 163;
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT163FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
        return new SecT163R2Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl) {
        return new SecT163R2Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }

    protected ECPoint decompressPoint(int n, BigInteger bigInteger) {
        ECFieldElement eCFieldElement = this.fromBigInteger(bigInteger);
        ECFieldElement eCFieldElement2 = null;
        if (eCFieldElement.isZero()) {
            eCFieldElement2 = this.b.sqrt();
        } else {
            ECFieldElement eCFieldElement3 = eCFieldElement.square().invert().multiply(this.b).add(this.a).add(eCFieldElement);
            ECFieldElement eCFieldElement4 = this.solveQuadraticEquation(eCFieldElement3);
            if (eCFieldElement4 != null) {
                if (eCFieldElement4.testBitZero() != (n == 1)) {
                    eCFieldElement4 = eCFieldElement4.addOne();
                }
                switch (this.getCoordinateSystem()) {
                    case 5: 
                    case 6: {
                        eCFieldElement2 = eCFieldElement4.add(eCFieldElement);
                        break;
                    }
                    default: {
                        eCFieldElement2 = eCFieldElement4.multiply(eCFieldElement);
                    }
                }
            }
        }
        if (eCFieldElement2 == null) {
            throw new IllegalArgumentException("Invalid point compression");
        }
        return this.createRawPoint(eCFieldElement, eCFieldElement2, true);
    }

    private ECFieldElement solveQuadraticEquation(ECFieldElement eCFieldElement) {
        if (eCFieldElement.isZero()) {
            return eCFieldElement;
        }
        ECFieldElement eCFieldElement2 = this.fromBigInteger(ECConstants.ZERO);
        ECFieldElement eCFieldElement3 = null;
        ECFieldElement eCFieldElement4 = null;
        Random random = new Random();
        do {
            ECFieldElement eCFieldElement5 = this.fromBigInteger(new BigInteger(163, random));
            eCFieldElement3 = eCFieldElement2;
            ECFieldElement eCFieldElement6 = eCFieldElement;
            for (int i = 1; i < 163; ++i) {
                ECFieldElement eCFieldElement7 = eCFieldElement6.square();
                eCFieldElement3 = eCFieldElement3.square().add(eCFieldElement7.multiply(eCFieldElement5));
                eCFieldElement6 = eCFieldElement7.add(eCFieldElement);
            }
            if (eCFieldElement6.isZero()) continue;
            return null;
        } while ((eCFieldElement4 = eCFieldElement3.square().add(eCFieldElement3)).isZero());
        return eCFieldElement3;
    }

    public int getM() {
        return 163;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 3;
    }

    public int getK2() {
        return 6;
    }

    public int getK3() {
        return 7;
    }
}

