#ifndef ELM_ATSPI_BRIDGE_EO_HH
#define ELM_ATSPI_BRIDGE_EO_HH
#include <Eo.h>

extern "C" {
#include "elm_atspi_bridge.eo.h"
#include "eo_base.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
#include "eo_base.eo.hh"
namespace elm { namespace atspi { 
struct Bridge;
} } 
namespace efl { namespace eo { template<> struct is_eolian_object< ::elm::atspi::Bridge> : ::std::true_type {}; } }

namespace eo_cxx {
namespace elm { namespace atspi { 
struct Bridge {
   ::efl::eolian::return_traits<bool>::type connected_get() const;
   static Eo_Class const* _eo_class()
   {
      return ELM_ATSPI_BRIDGE_CLASS;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::elm::atspi::Bridge() const;
   operator ::elm::atspi::Bridge&();
   operator ::elm::atspi::Bridge const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Bridge,  ::eo::Base> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Bridge const ,  ::eo::Base const > operator&() const { return {this}; }
   /// @endcond
};
} } 
}
namespace elm { namespace atspi { 
struct Bridge : ::efl::eo::concrete
   , EO_CXX_INHERIT( ::eo::Base)
{
   explicit Bridge( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Bridge(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Bridge(Bridge const& other) = default;
   Bridge(Bridge&& other) = default;
   Bridge& operator=(Bridge const& other) = default;
   Bridge& operator=(Bridge&& other) = default;
   Bridge()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Bridge( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Bridge(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   ::efl::eolian::return_traits<bool>::type connected_get() const;
   static Eo_Class const* _eo_class()
   {
      return ELM_ATSPI_BRIDGE_CLASS;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   static struct connected_event
   {
      static Eo_Event_Description const* description()
      { return ELM_ATSPI_BRIDGE_EVENT_CONNECTED; }
      typedef void parameter_type;
   } const connected_event;
   static struct disconnected_event
   {
      static Eo_Event_Description const* description()
      { return ELM_ATSPI_BRIDGE_EVENT_DISCONNECTED; }
      typedef void parameter_type;
   } const disconnected_event;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Bridge,  ::eo::Base> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Bridge const ,  ::eo::Base const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Bridge) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Bridge>::value, "");
} } 
#include "elm_atspi_bridge.eo.impl.hh"
#endif
