-- EFL LuaJIT bindings: efl_gfx_map.eo (class Efl.Gfx.Map)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.efl_gfx_map_mixin_get()
    eo.class_register("Efl_Gfx_Map", nil, nil, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *efl_gfx_map_mixin_get(void);
    void efl_gfx_map_enable_set(Eina_Bool enabled);
    Eina_Bool efl_gfx_map_enable_get(void);
    Eina_Bool efl_gfx_map_clockwise_get(void);
    void efl_gfx_map_smooth_set(Eina_Bool smooth);
    Eina_Bool efl_gfx_map_smooth_get(void);
    void efl_gfx_map_alpha_set(Eina_Bool alpha);
    Eina_Bool efl_gfx_map_alpha_get(void);
    void efl_gfx_map_point_coord_set(int idx, double x, double y, double z);
    void efl_gfx_map_point_coord_get(int idx, double *x, double *y, double *z);
    void efl_gfx_map_point_image_uv_set(int idx, double u, double v);
    void efl_gfx_map_point_image_uv_get(int idx, double *u, double *v);
    void efl_gfx_map_color_set(int idx, int r, int g, int b, int a);
    void efl_gfx_map_color_get(int idx, int *r, int *g, int *b, int *a);
    void efl_gfx_map_move_sync_set(Eina_Bool enable);
    Eina_Bool efl_gfx_map_move_sync_get(void);
    double efl_gfx_map_point_z_get(int idx);
    Eina_Bool efl_gfx_map_populate(double z);
    Eina_Bool efl_gfx_map_populate_manual(double x, double y, double w, double h, double z);
    Eina_Bool efl_gfx_map_rotate(double degrees, double cx, double cy);
    Eina_Bool efl_gfx_map_zoom(double zoomx, double zoomy, double cx, double cy);
    Eina_Bool efl_gfx_map_rotate_3d(double dx, double dy, double dz, double cx, double cy, double cz);
    Eina_Bool efl_gfx_map_quat_rotate(double qx, double qy, double qz, double qw, double cx, double cy, double cz);
    Eina_Bool efl_gfx_map_lightning_3d(double lx, double ly, double lz, int lr, int lg, int lb, int ar, int ag, int ab);
    Eina_Bool efl_gfx_map_perspective_3d(double px, double py, double z0, double foc);
    Eina_Bool efl_gfx_map_dup(const Efl_Gfx_Map * other);
]]

local __M = util.get_namespace(M, { "gfx" })
__body = {
    map_enable_set = function(self, enabled)
        eo.__do_start(self, __class)
        __lib.efl_gfx_map_enable_set(enabled)
        eo.__do_end()
    end,

    map_enable_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_enable_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_clockwise_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_clockwise_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_smooth_set = function(self, smooth)
        eo.__do_start(self, __class)
        __lib.efl_gfx_map_smooth_set(smooth)
        eo.__do_end()
    end,

    map_smooth_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_smooth_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_alpha_set = function(self, alpha)
        eo.__do_start(self, __class)
        __lib.efl_gfx_map_alpha_set(alpha)
        eo.__do_end()
    end,

    map_alpha_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_alpha_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_point_coord_set = function(self, idx, x, y, z)
        eo.__do_start(self, __class)
        __lib.efl_gfx_map_point_coord_set(idx, x, y, z)
        eo.__do_end()
    end,

    map_point_coord_get = function(self, idx)
        eo.__do_start(self, __class)
        local x = ffi.new("double[1]")
        local y = ffi.new("double[1]")
        local z = ffi.new("double[1]")
        __lib.efl_gfx_map_point_coord_get(idx, x, y, z)
        eo.__do_end()
        return tonumber(x[0]), tonumber(y[0]), tonumber(z[0])
    end,

    map_point_image_uv_set = function(self, idx, u, v)
        eo.__do_start(self, __class)
        __lib.efl_gfx_map_point_image_uv_set(idx, u, v)
        eo.__do_end()
    end,

    map_point_image_uv_get = function(self, idx)
        eo.__do_start(self, __class)
        local u = ffi.new("double[1]")
        local v = ffi.new("double[1]")
        __lib.efl_gfx_map_point_image_uv_get(idx, u, v)
        eo.__do_end()
        return tonumber(u[0]), tonumber(v[0])
    end,

    map_color_set = function(self, idx, r, g, b, a)
        eo.__do_start(self, __class)
        __lib.efl_gfx_map_color_set(idx, r, g, b, a)
        eo.__do_end()
    end,

    map_color_get = function(self, idx)
        eo.__do_start(self, __class)
        local r = ffi.new("int[1]")
        local g = ffi.new("int[1]")
        local b = ffi.new("int[1]")
        local a = ffi.new("int[1]")
        __lib.efl_gfx_map_color_get(idx, r, g, b, a)
        eo.__do_end()
        return tonumber(r[0]), tonumber(g[0]), tonumber(b[0]), tonumber(a[0])
    end,

    map_move_sync_set = function(self, enable)
        eo.__do_start(self, __class)
        __lib.efl_gfx_map_move_sync_set(enable)
        eo.__do_end()
    end,

    map_move_sync_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_move_sync_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_point_z_get = function(self, idx)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_point_z_get(idx)
        eo.__do_end()
        return tonumber(v)
    end,

    map_populate = function(self, z)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_populate(z)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_populate_manual = function(self, x, y, w, h, z)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_populate_manual(x, y, w, h, z)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_rotate = function(self, degrees, cx, cy)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_rotate(degrees, cx, cy)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_zoom = function(self, zoomx, zoomy, cx, cy)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_zoom(zoomx, zoomy, cx, cy)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_rotate_3d = function(self, dx, dy, dz, cx, cy, cz)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_rotate_3d(dx, dy, dz, cx, cy, cz)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_quat_rotate = function(self, qx, qy, qz, qw, cx, cy, cz)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_quat_rotate(qx, qy, qz, qw, cx, cy, cz)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_lightning_3d = function(self, lx, ly, lz, lr, lg, lb, ar, ag, ab)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_lightning_3d(lx, ly, lz, lr, lg, lb, ar, ag, ab)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_perspective_3d = function(self, px, py, z0, foc)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_perspective_3d(px, py, z0, foc)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    map_dup = function(self, other)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_map_dup(other)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    __properties = {
        ["map_clockwise"] = { 0, 0, 1, 0, true, false },
        ["map_alpha"] = { 0, 0, 1, 1, true, true },
        ["map_enable"] = { 0, 0, 1, 1, true, true },
        ["map_smooth"] = { 0, 0, 1, 1, true, true },
        ["map_point_z"] = { 1, 0, 1, 0, true, false },
        ["map_color"] = { 1, 1, 4, 4, true, true },
        ["map_point_image_uv"] = { 1, 1, 2, 2, true, true },
        ["map_move_sync"] = { 0, 0, 1, 1, true, true },
        ["map_point_coord"] = { 1, 1, 3, 3, true, true }
    }
}
__body["__mixin_Efl_Gfx_Map"] = true

return M
