/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import gps.convert.Conv;
import gps.log.GPSRecord;
import gps.log.out.GPSFile;

public final class GPSCompoGPSTrkFile
extends GPSFile {
    private boolean isWayType;
    private final StringBuffer rec = new StringBuffer(1024);
    private final StringBuffer wrec = new StringBuffer(1024);

    public GPSCompoGPSTrkFile() {
        this.numberOfPasses = 2;
    }

    public final void initialiseFile(BT747Path bT747Path, String string, int n, int n2) {
        super.initialiseFile(bT747Path, string, n2);
        this.isWayType = false;
    }

    public final void writeFileHeader(String string) {
        super.writeFileHeader(string);
        this.writeTxt("G  WGS 84\r\nU  1\r\nM  Generated using BT747 2.1.3 http://sf.net/projects/bt747 for CompeGPS\r\n");
    }

    protected final boolean recordIsNeeded(GPSRecord gPSRecord) {
        return this.ptFilters[0].doFilter(gPSRecord);
    }

    public final void writeRecord(GPSRecord gPSRecord) {
        boolean bl;
        super.writeRecord(gPSRecord);
        boolean bl2 = !this.isWayType && this.ptFilters[0].doFilter(gPSRecord);
        boolean bl3 = bl = this.isWayType && this.ptFilters[1].doFilter(gPSRecord);
        if (bl2 || bl) {
            this.rec.setLength(0);
            this.rec.append("T  A ");
            if (gPSRecord.hasLatitude() && this.selectedFileFields.hasLatitude()) {
                if (gPSRecord.getLatitude() >= 0.0) {
                    this.rec.append(JavaLibBridge.toString(gPSRecord.getLatitude(), 8) + '\u00ba' + "N");
                } else {
                    this.rec.append(JavaLibBridge.toString(-gPSRecord.getLatitude(), 8) + '\u00ba' + "S");
                }
            } else {
                this.rec.append("0\u00baN");
            }
            this.rec.append(" ");
            if (gPSRecord.hasLongitude() && this.selectedFileFields.hasLongitude()) {
                if (gPSRecord.getLongitude() >= 0.0) {
                    this.rec.append(JavaLibBridge.toString(gPSRecord.getLongitude(), 8) + '\u00ba' + "E");
                } else {
                    this.rec.append(JavaLibBridge.toString(-gPSRecord.getLongitude(), 8) + '\u00ba' + "W");
                }
            } else {
                this.rec.append("0\u00baE");
            }
            this.rec.append(" ");
            if (gPSRecord.hasUtc() && this.selectedFileFields.hasUtc()) {
                this.rec.append((this.t.getDay() < 10 ? "0" : "") + this.t.getDay() + "-" + Conv.idxToShortMonthStr(this.t.getMonth() - 1) + "-" + (this.t.getYear() % 100 < 10 ? "0" : "") + this.t.getYear() % 100 + " " + (this.t.getHour() < 10 ? "0" : "") + this.t.getHour() + ":" + (this.t.getMinute() < 10 ? "0" : "") + this.t.getMinute() + ":" + (this.t.getSecond() < 10 ? "0" : "") + this.t.getSecond());
                this.rec.append(" ");
            } else {
                this.rec.append("01-JAN-70 00:00:00 ");
            }
            if (bl) {
                this.wrec.setLength(0);
                this.wrec.append("W  ");
                this.wrec.append("waypt-");
                if (gPSRecord.hasRecCount()) {
                    this.wrec.append(gPSRecord.getRecCount());
                }
                this.wrec.append(this.rec.toString().substring(2));
            }
            this.rec.append("s ");
            if (gPSRecord.hasHeight() && this.selectedFileFields.hasHeight()) {
                this.rec.append(JavaLibBridge.toString(gPSRecord.getHeight(), 1));
                if (bl) {
                    this.wrec.append(JavaLibBridge.toString(gPSRecord.getHeight(), 1));
                }
            } else {
                this.rec.append("0.0");
                if (bl) {
                    this.wrec.append("0.0");
                }
            }
            this.rec.append(" 0.0 0.0 0.0 0 -1000.0 -1.0 ");
            if (gPSRecord.hasNsat() && this.selectedFileFields.hasNsat()) {
                this.rec.append(gPSRecord.getNsat() >> 8 & 0xFF);
                this.rec.append(" ");
            } else {
                this.rec.append("-1 ");
            }
            this.rec.append("-1.0 -1.0");
            this.rec.append("\r\n");
            if (!bl2) {
                this.rec.setLength(0);
            }
            if (bl) {
                this.rec.append(this.wrec.toString());
                this.rec.append("\r\n");
            }
            this.writeTxt(this.rec.toString());
            this.rec.setLength(0);
        }
    }

    public final boolean nextPass() {
        super.nextPass();
        if (!this.isWayType) {
            this.previousDate = 0;
            this.isWayType = true;
            this.ext = ".WPT";
            return true;
        }
        return false;
    }
}

