#include <stdarg.h>
#include <unistd.h>
#include "pthread_impl.h"
#include "syscall.h"

int clone(int (*func)(void *), void *stack, int flags, void *arg, ...)
{
	va_list ap;
	pid_t *ptid, *ctid;
	void  *tls;

	va_start(ap, arg);
	ptid = va_arg(ap, pid_t *);
	tls  = va_arg(ap, void *);
	ctid = va_arg(ap, pid_t *);
	va_end(ap);

	return __syscall_ret(__clone(func, stack, flags, arg, ptid, tls, ctid));
}
