#############################################################################
##
#W  ct-graphs.g               GAP4 Package `RCWA'                 Stefan Kohl
##
##  Data library of realizations of finite graphs as 'class transposition
##  graphs' -- the vertices are class transpositions, and there is an edge
##  connecting two vertices iff their product has finite order, or equi-
##  valently, iff both vertices respect a common partition.
##
##  The first list, i.e. `embeddings4', is also part of the example
##  "The ``Class Transposition Graph'' in rcwa/examples/examples.g.
##
#############################################################################

return rec(

embeddings4 := [
  [ [  ],
    [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4),
      ClassTransposition(0,2,1,6), ClassTransposition(0,2,1,8) ] ],
  [ [ [ 1, 2 ] ],
    [ ClassTransposition(0,4,1,4), ClassTransposition(2,4,3,4),
      ClassTransposition(0,2,1,6), ClassTransposition(0,2,1,10) ] ],
  [ [ [ 1, 2 ], [ 1, 3 ] ],
    [ ClassTransposition(1,4,4,6), ClassTransposition(1,2,0,6),
      ClassTransposition(3,4,0,6), ClassTransposition(0,2,1,2) ] ],
  [ [ [ 1, 2 ], [ 3, 4 ] ],
    [ ClassTransposition(1,2,0,6), ClassTransposition(3,4,2,6),
      ClassTransposition(0,2,3,6), ClassTransposition(2,4,5,6) ] ],
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 4 ] ],
    [ ClassTransposition(1,3,0,6), ClassTransposition(1,3,2,3),
      ClassTransposition(3,4,2,6), ClassTransposition(2,4,1,6) ] ],
  [ [ [ 1, 2 ], [ 1, 3 ], [ 2, 3 ] ],
    [ ClassTransposition(1,3,2,3), ClassTransposition(1,6,2,6),
      ClassTransposition(0,4,3,6), ClassTransposition(0,2,3,4) ] ],
  [ [ [ 1, 2 ], [ 1, 3 ], [ 2, 4 ] ],
    [ ClassTransposition(1,6,4,6), ClassTransposition(0,4,3,6),
      ClassTransposition(1,2,2,6), ClassTransposition(2,4,1,6) ] ],
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 4 ], [ 2, 3 ] ],
    [ ClassTransposition(3,6,4,6), ClassTransposition(0,3,2,6),
      ClassTransposition(1,3,2,6), ClassTransposition(1,5,2,5) ] ],
  [ [ [ 1, 2 ], [ 1, 3 ], [ 2, 4 ], [ 3, 4 ] ],
    [ ClassTransposition(2,4,3,4), ClassTransposition(0,4,2,4),
      ClassTransposition(1,3,0,6), ClassTransposition(1,3,5,6) ] ],
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 4 ], [ 2, 3 ], [ 2, 4 ] ],
    [ ClassTransposition(3,6,4,6), ClassTransposition(1,5,3,5),
      ClassTransposition(0,2,1,2), ClassTransposition(1,2,2,6) ] ],
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 4 ], [ 2, 3 ], [ 2, 4 ], [ 3, 4 ] ],
    [ ClassTransposition(0,3,2,3), ClassTransposition(0,4,3,4),
      ClassTransposition(3,6,4,6), ClassTransposition(2,6,5,6) ] ] ],

embeddings5 :=
[ [ [  ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,4,1,6), 
          ClassTransposition(1,2,0,4) ] ], 
  [ [ [ 2, 4 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 2, 4 ], [ 3, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6) ] ], 
  [ [ [ 1, 2 ], [ 2, 4 ], [ 2, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 4 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,1,3) ] ], 
  [ [ [ 3, 4 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 4 ], [ 3, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3) ] ], 
  [ [ [ 2, 3 ], [ 2, 4 ], [ 3, 4 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3) ] ], 
  [ [ [ 2, 3 ], [ 2, 5 ], [ 3, 4 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 3 ], [ 2, 4 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3) ] ], 
  [ [ [ 1, 4 ], [ 2, 4 ], [ 3, 4 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,3), 
          ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 3 ], [ 2, 4 ], [ 2, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 2, 4 ], [ 3, 4 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3) ] ], 
  [ [ [ 2, 3 ], [ 2, 4 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 5 ], [ 2, 3 ], [ 2, 4 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6), 
          ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 3, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 4 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 2, 3 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,3), 
          ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 2, 4 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 4 ], [ 1, 5 ], [ 2, 3 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 3 ], [ 1, 4 ], [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,2,3), 
          ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 4 ], [ 1, 5 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 3, 5 ], 
          [ 4, 5 ] ], 
      [ ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 5 ], [ 2, 3 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], 
          [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 5 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], 
          [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 4 ], [ 1, 5 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], 
          [ 3, 4 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6), 
          ClassTransposition(0,3,5,6) ] ] ],

embeddings6 :=
[ [ [  ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,4,1,6), 
          ClassTransposition(1,2,0,4), ClassTransposition(1,2,0,6) ] ], 
  [ [ [ 2, 4 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,4,1,6), ClassTransposition(1,2,0,4) ] ], 
  [ [ [ 3, 4 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,4,1,6), ClassTransposition(1,2,0,4) ] ], 
  [ [ [ 1, 4 ], [ 2, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 2, 3 ], [ 3, 4 ], [ 3, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,4,1,6), ClassTransposition(1,2,0,4) ] ], 
  [ [ [ 1, 3 ], [ 2, 4 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(1,2,0,4), ClassTransposition(1,2,2,4) ] ], 
  [ [ [ 2, 4 ], [ 3, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 2, 4 ], [ 2, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 4 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 2 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,4,1,6), ClassTransposition(1,2,0,4) ] ], 
  [ [ [ 1, 3 ], [ 1, 5 ], [ 3, 4 ], [ 3, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 3, 4 ], [ 3, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 2, 3 ], [ 2, 5 ], [ 3, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,4,6), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 2, 4 ], [ 3, 5 ], [ 3, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6) ] ], 
  [ [ [ 1, 6 ], [ 2, 4 ], [ 3, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3) ] ], 
  [ [ [ 1, 4 ], [ 2, 3 ], [ 3, 5 ], [ 3, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 4 ], [ 3, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 5 ], [ 3, 4 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 6 ], [ 2, 4 ], [ 3, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,4,1,6), ClassTransposition(0,4,3,4) ] ], 
  [ [ [ 1, 5 ], [ 2, 4 ], [ 2, 6 ], [ 3, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,4,1,4), ClassTransposition(0,4,3,6) ] ], 
  [ [ [ 1, 6 ], [ 2, 4 ], [ 3, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3) ] ], 
  [ [ [ 1, 6 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 2, 4 ], [ 2, 5 ], [ 3, 5 ], [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 5 ], [ 3, 4 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,4,1,6), 
          ClassTransposition(0,4,3,4), ClassTransposition(0,5,3,5) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 3, 5 ], [ 3, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 6 ], [ 2, 4 ], [ 2, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,4,1,6), ClassTransposition(0,4,3,4) ] ], 
  [ [ [ 1, 5 ], [ 2, 4 ], [ 3, 5 ], [ 3, 6 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 4 ], [ 2, 3 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 4 ], [ 3, 5 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 3, 4 ], [ 3, 5 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 6 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3) ] ], 
  [ [ [ 1, 3 ], [ 2, 4 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 4 ], [ 2, 4 ], [ 3, 4 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,3,2,3), 
          ClassTransposition(0,4,1,6), ClassTransposition(1,2,0,4) ] ], 
  [ [ [ 1, 2 ], [ 1, 4 ], [ 2, 4 ], [ 3, 5 ], [ 3, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,4,1,4), 
          ClassTransposition(0,4,1,6), ClassTransposition(0,4,3,4), 
          ClassTransposition(0,4,3,6), ClassTransposition(0,4,5,6) ] ], 
  [ [ [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,4,1,4), ClassTransposition(0,5,1,5) ] ], 
  [ [ [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 6 ], [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 6 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 2, 3 ], [ 2, 6 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 4 ], [ 2, 3 ], [ 2, 6 ], [ 3, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 3 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 3 ], [ 2, 4 ], [ 2, 5 ], [ 3, 6 ], [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3) ] ], 
  [ [ [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 3, 5 ], [ 3, 6 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 2, 3 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,4,6), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 2, 5 ], [ 2, 6 ], [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 4 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 2 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 6 ], [ 3, 4 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 2, 3 ], [ 2, 4 ], [ 2, 6 ], [ 3, 4 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 3, 5 ], [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 2, 4 ], [ 3, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,4,1,4), 
          ClassTransposition(1,2,0,6), ClassTransposition(1,2,2,6) ] ], 
  [ [ [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 3, 6 ], [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3) ] ], 
  [ [ [ 1, 3 ], [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 1, 4 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 6 ], [ 2, 4 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 3 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 3, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,4,3,4) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 2, 5 ], [ 3, 5 ], [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 6 ], [ 3, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 3, 4 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,3,2,3), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 5 ], [ 2, 3 ], [ 2, 5 ], [ 3, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,4,1,4), ClassTransposition(0,4,1,6), 
          ClassTransposition(0,4,3,4), ClassTransposition(0,4,3,6) ] ], 
  [ [ [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 2, 4 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 1, 3 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 6 ], [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 4 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 5 ], [ 2, 4 ], [ 3, 4 ], [ 3, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,3), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 3, 5 ], [ 3, 6 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 1, 3 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 2, 4 ], [ 3, 4 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], [ 4, 5 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 3, 4 ], [ 3, 6 ], [ 4, 5 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,6), 
          ClassTransposition(0,3,4,6), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 1, 3 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 4, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,4,1,4), ClassTransposition(0,4,3,4) ] ], 
  [ [ [ 1, 4 ], [ 1, 5 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], 
          [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 2, 6 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 3 ], [ 1, 4 ], [ 1, 5 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 6 ], 
          [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], 
          [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ], 
          [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 6 ], [ 2, 4 ], [ 2, 6 ], [ 3, 4 ], [ 3, 6 ], [ 4, 5 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,3), 
          ClassTransposition(0,3,4,6), ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 4 ], [ 2, 3 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], [ 4, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 2, 3 ], [ 2, 4 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 4, 5 ], [ 4, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,2,3), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 6 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 6 ], [ 4, 5 ], 
          [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 6 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 3, 4 ], [ 3, 6 ], [ 4, 5 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,4,1,4) ] ], 
  [ [ [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], 
          [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 6 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 2, 4 ], [ 2, 6 ], [ 3, 4 ], [ 4, 5 ], [ 4, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 6 ], [ 4, 5 ], 
          [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 2, 3 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 6 ], [ 2, 3 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 4 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], 
          [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 4 ], [ 1, 6 ], [ 2, 3 ], [ 2, 5 ], [ 3, 4 ], [ 3, 6 ], 
          [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6), 
          ClassTransposition(0,4,1,6), ClassTransposition(0,4,3,6) ] ], 
  [ [ [ 1, 4 ], [ 2, 3 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], 
          [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], 
          [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,4,1,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 6 ], [ 2, 3 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], 
          [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 6 ], [ 2, 4 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], 
          [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 3, 5 ], [ 3, 6 ], 
          [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], 
          [ 4, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], 
          [ 3, 6 ], [ 4, 5 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 5 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], 
          [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], 
          [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 6 ], [ 2, 3 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], 
          [ 3, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], 
          [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], 
          [ 3, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,2,3), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 6 ], [ 3, 4 ], [ 3, 6 ], [ 4, 5 ], 
          [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 3 ], [ 1, 4 ], [ 1, 6 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 4, 5 ], 
          [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 6 ], [ 3, 4 ], 
          [ 3, 5 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,2,3), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 5 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], 
          [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], 
          [ 3, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6), 
          ClassTransposition(0,4,1,4), ClassTransposition(0,4,2,4) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], 
          [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 3 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 6 ], [ 4, 5 ], 
          [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], 
          [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 3, 5 ], 
          [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], 
          [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 5 ], [ 1, 6 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], 
          [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], 
          [ 3, 5 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], 
          [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 4 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 3, 4 ], 
          [ 3, 5 ], [ 3, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,3), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], 
          [ 3, 5 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 5 ], [ 2, 6 ], 
          [ 3, 5 ], [ 3, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,4,1,4), ClassTransposition(0,4,1,6), 
          ClassTransposition(0,4,3,4), ClassTransposition(0,5,1,5) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 5 ], 
          [ 3, 6 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], 
          [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 6 ], [ 3, 4 ], [ 3, 6 ], 
          [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 4 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], 
          [ 3, 6 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 5 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], 
          [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], 
          [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 6 ], [ 2, 3 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], 
          [ 3, 5 ], [ 3, 6 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], 
          [ 3, 5 ], [ 3, 6 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 3 ], [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], 
          [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], 
          [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 5 ], [ 2, 6 ], 
          [ 3, 4 ], [ 3, 5 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], 
          [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 1, 6 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], 
          [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,3,6), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,3) ] ], 
  [ [ [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], 
          [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,2,1,4), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], 
          [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], 
          [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,3,4), ClassTransposition(0,2,5,6), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], 
          [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,2,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 4 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], 
          [ 3, 4 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,2,6), 
          ClassTransposition(0,3,4,6), ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 4 ], [ 1, 5 ], [ 2, 4 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], 
          [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 3 ], [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], 
          [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,1,6), 
          ClassTransposition(0,2,3,4), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], 
          [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,6), ClassTransposition(0,2,3,6), 
          ClassTransposition(0,2,5,6), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,3,4,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], 
          [ 2, 6 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,1,3), ClassTransposition(0,3,1,6), 
          ClassTransposition(0,3,2,6), ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 4 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], [ 2, 5 ], 
          [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], [ 4, 6 ], 
          [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,4), ClassTransposition(0,2,3,4), 
          ClassTransposition(0,3,1,6), ClassTransposition(0,3,2,6), 
          ClassTransposition(0,3,4,6), ClassTransposition(0,3,5,6) ] ], 
  [ [ [ 1, 2 ], [ 1, 3 ], [ 1, 4 ], [ 1, 5 ], [ 1, 6 ], [ 2, 3 ], [ 2, 4 ], 
          [ 2, 5 ], [ 2, 6 ], [ 3, 4 ], [ 3, 5 ], [ 3, 6 ], [ 4, 5 ], 
          [ 4, 6 ], [ 5, 6 ] ], 
      [ ClassTransposition(0,2,1,2), ClassTransposition(0,3,1,3), 
          ClassTransposition(0,3,2,3), ClassTransposition(0,4,1,4), 
          ClassTransposition(0,4,2,4), ClassTransposition(0,4,3,4) ] ] ]

);

#############################################################################
##
#E  ct-graphs.g . . . . . . . . . . . . . . . . . . . . . . . . . . ends here