/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ConfigurationAware;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultIncludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.FixedConflictManager;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.AbstractModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlModuleDescriptorParser
extends AbstractModuleDescriptorParser {
    static final String[] DEPENDENCY_REGULAR_ATTRIBUTES = new String[]{"org", "name", "branch", "branchConstraint", "rev", "revConstraint", "force", "transitive", "changing", "conf"};
    private static final XmlModuleDescriptorParser INSTANCE = new XmlModuleDescriptorParser();

    public static XmlModuleDescriptorParser getInstance() {
        return INSTANCE;
    }

    protected XmlModuleDescriptorParser() {
    }

    public ModuleDescriptor parseDescriptor(ParserSettings ivySettings, URL xmlURL, Resource res, boolean validate) throws ParseException, IOException {
        Parser parser = this.newParser(ivySettings);
        parser.setValidate(validate);
        parser.setResource(res);
        parser.setInput(xmlURL);
        parser.parse();
        return parser.getModuleDescriptor();
    }

    ModuleDescriptor parseDescriptor(ParserSettings ivySettings, InputStream descriptor, Resource res, boolean validate) throws ParseException, IOException {
        Parser parser = this.newParser(ivySettings);
        parser.setValidate(validate);
        parser.setResource(res);
        parser.setInput(descriptor);
        parser.parse();
        return parser.getModuleDescriptor();
    }

    protected Parser newParser(ParserSettings ivySettings) {
        return new Parser(this, ivySettings);
    }

    public boolean accept(Resource res) {
        return true;
    }

    public void toIvyFile(InputStream is, Resource res, File destFile, ModuleDescriptor md) throws IOException, ParseException {
        try {
            Namespace ns = null;
            if (md instanceof DefaultModuleDescriptor) {
                DefaultModuleDescriptor dmd = (DefaultModuleDescriptor)md;
                ns = dmd.getNamespace();
            }
            XmlModuleDescriptorUpdater.update(is, res, destFile, new UpdateOptions().setSettings(IvyContext.getContext().getSettings()).setStatus(md.getStatus()).setRevision(md.getResolvedModuleRevisionId().getRevision()).setPubdate(md.getResolvedPublicationDate()).setUpdateBranch(false).setNamespace(ns));
        }
        catch (SAXException e) {
            ParseException ex = new ParseException("exception occurred while parsing " + res, 0);
            ex.initCause(e);
            throw ex;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String toString() {
        return "ivy parser";
    }

    public static class Parser
    extends AbstractModuleDescriptorParser.AbstractParser {
        protected static final List ALLOWED_VERSIONS = Arrays.asList("1.0", "1.1", "1.2", "1.3", "1.4", "2.0", "2.1", "2.2");
        private ParserSettings settings;
        private boolean validate = true;
        private URL descriptorURL;
        private InputStream descriptorInput;
        private int state = 0;
        private PatternMatcher defaultMatcher;
        private DefaultDependencyDescriptor dd;
        private ConfigurationAware confAware;
        private MDArtifact artifact;
        private String conf;
        private boolean artifactsDeclared = false;
        private StringBuffer buffer;
        private String descriptorVersion;
        private String[] publicationsDefaultConf;

        public Parser(ModuleDescriptorParser parser, ParserSettings ivySettings) {
            super(parser);
            this.settings = ivySettings;
        }

        public void setInput(InputStream descriptorInput) {
            this.descriptorInput = descriptorInput;
        }

        public void setInput(URL descriptorURL) {
            this.descriptorURL = descriptorURL;
        }

        public void setValidate(boolean validate) {
            this.validate = validate;
        }

        public void parse() throws ParseException, IOException {
            try {
                URL schemaURL;
                URL uRL = schemaURL = this.validate ? this.getSchemaURL() : null;
                if (this.descriptorURL != null) {
                    XMLHelper.parse(this.descriptorURL, schemaURL, this);
                } else {
                    XMLHelper.parse(this.descriptorInput, schemaURL, (DefaultHandler)this, null);
                }
                this.checkConfigurations();
                this.replaceConfigurationWildcards();
                this.getMd().setModuleArtifact(DefaultArtifact.newIvyArtifact(this.getMd().getResolvedModuleRevisionId(), this.getMd().getPublicationDate()));
                if (!this.artifactsDeclared) {
                    String[] confs = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < confs.length; ++i) {
                        this.getMd().addArtifact(confs[i], new MDArtifact(this.getMd(), this.getMd().getModuleRevisionId().getName(), "jar", "jar"));
                    }
                }
                this.getMd().check();
            }
            catch (ParserConfigurationException ex) {
                IllegalStateException ise = new IllegalStateException(ex.getMessage() + " in " + this.descriptorURL);
                ise.initCause(ex);
                throw ise;
            }
            catch (Exception ex) {
                this.checkErrors();
                ParseException pe = new ParseException(ex.getMessage() + " in " + this.descriptorURL, 0);
                pe.initCause(ex);
                throw pe;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if (this.state == 11) {
                    this.getBuffer().append("<").append(qName);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.getBuffer().append(" ");
                        this.getBuffer().append(attributes.getQName(i));
                        this.getBuffer().append("=\"");
                        this.getBuffer().append(attributes.getValue(i));
                        this.getBuffer().append("\"");
                    }
                    this.getBuffer().append(">");
                    return;
                }
                if ("ivy-module".equals(qName)) {
                    this.ivyModuleStarted(attributes);
                } else if ("info".equals(qName)) {
                    this.infoStarted(attributes);
                } else if (this.state == 1 && "extends".equals(qName)) {
                    this.extendsStarted(attributes);
                } else if (this.state == 1 && "license".equals(qName)) {
                    this.getMd().addLicense(new License(this.settings.substitute(attributes.getValue("name")), this.settings.substitute(attributes.getValue("url"))));
                } else if (this.state == 1 && "description".equals(qName)) {
                    this.getMd().setHomePage(this.settings.substitute(attributes.getValue("homepage")));
                    this.state = 11;
                    this.buffer = new StringBuffer();
                } else if (!(this.state == 1 && "ivyauthor".equals(qName) || this.state == 1 && "repository".equals(qName))) {
                    if (this.state == 1 && this.isOtherNamespace(qName)) {
                        this.buffer = new StringBuffer();
                        this.state = 12;
                    } else if ("configurations".equals(qName)) {
                        this.configurationStarted(attributes);
                    } else if ("publications".equals(qName)) {
                        this.publicationsStarted(attributes);
                    } else if ("dependencies".equals(qName)) {
                        this.dependenciesStarted(attributes);
                    } else if ("conflicts".equals(qName)) {
                        if (!this.descriptorVersion.startsWith("1.")) {
                            Message.deprecated("using conflicts section is deprecated: please use hints section instead. Ivy file URL: " + this.descriptorURL);
                        }
                        this.state = 8;
                        this.checkConfigurations();
                    } else if ("artifact".equals(qName)) {
                        this.artifactStarted(qName, attributes);
                    } else if ("include".equals(qName) && this.state == 4) {
                        this.addIncludeRule(qName, attributes);
                    } else if ("exclude".equals(qName) && this.state == 4) {
                        this.addExcludeRule(qName, attributes);
                    } else if ("exclude".equals(qName) && this.state == 10) {
                        this.state = 9;
                        this.parseRule(qName, attributes);
                        this.getMd().addExcludeRule((ExcludeRule)((Object)this.confAware));
                    } else if ("dependency".equals(qName)) {
                        this.dependencyStarted(attributes);
                    } else if ("conf".equals(qName)) {
                        this.confStarted(attributes);
                    } else if ("mapped".equals(qName)) {
                        this.dd.addDependencyConfiguration(this.conf, this.settings.substitute(attributes.getValue("name")));
                    } else if ("conflict".equals(qName) && this.state == 10 || "manager".equals(qName) && this.state == 8) {
                        this.managerStarted(attributes, this.state == 8 ? "name" : "manager");
                    } else if ("override".equals(qName) && this.state == 10) {
                        this.mediationOverrideStarted(attributes);
                    } else if ("include".equals(qName) && this.state == 2) {
                        this.includeConfStarted(attributes);
                    } else if (this.validate && this.state != 12 && this.state != 11) {
                        this.addError("unknown tag " + qName);
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof SAXException) {
                    throw (SAXException)ex;
                }
                SAXException sax = new SAXException("Problem occurred while parsing ivy file: " + ex.getMessage(), ex);
                sax.initCause(ex);
                throw sax;
            }
        }

        protected String getDefaultParentLocation() {
            return "../ivy.xml";
        }

        protected void extendsStarted(Attributes attributes) throws ParseException {
            String parentOrganisation = attributes.getValue("organisation");
            String parentModule = attributes.getValue("module");
            String parentRevision = attributes.getValue("revision");
            String location = attributes.getValue("location") != null ? attributes.getValue("location") : this.getDefaultParentLocation();
            ModuleDescriptor parent = null;
            String extendType = attributes.getValue("extendType") != null ? attributes.getValue("extendType").toLowerCase() : "all";
            List<String> extendTypes = Arrays.asList(extendType.split(","));
            try {
                Message.debug("Trying to parse included ivy file :" + location);
                parent = this.parseOtherIvyFileOnFileSystem(location);
                ModuleId expected = new ModuleId(parentOrganisation, parentModule);
                ModuleId pid = parent.getModuleRevisionId().getModuleId();
                if (!expected.equals(pid)) {
                    Message.verbose("Ignoring parent Ivy file " + location + "; expected " + expected + " but found " + pid);
                    parent = null;
                }
            }
            catch (ParseException e) {
                Message.warn("Unable to parse included ivy file " + location + ": " + e.getMessage());
            }
            catch (IOException e) {
                Message.warn("Unable to parse included ivy file " + location + ": " + e.getMessage());
            }
            if (parent == null) {
                try {
                    Message.debug("Trying to parse included ivy file by asking repository for module :" + parentOrganisation + "#" + parentModule + ";" + parentRevision);
                    parent = this.parseOtherIvyFile(parentOrganisation, parentModule, parentRevision);
                }
                catch (ParseException e) {
                    Message.warn("Unable to parse included ivy file for " + parentOrganisation + "#" + parentModule + ";" + parentRevision);
                }
            }
            if (parent == null) {
                throw new ParseException("Unable to parse included ivy file for " + parentOrganisation + "#" + parentModule + ";" + parentRevision, 0);
            }
            ResolutionCacheManager cacheManager = this.settings.getResolutionCacheManager();
            File ivyFileInCache = cacheManager.getResolvedIvyFileInCache(parent.getResolvedModuleRevisionId());
            if (parent.getResource() != null && !parent.getResource().getName().equals(ivyFileInCache.toURI().toString())) {
                try {
                    parent.toIvyFile(ivyFileInCache);
                }
                catch (ParseException e) {
                    throw new ParseException("Unable to create cache file for " + parentOrganisation + "#" + parentModule + ";" + parentRevision + " Reason:" + e.getLocalizedMessage(), 0);
                }
                catch (IOException e) {
                    throw new ParseException("Unable to create cache file for " + parentOrganisation + "#" + parentModule + ";" + parentRevision + " Reason :" + e.getLocalizedMessage(), 0);
                }
            }
            DefaultExtendsDescriptor ed = new DefaultExtendsDescriptor(parent.getModuleRevisionId(), parent.getResolvedModuleRevisionId(), attributes.getValue("location"), extendTypes.toArray(new String[extendTypes.size()]));
            this.getMd().addInheritedDescriptor(ed);
            this.mergeWithOtherModuleDescriptor(extendTypes, parent);
        }

        protected void mergeWithOtherModuleDescriptor(List extendTypes, ModuleDescriptor parent) {
            if (extendTypes.contains("all")) {
                this.mergeAll(parent);
            } else {
                if (extendTypes.contains("info")) {
                    this.mergeInfo(parent);
                }
                if (extendTypes.contains("configurations")) {
                    this.mergeConfigurations(parent.getModuleRevisionId(), parent.getConfigurations());
                }
                if (extendTypes.contains("dependencies")) {
                    this.mergeDependencies(parent.getDependencies());
                }
                if (extendTypes.contains("description")) {
                    this.mergeDescription(parent.getDescription());
                }
            }
        }

        protected void mergeAll(ModuleDescriptor parent) {
            ModuleRevisionId sourceMrid = parent.getModuleRevisionId();
            this.mergeInfo(parent);
            this.mergeConfigurations(sourceMrid, parent.getConfigurations());
            this.mergeDependencies(parent.getDependencies());
            this.mergeDescription(parent.getDescription());
        }

        protected void mergeInfo(ModuleDescriptor parent) {
            ModuleRevisionId parentMrid = parent.getModuleRevisionId();
            DefaultModuleDescriptor descriptor = this.getMd();
            ModuleRevisionId currentMrid = descriptor.getModuleRevisionId();
            ModuleRevisionId mergedMrid = ModuleRevisionId.newInstance(Parser.mergeValue(parentMrid.getOrganisation(), currentMrid.getOrganisation()), currentMrid.getName(), Parser.mergeValue(parentMrid.getBranch(), currentMrid.getBranch()), Parser.mergeValue(parentMrid.getRevision(), currentMrid.getRevision()), Parser.mergeValues(parentMrid.getQualifiedExtraAttributes(), currentMrid.getQualifiedExtraAttributes()));
            descriptor.setModuleRevisionId(mergedMrid);
            descriptor.setResolvedModuleRevisionId(mergedMrid);
            descriptor.setStatus(Parser.mergeValue(parent.getStatus(), descriptor.getStatus()));
            if (descriptor.getNamespace() == null && parent instanceof DefaultModuleDescriptor) {
                Namespace parentNamespace = ((DefaultModuleDescriptor)parent).getNamespace();
                descriptor.setNamespace(parentNamespace);
            }
        }

        private static String mergeValue(String inherited, String override) {
            return override == null ? inherited : override;
        }

        private static Map mergeValues(Map inherited, Map overrides) {
            LinkedHashMap dup = new LinkedHashMap(inherited.size() + overrides.size());
            dup.putAll(inherited);
            dup.putAll(overrides);
            return dup;
        }

        protected void mergeConfigurations(ModuleRevisionId sourceMrid, Configuration[] configurations) {
            DefaultModuleDescriptor md = this.getMd();
            for (int i = 0; i < configurations.length; ++i) {
                Configuration configuration = configurations[i];
                Message.debug("Merging configuration with: " + configuration.getName());
                md.addConfiguration(new Configuration(configuration, sourceMrid));
            }
        }

        protected void mergeDependencies(DependencyDescriptor[] dependencies) {
            DefaultModuleDescriptor md = this.getMd();
            for (int i = 0; i < dependencies.length; ++i) {
                DependencyDescriptor dependencyDescriptor = dependencies[i];
                Message.debug("Merging dependency with: " + dependencyDescriptor.getDependencyRevisionId().toString());
                md.addDependency(dependencyDescriptor);
            }
        }

        protected void mergeDescription(String description) {
            String current = this.getMd().getDescription();
            if (current == null || current.trim().length() == 0) {
                this.getMd().setDescription(description);
            }
        }

        protected ModuleDescriptor parseOtherIvyFileOnFileSystem(String location) throws ParseException, IOException {
            URL url = null;
            ModuleDescriptor parent = null;
            url = this.getSettings().getRelativeUrlResolver().getURL(this.descriptorURL, location);
            Message.debug("Trying to load included ivy file from " + url.toString());
            URLResource res = new URLResource(url);
            ModuleDescriptorParser parser = ModuleDescriptorParserRegistry.getInstance().getParser(res);
            parent = parser.parseDescriptor(this.getSettings(), url, this.isValidate());
            return parent;
        }

        protected ModuleDescriptor parseOtherIvyFile(String parentOrganisation, String parentModule, String parentRevision) throws ParseException {
            DependencyResolver resolver;
            ModuleId parentModuleId = new ModuleId(parentOrganisation, parentModule);
            ModuleRevisionId parentMrid = new ModuleRevisionId(parentModuleId, parentRevision);
            File cacheFile = this.settings.getResolutionCacheManager().getResolvedIvyFileInCache(ModuleRevisionId.newInstance(parentMrid, Ivy.getWorkingRevision()));
            if (cacheFile.exists() && cacheFile.length() > 0L) {
                try {
                    Message.debug("Trying to load included ivy file from cache");
                    URL parentUrl = cacheFile.toURI().toURL();
                    ModuleDescriptor md = this.parseOtherIvyFileOnFileSystem(parentUrl.toString());
                    return md;
                }
                catch (IOException e) {
                    Message.error(e.getLocalizedMessage());
                }
            }
            DependencyDescriptor dd = new DefaultDependencyDescriptor(parentMrid, true);
            ResolveData data = IvyContext.getContext().getResolveData();
            if (data == null) {
                ResolveEngine engine = IvyContext.getContext().getIvy().getResolveEngine();
                ResolveOptions options = new ResolveOptions();
                options.setDownload(false);
                data = new ResolveData(engine, options);
            }
            if ((resolver = this.getSettings().getResolver(parentMrid)) == null) {
                return null;
            }
            ResolvedModuleRevision otherModule = resolver.getDependency(dd = NameSpaceHelper.toSystem(dd, this.getSettings().getContextNamespace()), data);
            if (otherModule == null) {
                throw new ParseException("Unable to find " + parentMrid.toString(), 0);
            }
            return otherModule.getDescriptor();
        }

        protected void publicationsStarted(Attributes attributes) {
            this.state = 3;
            this.artifactsDeclared = true;
            this.checkConfigurations();
            String defaultConf = this.settings.substitute(attributes.getValue("defaultconf"));
            if (defaultConf != null) {
                this.setPublicationsDefaultConf(defaultConf);
            }
        }

        protected void setPublicationsDefaultConf(String defaultConf) {
            this.publicationsDefaultConf = defaultConf == null ? null : defaultConf.split(",");
        }

        protected boolean isOtherNamespace(String qName) {
            return qName.indexOf(58) != -1;
        }

        protected void managerStarted(Attributes attributes, String managerAtt) {
            PatternMatcher matcher;
            ConflictManager cm;
            String org = this.settings.substitute(attributes.getValue("org"));
            org = org == null ? "*" : org;
            String mod = this.settings.substitute(attributes.getValue("module"));
            mod = mod == null ? "*" : mod;
            String name = this.settings.substitute(attributes.getValue(managerAtt));
            String rev = this.settings.substitute(attributes.getValue("rev"));
            if (rev != null) {
                String[] revs = rev.split(",");
                for (int i = 0; i < revs.length; ++i) {
                    revs[i] = revs[i].trim();
                }
                cm = new FixedConflictManager(revs);
            } else if (name != null) {
                cm = this.settings.getConflictManager(name);
                if (cm == null) {
                    this.addError("unknown conflict manager: " + name);
                    return;
                }
            } else {
                this.addError("bad conflict manager: no manager nor rev");
                return;
            }
            String matcherName = this.settings.substitute(attributes.getValue("matcher"));
            PatternMatcher patternMatcher = matcher = matcherName == null ? this.defaultMatcher : this.settings.getMatcher(matcherName);
            if (matcher == null) {
                this.addError("unknown matcher: " + matcherName);
                return;
            }
            this.getMd().addConflictManager(new ModuleId(org, mod), matcher, cm);
        }

        protected void mediationOverrideStarted(Attributes attributes) {
            PatternMatcher matcher;
            String org = this.settings.substitute(attributes.getValue("org"));
            org = org == null ? "*" : org;
            String mod = this.settings.substitute(attributes.getValue("module"));
            mod = mod == null ? "*" : mod;
            String rev = this.settings.substitute(attributes.getValue("rev"));
            String branch = this.settings.substitute(attributes.getValue("branch"));
            String matcherName = this.settings.substitute(attributes.getValue("matcher"));
            PatternMatcher patternMatcher = matcher = matcherName == null ? this.defaultMatcher : this.settings.getMatcher(matcherName);
            if (matcher == null) {
                this.addError("unknown matcher: " + matcherName);
                return;
            }
            this.getMd().addDependencyDescriptorMediator(new ModuleId(org, mod), matcher, new OverrideDependencyDescriptorMediator(branch, rev));
        }

        protected void includeConfStarted(Attributes attributes) throws SAXException, IOException, ParserConfigurationException, ParseException {
            URL url = this.settings.getRelativeUrlResolver().getURL(this.descriptorURL, this.settings.substitute(attributes.getValue("file")), this.settings.substitute(attributes.getValue("url")));
            if (url == null) {
                throw new SAXException("include tag must have a file or an url attribute");
            }
            Parser parser = new Parser(this.getModuleDescriptorParser(), this.settings);
            parser.setInput(url);
            parser.setMd(new DefaultModuleDescriptor(this.getModuleDescriptorParser(), new URLResource(url)));
            XMLHelper.parse(url, null, parser);
            Configuration[] configs = parser.getModuleDescriptor().getConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                this.getMd().addConfiguration(configs[i]);
            }
            if (parser.getDefaultConfMapping() != null) {
                Message.debug("setting default conf mapping from imported configurations file: " + parser.getDefaultConfMapping());
                this.setDefaultConfMapping(parser.getDefaultConfMapping());
            }
            if (parser.getDefaultConf() != null) {
                Message.debug("setting default conf from imported configurations file: " + parser.getDefaultConf());
                this.setDefaultConf(parser.getDefaultConf());
            }
            if (parser.getMd().isMappingOverride()) {
                Message.debug("enabling mapping-override from imported configurations file");
                this.getMd().setMappingOverride(true);
            }
        }

        protected void confStarted(Attributes attributes) {
            String conf = this.settings.substitute(attributes.getValue("name"));
            switch (this.state) {
                case 2: {
                    String visibility = this.settings.substitute(attributes.getValue("visibility"));
                    String ext = this.settings.substitute(attributes.getValue("extends"));
                    String transitiveValue = attributes.getValue("transitive");
                    boolean transitive = transitiveValue == null ? true : Boolean.valueOf(attributes.getValue("transitive"));
                    String deprecated = attributes.getValue("deprecated");
                    Configuration configuration = new Configuration(conf, Configuration.Visibility.getVisibility(visibility == null ? "public" : visibility), this.settings.substitute(attributes.getValue("description")), ext == null ? null : ext.split(","), transitive, deprecated);
                    ExtendableItemHelper.fillExtraAttributes(this.settings, configuration, attributes, new String[]{"name", "visibility", "extends", "transitive", "description", "deprecated"});
                    this.getMd().addConfiguration(configuration);
                    break;
                }
                case 3: {
                    if ("*".equals(conf)) {
                        String[] confs = this.getMd().getConfigurationsNames();
                        for (int i = 0; i < confs.length; ++i) {
                            this.artifact.addConfiguration(confs[i]);
                            this.getMd().addArtifact(confs[i], this.artifact);
                        }
                        break;
                    }
                    this.artifact.addConfiguration(conf);
                    this.getMd().addArtifact(conf, this.artifact);
                    break;
                }
                case 4: {
                    this.conf = conf;
                    String mappeds = this.settings.substitute(attributes.getValue("mapped"));
                    if (mappeds == null) break;
                    String[] mapped = mappeds.split(",");
                    for (int i = 0; i < mapped.length; ++i) {
                        this.dd.addDependencyConfiguration(conf, mapped[i].trim());
                    }
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.addConfiguration(conf);
                    break;
                }
                default: {
                    if (!this.validate) break;
                    this.addError("conf tag found in invalid tag: " + this.state);
                }
            }
        }

        protected void dependencyStarted(Attributes attributes) {
            this.state = 4;
            String org = this.settings.substitute(attributes.getValue("org"));
            if (org == null) {
                org = this.getMd().getModuleRevisionId().getOrganisation();
            }
            boolean force = Boolean.valueOf(this.settings.substitute(attributes.getValue("force")));
            boolean changing = Boolean.valueOf(this.settings.substitute(attributes.getValue("changing")));
            String transitiveValue = this.settings.substitute(attributes.getValue("transitive"));
            boolean transitive = transitiveValue == null ? true : Boolean.valueOf(attributes.getValue("transitive"));
            String name = this.settings.substitute(attributes.getValue("name"));
            String branch = this.settings.substitute(attributes.getValue("branch"));
            String branchConstraint = this.settings.substitute(attributes.getValue("branchConstraint"));
            String rev = this.settings.substitute(attributes.getValue("rev"));
            String revConstraint = this.settings.substitute(attributes.getValue("revConstraint"));
            Map extraAttributes = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, DEPENDENCY_REGULAR_ATTRIBUTES);
            ModuleRevisionId revId = ModuleRevisionId.newInstance(org, name, branch, rev, extraAttributes);
            ModuleRevisionId dynamicId = null;
            dynamicId = revConstraint == null && branchConstraint == null ? ModuleRevisionId.newInstance(org, name, branch, rev, extraAttributes, false) : (branchConstraint == null ? ModuleRevisionId.newInstance(org, name, null, revConstraint, extraAttributes, false) : ModuleRevisionId.newInstance(org, name, branchConstraint, revConstraint, extraAttributes));
            this.dd = new DefaultDependencyDescriptor(this.getMd(), revId, dynamicId, force, changing, transitive);
            this.getMd().addDependency(this.dd);
            String confs = this.settings.substitute(attributes.getValue("conf"));
            if (confs != null && confs.length() > 0) {
                this.parseDepsConfs(confs, this.dd);
            }
        }

        protected void artifactStarted(String qName, Attributes attributes) throws MalformedURLException {
            if (this.state == 3) {
                String artName = this.settings.substitute(attributes.getValue("name"));
                artName = artName == null ? this.getMd().getModuleRevisionId().getName() : artName;
                String type = this.settings.substitute(attributes.getValue("type"));
                type = type == null ? "jar" : type;
                String ext = this.settings.substitute(attributes.getValue("ext"));
                ext = ext != null ? ext : type;
                String url = this.settings.substitute(attributes.getValue("url"));
                this.artifact = new MDArtifact(this.getMd(), artName, type, ext, url == null ? null : new URL(url), ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"ext", "type", "name", "conf"}));
                String confs = this.settings.substitute(attributes.getValue("conf"));
                if (confs != null && confs.length() > 0) {
                    String[] conf = "*".equals(confs) ? this.getMd().getConfigurationsNames() : confs.split(",");
                    for (int i = 0; i < conf.length; ++i) {
                        this.artifact.addConfiguration(conf[i].trim());
                        this.getMd().addArtifact(conf[i].trim(), this.artifact);
                    }
                }
            } else if (this.state == 4) {
                this.addDependencyArtifacts(qName, attributes);
            } else if (this.validate) {
                this.addError("artifact tag found in invalid tag: " + this.state);
            }
        }

        protected void dependenciesStarted(Attributes attributes) {
            String confMappingOverride;
            this.state = 10;
            String defaultConf = this.settings.substitute(attributes.getValue("defaultconf"));
            if (defaultConf != null) {
                this.setDefaultConf(defaultConf);
            }
            if ((defaultConf = this.settings.substitute(attributes.getValue("defaultconfmapping"))) != null) {
                this.setDefaultConfMapping(defaultConf);
            }
            if ((confMappingOverride = this.settings.substitute(attributes.getValue("confmappingoverride"))) != null) {
                this.getMd().setMappingOverride(Boolean.valueOf(confMappingOverride));
            }
            this.checkConfigurations();
        }

        protected void configurationStarted(Attributes attributes) {
            this.state = 2;
            this.setDefaultConfMapping(this.settings.substitute(attributes.getValue("defaultconfmapping")));
            this.setDefaultConf(this.settings.substitute(attributes.getValue("defaultconf")));
            this.getMd().setMappingOverride(Boolean.valueOf(this.settings.substitute(attributes.getValue("confmappingoverride"))));
        }

        protected void infoStarted(Attributes attributes) {
            this.state = 1;
            String org = this.settings.substitute(attributes.getValue("organisation"));
            String module = this.settings.substitute(attributes.getValue("module"));
            String revision = this.settings.substitute(attributes.getValue("revision"));
            String branch = this.settings.substitute(attributes.getValue("branch"));
            this.getMd().setModuleRevisionId(ModuleRevisionId.newInstance(org, module, branch, revision, ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"organisation", "module", "revision", "status", "publication", "branch", "namespace", "default", "resolver"})));
            String namespace = this.settings.substitute(attributes.getValue("namespace"));
            if (namespace != null) {
                Namespace ns = this.settings.getNamespace(namespace);
                if (ns == null) {
                    Message.warn("namespace not found for " + this.getMd().getModuleRevisionId() + ": " + namespace);
                } else {
                    this.getMd().setNamespace(ns);
                }
            }
            String status = this.settings.substitute(attributes.getValue("status"));
            this.getMd().setStatus(status == null ? this.settings.getStatusManager().getDefaultStatus() : status);
            this.getMd().setDefault(Boolean.valueOf(this.settings.substitute(attributes.getValue("default"))));
            String pubDate = this.settings.substitute(attributes.getValue("publication"));
            if (pubDate != null && pubDate.length() > 0) {
                try {
                    this.getMd().setPublicationDate(Ivy.DATE_FORMAT.parse(pubDate));
                }
                catch (ParseException e) {
                    this.addError("invalid publication date format: " + pubDate);
                    this.getMd().setPublicationDate(this.getDefaultPubDate());
                }
            } else {
                this.getMd().setPublicationDate(this.getDefaultPubDate());
            }
        }

        protected void ivyModuleStarted(Attributes attributes) throws SAXException {
            this.descriptorVersion = attributes.getValue("version");
            int versionIndex = ALLOWED_VERSIONS.indexOf(this.descriptorVersion);
            if (versionIndex == -1) {
                this.addError("invalid version " + this.descriptorVersion);
                throw new SAXException("invalid version " + this.descriptorVersion);
            }
            if (versionIndex >= ALLOWED_VERSIONS.indexOf("1.3")) {
                Message.debug("post 1.3 ivy file: using exact as default matcher");
                this.defaultMatcher = this.settings.getMatcher("exact");
            } else {
                Message.debug("pre 1.3 ivy file: using exactOrRegexp as default matcher");
                this.defaultMatcher = this.settings.getMatcher("exactOrRegexp");
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).startsWith("xmlns:")) continue;
                this.getMd().addExtraAttributeNamespace(attributes.getQName(i).substring("xmlns:".length()), attributes.getValue(i));
            }
        }

        protected void addDependencyArtifacts(String tag, Attributes attributes) throws MalformedURLException {
            this.state = 5;
            this.parseRule(tag, attributes);
        }

        protected void addIncludeRule(String tag, Attributes attributes) throws MalformedURLException {
            this.state = 6;
            this.parseRule(tag, attributes);
        }

        protected void addExcludeRule(String tag, Attributes attributes) throws MalformedURLException {
            this.state = 7;
            this.parseRule(tag, attributes);
        }

        protected void parseRule(String tag, Attributes attributes) throws MalformedURLException {
            Map extraAtt;
            ArtifactId aid;
            String module;
            String org;
            PatternMatcher matcher;
            String ext;
            String type;
            String name = this.settings.substitute(attributes.getValue("name"));
            if (name == null && (name = this.settings.substitute(attributes.getValue("artifact"))) == null) {
                String string = name = "artifact".equals(tag) ? this.dd.getDependencyId().getName() : "*";
            }
            if ((type = this.settings.substitute(attributes.getValue("type"))) == null) {
                type = "artifact".equals(tag) ? "jar" : "*";
            }
            String string = ext = (ext = this.settings.substitute(attributes.getValue("ext"))) != null ? ext : type;
            if (this.state == 5) {
                String url = this.settings.substitute(attributes.getValue("url"));
                Map extraAtt2 = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"name", "type", "ext", "url", "conf"});
                this.confAware = new DefaultDependencyArtifactDescriptor(this.dd, name, type, ext, url == null ? null : new URL(url), extraAtt2);
            } else if (this.state == 6) {
                matcher = this.getPatternMatcher(attributes.getValue("matcher"));
                org = this.settings.substitute(attributes.getValue("org"));
                org = org == null ? "*" : org;
                module = this.settings.substitute(attributes.getValue("module"));
                module = module == null ? "*" : module;
                aid = new ArtifactId(new ModuleId(org, module), name, type, ext);
                extraAtt = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
                this.confAware = new DefaultIncludeRule(aid, matcher, extraAtt);
            } else {
                matcher = this.getPatternMatcher(attributes.getValue("matcher"));
                org = this.settings.substitute(attributes.getValue("org"));
                org = org == null ? "*" : org;
                module = this.settings.substitute(attributes.getValue("module"));
                module = module == null ? "*" : module;
                aid = new ArtifactId(new ModuleId(org, module), name, type, ext);
                extraAtt = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
                this.confAware = new DefaultExcludeRule(aid, matcher, extraAtt);
            }
            String confs = this.settings.substitute(attributes.getValue("conf"));
            if (confs != null && confs.length() > 0) {
                String[] conf = "*".equals(confs) ? this.getMd().getConfigurationsNames() : confs.split(",");
                for (int i = 0; i < conf.length; ++i) {
                    this.addConfiguration(conf[i].trim());
                }
            }
        }

        protected void addConfiguration(String c) {
            this.confAware.addConfiguration(c);
            if (this.state != 9) {
                if (this.confAware instanceof DependencyArtifactDescriptor) {
                    this.dd.addDependencyArtifact(c, (DependencyArtifactDescriptor)((Object)this.confAware));
                } else if (this.confAware instanceof IncludeRule) {
                    this.dd.addIncludeRule(c, (IncludeRule)((Object)this.confAware));
                } else if (this.confAware instanceof ExcludeRule) {
                    this.dd.addExcludeRule(c, (ExcludeRule)((Object)this.confAware));
                }
            }
        }

        protected PatternMatcher getPatternMatcher(String m) {
            PatternMatcher matcher;
            String matcherName = this.settings.substitute(m);
            PatternMatcher patternMatcher = matcher = matcherName == null ? this.defaultMatcher : this.settings.getMatcher(matcherName);
            if (matcher == null) {
                throw new IllegalArgumentException("unknown matcher " + matcherName);
            }
            return matcher;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.state == 3 && "artifact".equals(qName) && this.artifact.getConfigurations().length == 0) {
                String[] confs = this.publicationsDefaultConf == null ? this.getMd().getConfigurationsNames() : this.publicationsDefaultConf;
                for (int i = 0; i < confs.length; ++i) {
                    this.artifact.addConfiguration(confs[i].trim());
                    this.getMd().addArtifact(confs[i].trim(), this.artifact);
                }
            } else if ("configurations".equals(qName)) {
                this.checkConfigurations();
            } else if (this.state == 5 && "artifact".equals(qName) || this.state == 6 && "include".equals(qName) || this.state == 7 && "exclude".equals(qName)) {
                this.state = 4;
                if (this.confAware.getConfigurations().length == 0) {
                    String[] confs = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < confs.length; ++i) {
                        this.addConfiguration(confs[i]);
                    }
                }
                this.confAware = null;
            } else if ("exclude".equals(qName) && this.state == 9) {
                if (this.confAware.getConfigurations().length == 0) {
                    String[] confs = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < confs.length; ++i) {
                        this.addConfiguration(confs[i]);
                    }
                }
                this.confAware = null;
                this.state = 10;
            } else if ("dependency".equals(qName) && this.state == 4) {
                if (this.dd.getModuleConfigurations().length == 0) {
                    this.parseDepsConfs(this.getDefaultConf(), this.dd);
                }
                this.state = 10;
            } else if ("dependencies".equals(qName) && this.state == 10) {
                this.state = 0;
            } else if (this.state == 1 && "info".equals(qName)) {
                this.state = 0;
            } else if (this.state == 11 && "description".equals(qName)) {
                this.getMd().setDescription(this.buffer == null ? "" : this.buffer.toString().trim());
                this.buffer = null;
                this.state = 1;
            } else if (this.state == 12) {
                this.getMd().addExtraInfo(qName, this.buffer == null ? "" : this.buffer.toString());
                this.buffer = null;
                this.state = 1;
            } else if (this.state == 11) {
                if (this.buffer.toString().endsWith("<" + qName + ">")) {
                    this.buffer.deleteCharAt(this.buffer.length() - 1);
                    this.buffer.append("/>");
                } else {
                    this.buffer.append("</" + qName + ">");
                }
            }
        }

        protected void checkConfigurations() {
            if (this.getMd().getConfigurations().length == 0) {
                this.getMd().addConfiguration(new Configuration("default"));
            }
        }

        protected void replaceConfigurationWildcards() {
            Configuration[] configs = this.getMd().getConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                configs[i].replaceWildcards(this.getMd());
            }
        }

        protected ParserSettings getSettings() {
            return this.settings;
        }

        protected URL getDescriptorURL() {
            return this.descriptorURL;
        }

        protected InputStream getDescriptorInput() {
            return this.descriptorInput;
        }

        protected int getState() {
            return this.state;
        }

        protected void setState(int state) {
            this.state = state;
        }

        protected PatternMatcher getDefaultMatcher() {
            return this.defaultMatcher;
        }

        protected DefaultDependencyDescriptor getDd() {
            return this.dd;
        }

        protected void setDd(DefaultDependencyDescriptor dd) {
            this.dd = dd;
        }

        protected ConfigurationAware getConfAware() {
            return this.confAware;
        }

        protected void setConfAware(ConfigurationAware confAware) {
            this.confAware = confAware;
        }

        protected MDArtifact getArtifact() {
            return this.artifact;
        }

        protected void setArtifact(MDArtifact artifact) {
            this.artifact = artifact;
        }

        protected String getConf() {
            return this.conf;
        }

        protected void setConf(String conf) {
            this.conf = conf;
        }

        protected boolean isArtifactsDeclared() {
            return this.artifactsDeclared;
        }

        protected void setArtifactsDeclared(boolean artifactsDeclared) {
            this.artifactsDeclared = artifactsDeclared;
        }

        protected StringBuffer getBuffer() {
            return this.buffer;
        }

        protected void setBuffer(StringBuffer buffer) {
            this.buffer = buffer;
        }

        protected String getDescriptorVersion() {
            return this.descriptorVersion;
        }

        protected void setDescriptorVersion(String descriptorVersion) {
            this.descriptorVersion = descriptorVersion;
        }

        protected String[] getPublicationsDefaultConf() {
            return this.publicationsDefaultConf;
        }

        protected void setPublicationsDefaultConf(String[] publicationsDefaultConf) {
            this.publicationsDefaultConf = publicationsDefaultConf;
        }

        protected boolean isValidate() {
            return this.validate;
        }

        protected URL getSchemaURL() {
            return this.getClass().getResource("ivy.xsd");
        }

        public static final class State {
            public static final int NONE = 0;
            public static final int INFO = 1;
            public static final int CONF = 2;
            public static final int PUB = 3;
            public static final int DEP = 4;
            public static final int DEP_ARTIFACT = 5;
            public static final int ARTIFACT_INCLUDE = 6;
            public static final int ARTIFACT_EXCLUDE = 7;
            public static final int CONFLICT = 8;
            public static final int EXCLUDE = 9;
            public static final int DEPS = 10;
            public static final int DESCRIPTION = 11;
            public static final int EXTRA_INFO = 12;

            private State() {
            }
        }
    }
}

