/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ObjectClassLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "kotlin-compiler"})
public final class ObjectClassLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        ClassConstructorDescriptor constructor;
        Intrinsics.checkParameterIsNotNull(irClass, "irClass");
        if (Intrinsics.areEqual((Object)irClass.getDescriptor().getKind(), (Object)ClassKind.OBJECT) ^ true) {
            return;
        }
        PropertyDescriptor instanceFieldDescriptor = this.context.getSpecialDescriptorsFactory().getFieldDescriptorForObjectInstance(irClass.getDescriptor());
        ClassConstructorDescriptor classConstructorDescriptor = irClass.getDescriptor().getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Object should have a primary constructor: " + irClass.getDescriptor())));
        }
        ClassConstructorDescriptor classConstructorDescriptor2 = constructor = classConstructorDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptor2, "constructor");
        IrCallImpl instanceInitializer = new IrCallImpl(-1, -1, classConstructorDescriptor2, null, null, null, 56, null);
        IrFieldImpl instanceField = new IrFieldImpl(-1, -1, JvmLoweredDeclarationOrigin.FIELD_FOR_OBJECT_INSTANCE.INSTANCE, instanceFieldDescriptor, new IrExpressionBodyImpl(-1, -1, instanceInitializer));
        irClass.getDeclarations().add(instanceField);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public ObjectClassLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
    }
}

