/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.artefact.Enhanced;
import grails.util.Environment;
import grails.util.GrailsArrayUtils;
import grails.util.GrailsNameUtils;
import groovy.lang.AdaptingMetaClass;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.ExpandoMetaClassCreationHandle;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaProperty;
import groovy.util.ConfigObject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.cglib.reflect.FastClass;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class GrailsClassUtils {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_COMPATIBLE_CLASSES = new HashMap();

    private static final void registerPrimitiveClassPair(Class<?> left, Class<?> right) {
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(left, right);
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(right, left);
    }

    public static Class[] getAllInterfaces(Object instance) {
        Assert.notNull((Object)instance, (String)"Instance must not be null");
        return GrailsClassUtils.getAllInterfacesForClass(instance.getClass());
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        return GrailsClassUtils.getAllInterfacesForClass(clazz, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz, ClassLoader classLoader) {
        Set<Class> ifcs = GrailsClassUtils.getAllInterfacesForClassAsSet(clazz, classLoader);
        return ifcs.toArray(new Class[ifcs.size()]);
    }

    public static Set<Class> getAllInterfacesAsSet(Object instance) {
        Assert.notNull((Object)instance, (String)"Instance must not be null");
        return GrailsClassUtils.getAllInterfacesForClassAsSet(instance.getClass());
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz) {
        return GrailsClassUtils.getAllInterfacesForClassAsSet(clazz, null);
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz, ClassLoader classLoader) {
        Assert.notNull((Object)clazz, (String)"Class must not be null");
        LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
        while (clazz != null) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
                interfaces.add(ifc);
                interfaces.addAll(GrailsClassUtils.getAllInterfacesForClassAsSet(ifc, classLoader));
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static boolean isVisible(Class<?> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            Class<?> actualClass = classLoader.loadClass(clazz.getName());
            return clazz == actualClass;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static boolean isPropertyOfType(Class<?> clazz, String propertyName, Class<?> type) {
        try {
            Class<?> propType = GrailsClassUtils.getPropertyType(clazz, propertyName);
            return propType != null && propType.equals(type);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object getPropertyValueOfNewInstance(Class clazz, String propertyName, Class<?> propertyType) {
        if (clazz == null || !StringUtils.hasText((String)propertyName)) {
            return null;
        }
        try {
            return GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(BeanUtils.instantiateClass((Class)clazz), propertyName);
        }
        catch (BeanInstantiationException e) {
            return null;
        }
    }

    public static Object getPropertyValueOfNewInstance(Class<?> clazz, String propertyName) {
        if (clazz == null || !StringUtils.hasText((String)propertyName)) {
            return null;
        }
        try {
            return GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(BeanUtils.instantiateClass(clazz), propertyName);
        }
        catch (BeanInstantiationException e) {
            return null;
        }
    }

    public static PropertyDescriptor getPropertyDescriptorForValue(Object instance, Object propertyValue) {
        PropertyDescriptor[] descriptors;
        if (instance == null || propertyValue == null) {
            return null;
        }
        for (PropertyDescriptor pd : descriptors = BeanUtils.getPropertyDescriptors(instance.getClass())) {
            Object value;
            if (!GrailsClassUtils.isAssignableOrConvertibleFrom(pd.getPropertyType(), propertyValue.getClass())) continue;
            try {
                ReflectionUtils.makeAccessible((Method)pd.getReadMethod());
                value = pd.getReadMethod().invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new FatalBeanException("Problem calling readMethod of " + pd, (Throwable)e);
            }
            if (!propertyValue.equals(value)) continue;
            return pd;
        }
        return null;
    }

    public static Class<?> getPropertyType(Class<?> clazz, String propertyName) {
        if (clazz == null || !StringUtils.hasText((String)propertyName)) {
            return null;
        }
        try {
            PropertyDescriptor desc = BeanUtils.getPropertyDescriptor(clazz, (String)propertyName);
            if (desc != null) {
                return desc.getPropertyType();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PropertyDescriptor[] getPropertiesOfType(Class<?> clazz, Class<?> propertyType) {
        if (clazz == null || propertyType == null) {
            return new PropertyDescriptor[0];
        }
        HashSet<PropertyDescriptor> properties = new HashSet<PropertyDescriptor>();
        try {
            for (PropertyDescriptor descriptor : BeanUtils.getPropertyDescriptors(clazz)) {
                Class<?> currentPropertyType = descriptor.getPropertyType();
                if (!GrailsClassUtils.isTypeInstanceOfPropertyType(propertyType, currentPropertyType)) continue;
                properties.add(descriptor);
            }
        }
        catch (Exception e) {
            return new PropertyDescriptor[0];
        }
        return properties.toArray(new PropertyDescriptor[properties.size()]);
    }

    private static boolean isTypeInstanceOfPropertyType(Class<?> type, Class<?> propertyType) {
        return propertyType.isAssignableFrom(type) && !propertyType.equals(Object.class);
    }

    public static PropertyDescriptor[] getPropertiesAssignableToType(Class<?> clazz, Class<?> propertySuperType) {
        if (clazz == null || propertySuperType == null) {
            return new PropertyDescriptor[0];
        }
        HashSet<PropertyDescriptor> properties = new HashSet<PropertyDescriptor>();
        try {
            for (PropertyDescriptor descriptor : BeanUtils.getPropertyDescriptors(clazz)) {
                if (!propertySuperType.isAssignableFrom(descriptor.getPropertyType())) continue;
                properties.add(descriptor);
            }
        }
        catch (Exception e) {
            return new PropertyDescriptor[0];
        }
        return properties.toArray(new PropertyDescriptor[properties.size()]);
    }

    public static PropertyDescriptor getProperty(Class<?> clazz, String propertyName, Class<?> propertyType) {
        if (clazz == null || propertyName == null || propertyType == null) {
            return null;
        }
        try {
            PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(clazz, (String)propertyName);
            if (pd != null && pd.getPropertyType().equals(propertyType)) {
                return pd;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PropertyDescriptor getProperty(Class<?> clazz, String propertyName) {
        if (clazz == null || propertyName == null) {
            return null;
        }
        try {
            return BeanUtils.getPropertyDescriptor(clazz, (String)propertyName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object[] collectionToObjectArray(Collection c) {
        if (c == null) {
            return new Object[0];
        }
        return c.toArray(new Object[c.size()]);
    }

    public static boolean isMatchBetweenPrimativeAndWrapperTypes(Class leftType, Class rightType) {
        if (leftType == null) {
            throw new NullPointerException("Left type is null!");
        }
        if (rightType == null) {
            throw new NullPointerException("Right type is null!");
        }
        Class<?> r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(leftType);
        return r == rightType;
    }

    public static boolean isGroovyAssignableFrom(Class<?> leftType, Class<?> rightType) {
        boolean result;
        if (leftType == null) {
            throw new NullPointerException("Left type is null!");
        }
        if (rightType == null) {
            throw new NullPointerException("Right type is null!");
        }
        if (leftType == Object.class) {
            return true;
        }
        if (leftType == rightType) {
            return true;
        }
        Class<?> r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(leftType);
        boolean bl = result = r == rightType;
        if (!result) {
            if (rightType.isPrimitive()) {
                r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(rightType);
                if (r != null) {
                    result = leftType.isAssignableFrom(r);
                }
            } else {
                result = leftType.isAssignableFrom(rightType);
            }
        }
        return result;
    }

    public static boolean isStaticProperty(Class clazz, String propertyName) {
        Method getter = BeanUtils.findDeclaredMethod((Class)clazz, (String)GrailsClassUtils.getGetterName(propertyName), (Class[])null);
        if (getter != null) {
            return GrailsClassUtils.isPublicStatic(getter);
        }
        try {
            Field f = clazz.getDeclaredField(propertyName);
            if (f != null) {
                return GrailsClassUtils.isPublicStatic(f);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isPublicStatic(Method m) {
        int modifiers = m.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
    }

    public static boolean isPublicStatic(Field f) {
        int modifiers = f.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
    }

    public static String getGetterName(String propertyName) {
        return GrailsNameUtils.getGetterName((String)propertyName);
    }

    public static Object getStaticFieldValue(Class<?> clazz, String name) {
        Field field = ReflectionUtils.findField(clazz, (String)name);
        if (field != null) {
            ReflectionUtils.makeAccessible((Field)field);
            try {
                return field.get(clazz);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object getStaticPropertyValue(Class<?> clazz, String name) {
        Method getter = BeanUtils.findDeclaredMethod(clazz, (String)GrailsClassUtils.getGetterName(name), (Class[])null);
        try {
            if (getter != null) {
                ReflectionUtils.makeAccessible((Method)getter);
                return getter.invoke(clazz, new Object[0]);
            }
            return GrailsClassUtils.getStaticFieldValue(clazz, name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getPropertyOrStaticPropertyOrFieldValue(Object obj, String name) throws BeansException {
        BeanWrapperImpl ref = new BeanWrapperImpl(obj);
        return GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue((BeanWrapper)ref, obj, name);
    }

    public static Object getPropertyOrStaticPropertyOrFieldValue(BeanWrapper ref, Object obj, String name) {
        if (ref.isReadableProperty(name)) {
            return ref.getPropertyValue(name);
        }
        if (GrailsClassUtils.isPublicField(obj, name)) {
            return GrailsClassUtils.getFieldValue(obj, name);
        }
        Class<?> clazz = obj.getClass();
        if (GrailsClassUtils.isStaticProperty(clazz, name)) {
            return GrailsClassUtils.getStaticPropertyValue(clazz, name);
        }
        return null;
    }

    public static Object getFieldValue(Object obj, String name) {
        Class<?> clazz = obj.getClass();
        try {
            Field f = clazz.getDeclaredField(name);
            return f.get(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isPublicField(Object obj, String name) {
        Class<?> clazz = obj.getClass();
        try {
            Field f = clazz.getDeclaredField(name);
            return Modifier.isPublic(f.getModifiers());
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public static boolean isPropertyInherited(Class clz, String propertyName) {
        if (clz == null) {
            return false;
        }
        Assert.isTrue((boolean)StringUtils.hasText((String)propertyName), (String)"Argument [propertyName] cannot be null or blank");
        Class superClass = clz.getSuperclass();
        PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(superClass, (String)propertyName);
        return pd != null && pd.getReadMethod() != null;
    }

    public static boolean isPropertyGetter(Method method) {
        return !Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && GrailsClassUtils.isGetter(method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    public static Collection createConcreteCollection(Class interfaceType) {
        AbstractCollection elements = interfaceType.equals(List.class) || interfaceType.equals(Collection.class) ? new ArrayList() : (interfaceType.equals(SortedSet.class) ? new TreeSet() : new HashSet());
        return elements;
    }

    public static String getSetterName(String propertyName) {
        return GrailsNameUtils.getSetterName((String)propertyName);
    }

    public static boolean isGetter(String name, Class<?>[] args) {
        return GrailsClassUtils.isGetter(name, Boolean.TYPE, args);
    }

    public static boolean isGetter(String name, Class returnType, Class<?>[] args) {
        if (!StringUtils.hasText((String)name) || args == null) {
            return false;
        }
        if (args.length != 0) {
            return false;
        }
        return name.startsWith("get") ? GrailsClassUtils.isPropertyMethodSuffix(name = name.substring(3)) : name.startsWith("is") && returnType == Boolean.TYPE && GrailsClassUtils.isPropertyMethodSuffix(name = name.substring(2));
    }

    protected static boolean isPropertyMethodSuffix(String suffix) {
        if (suffix.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(suffix.charAt(0))) {
            return false;
        }
        if (suffix.length() == 1) {
            return Character.isUpperCase(suffix.charAt(0));
        }
        return Character.isUpperCase(suffix.charAt(0)) || Character.isUpperCase(suffix.charAt(1));
    }

    public static String getPropertyForGetter(String getterName) {
        return GrailsClassUtils.getPropertyForGetter(getterName, Boolean.TYPE);
    }

    public static String getPropertyForGetter(String getterName, Class returnType) {
        if (getterName == null || getterName.length() == 0) {
            return null;
        }
        if (getterName.startsWith("get")) {
            String prop = getterName.substring(3);
            return GrailsClassUtils.convertValidPropertyMethodSuffix(prop);
        }
        if (getterName.startsWith("is") && returnType == Boolean.TYPE) {
            String prop = getterName.substring(2);
            return GrailsClassUtils.convertValidPropertyMethodSuffix(prop);
        }
        return null;
    }

    private static String convertValidPropertyMethodSuffix(String suffix) {
        if (suffix.length() == 0) {
            return null;
        }
        if (!Character.isJavaIdentifierStart(suffix.charAt(0))) {
            return null;
        }
        if (suffix.length() == 1) {
            return Character.isUpperCase(suffix.charAt(0)) ? suffix.toLowerCase() : null;
        }
        if (Character.isUpperCase(suffix.charAt(1))) {
            return suffix;
        }
        if (Character.isUpperCase(suffix.charAt(0))) {
            return Character.toLowerCase(suffix.charAt(0)) + suffix.substring(1);
        }
        if ('_' == suffix.charAt(0)) {
            return suffix;
        }
        return null;
    }

    public static String getPropertyForSetter(String setterName) {
        if (setterName == null || setterName.length() == 0) {
            return null;
        }
        if (setterName.startsWith("set")) {
            String prop = setterName.substring(3);
            return GrailsClassUtils.convertValidPropertyMethodSuffix(prop);
        }
        return null;
    }

    public static boolean isSetter(String name, Class[] args) {
        if (!StringUtils.hasText((String)name) || args == null) {
            return false;
        }
        if (name.startsWith("set")) {
            if (args.length != 1) {
                return false;
            }
            return GrailsClassUtils.isPropertyMethodSuffix(name.substring(3));
        }
        return false;
    }

    public static MetaClass getExpandoMetaClass(Class clazz) {
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        Assert.isTrue((boolean)(registry.getMetaClassCreationHandler() instanceof ExpandoMetaClassCreationHandle), (String)("Grails requires an instance of [ExpandoMetaClassCreationHandle] to be set in Groovy's MetaClassRegistry! (current is : " + registry.getMetaClassCreationHandler() + ")"));
        MetaClass mc = registry.getMetaClass(clazz);
        AdaptingMetaClass adapter = null;
        if (mc instanceof AdaptingMetaClass) {
            adapter = (AdaptingMetaClass)mc;
            mc = ((AdaptingMetaClass)mc).getAdaptee();
        }
        if (!(mc instanceof ExpandoMetaClass)) {
            registry.removeMetaClass(clazz);
            mc = registry.getMetaClass(clazz);
            if (adapter != null) {
                adapter.setAdaptee(mc);
            }
        }
        Assert.isTrue((boolean)(mc instanceof ExpandoMetaClass), (String)"BUG! Method must return an instance of [ExpandoMetaClass]!");
        return mc;
    }

    public static boolean isAssignableOrConvertibleFrom(Class<?> clazz, Class<?> type) {
        if (type == null || clazz == null) {
            return false;
        }
        if (type.isPrimitive()) {
            Class<?> primitiveClass = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(type);
            if (primitiveClass == null) {
                return false;
            }
            return clazz.isAssignableFrom(primitiveClass);
        }
        return clazz.isAssignableFrom(type);
    }

    public static boolean getBooleanFromMap(String key, Map<?, ?> map) {
        boolean defaultValue = false;
        return GrailsClassUtils.getBooleanFromMap(key, map, defaultValue);
    }

    public static boolean getBooleanFromMap(String key, Map<?, ?> map, boolean defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        if (map.containsKey(key)) {
            Object o = map.get(key);
            if (o == null) {
                return defaultValue;
            }
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return Boolean.valueOf(o.toString());
        }
        return defaultValue;
    }

    public static String findPropertyNameForValue(Object target, Object obj) {
        MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
        List metaProperties = mc.getProperties();
        for (MetaProperty metaProperty : metaProperties) {
            Object val;
            if (!GrailsClassUtils.isAssignableOrConvertibleFrom(metaProperty.getType(), obj.getClass()) || (val = metaProperty.getProperty(target)) == null || !val.equals(obj)) continue;
            return metaProperty.getName();
        }
        return null;
    }

    public static boolean isClassBelowPackage(Class<?> theClass, List<?> packageList) {
        String classPackage = theClass.getPackage().getName();
        for (Object packageName : packageList) {
            if (packageName == null || !classPackage.startsWith(packageName.toString())) continue;
            return true;
        }
        return false;
    }

    public static Object instantiateFromConfig(ConfigObject config, String configKey, String defaultClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, LinkageError {
        return GrailsClassUtils.instantiateFromFlatConfig(config.flatten(), configKey, defaultClassName);
    }

    public static Object instantiateFromFlatConfig(Map<String, Object> flatConfig, String configKey, String defaultClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, LinkageError {
        String className = defaultClassName;
        Object configName = flatConfig.get(configKey);
        if (configName instanceof CharSequence) {
            className = configName.toString();
        }
        return ClassUtils.forName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader()).newInstance();
    }

    public static Boolean hasBeenEnhancedForFeature(Class<?> controllerClass, String featureName) {
        Object[] enhancedFor;
        boolean hasBeenEnhanced = false;
        Enhanced enhancedAnnotation = controllerClass.getAnnotation(Enhanced.class);
        if (enhancedAnnotation != null && (enhancedFor = enhancedAnnotation.enhancedFor()) != null) {
            hasBeenEnhanced = GrailsArrayUtils.contains(enhancedFor, featureName);
        }
        return hasBeenEnhanced;
    }

    public static FastClass fastClass(Class superClass) {
        FastClass.Generator gen = new FastClass.Generator();
        gen.setType(superClass);
        gen.setClassLoader(superClass.getClassLoader());
        gen.setUseCache(!Environment.isReloadingAgentEnabled());
        return gen.create();
    }

    static {
        GrailsClassUtils.registerPrimitiveClassPair(Boolean.class, Boolean.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Integer.class, Integer.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Short.class, Short.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Byte.class, Byte.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Character.class, Character.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Long.class, Long.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Float.class, Float.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Double.class, Double.TYPE);
    }
}

