/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Dimension;
import java.io.InputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.SwingGui;
import org.mozilla.javascript.tools.shell.Global;

public class Main
implements ContextListener {
    private Dim dim = new Dim();
    private SwingGui debugGui;

    public Main(String string) {
        this.debugGui = new SwingGui(this.dim, string);
    }

    public JFrame getDebugFrame() {
        return this.debugGui;
    }

    public void doBreak() {
        this.dim.setBreak();
    }

    public void setBreakOnExceptions(boolean bl) {
        this.dim.setBreakOnExceptions(bl);
        this.debugGui.getMenubar().getBreakOnExceptions().setSelected(bl);
    }

    public void setBreakOnEnter(boolean bl) {
        this.dim.setBreakOnEnter(bl);
        this.debugGui.getMenubar().getBreakOnEnter().setSelected(bl);
    }

    public void setBreakOnReturn(boolean bl) {
        this.dim.setBreakOnReturn(bl);
        this.debugGui.getMenubar().getBreakOnReturn().setSelected(bl);
    }

    public void clearAllBreakpoints() {
        this.dim.clearAllBreakpoints();
    }

    public void go() {
        this.dim.go();
    }

    public void setScope(Scriptable scriptable) {
        this.setScopeProvider(IProxy.newScopeProvider(scriptable));
    }

    public void setScopeProvider(ScopeProvider scopeProvider) {
        this.dim.setScopeProvider(scopeProvider);
    }

    public void setExitAction(Runnable runnable) {
        this.debugGui.setExitAction(runnable);
    }

    public InputStream getIn() {
        return this.debugGui.getConsole().getIn();
    }

    public PrintStream getOut() {
        return this.debugGui.getConsole().getOut();
    }

    public PrintStream getErr() {
        return this.debugGui.getConsole().getErr();
    }

    public void pack() {
        this.debugGui.pack();
    }

    public void setSize(int n, int n2) {
        this.debugGui.setSize(n, n2);
    }

    public void setVisible(boolean bl) {
        this.debugGui.setVisible(bl);
    }

    public boolean isVisible() {
        return this.debugGui.isVisible();
    }

    public void dispose() {
        this.clearAllBreakpoints();
        this.dim.go();
        this.debugGui.dispose();
        this.dim = null;
    }

    public void attachTo(ContextFactory contextFactory) {
        this.dim.attachTo(contextFactory);
    }

    public void detach() {
        this.dim.detach();
    }

    public static void main(String[] stringArray) {
        Main main = new Main("Rhino JavaScript Debugger");
        main.doBreak();
        main.setExitAction(new IProxy(1));
        System.setIn(main.getIn());
        System.setOut(main.getOut());
        System.setErr(main.getErr());
        Global global = org.mozilla.javascript.tools.shell.Main.getGlobal();
        global.setIn(main.getIn());
        global.setOut(main.getOut());
        global.setErr(main.getErr());
        main.attachTo(org.mozilla.javascript.tools.shell.Main.shellContextFactory);
        main.setScope(global);
        main.pack();
        main.setSize(600, 460);
        main.setVisible(true);
        org.mozilla.javascript.tools.shell.Main.exec(stringArray);
    }

    public static void mainEmbedded(String string) {
        ContextFactory contextFactory = ContextFactory.getGlobal();
        Global global = new Global();
        global.init(contextFactory);
        Main.mainEmbedded(contextFactory, global, string);
    }

    public static void mainEmbedded(ContextFactory contextFactory, Scriptable scriptable, String string) {
        Main.mainEmbeddedImpl(contextFactory, scriptable, string);
    }

    public static void mainEmbedded(ContextFactory contextFactory, ScopeProvider scopeProvider, String string) {
        Main.mainEmbeddedImpl(contextFactory, scopeProvider, string);
    }

    private static void mainEmbeddedImpl(ContextFactory contextFactory, Object object, String string) {
        if (string == null) {
            string = "Rhino JavaScript Debugger (embedded usage)";
        }
        Main main = new Main(string);
        main.doBreak();
        main.setExitAction(new IProxy(1));
        main.attachTo(contextFactory);
        if (object instanceof ScopeProvider) {
            main.setScopeProvider((ScopeProvider)object);
        } else {
            Scriptable scriptable = (Scriptable)object;
            if (scriptable instanceof Global) {
                Global global = (Global)scriptable;
                global.setIn(main.getIn());
                global.setOut(main.getOut());
                global.setErr(main.getErr());
            }
            main.setScope(scriptable);
        }
        main.pack();
        main.setSize(600, 460);
        main.setVisible(true);
    }

    public void setSize(Dimension dimension) {
        this.debugGui.setSize(dimension.width, dimension.height);
    }

    public void setOptimizationLevel(int n) {
    }

    public void contextEntered(Context context) {
        throw new IllegalStateException();
    }

    public void contextExited(Context context) {
        throw new IllegalStateException();
    }

    public void contextCreated(Context context) {
        throw new IllegalStateException();
    }

    public void contextReleased(Context context) {
        throw new IllegalStateException();
    }

    private static class IProxy
    implements Runnable,
    ScopeProvider {
        public static final int EXIT_ACTION = 1;
        public static final int SCOPE_PROVIDER = 2;
        private final int type;
        private Scriptable scope;

        public IProxy(int n) {
            this.type = n;
        }

        public static ScopeProvider newScopeProvider(Scriptable scriptable) {
            IProxy iProxy = new IProxy(2);
            iProxy.scope = scriptable;
            return iProxy;
        }

        public void run() {
            if (this.type != 1) {
                Kit.codeBug();
            }
            System.exit(0);
        }

        public Scriptable getScope() {
            if (this.type != 2) {
                Kit.codeBug();
            }
            if (this.scope == null) {
                Kit.codeBug();
            }
            return this.scope;
        }
    }
}

