/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.RedundantNopsCleanupMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/RedundantNopsCleanupMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "recordNopsRequiredForSourceCodeLines", "", "first", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "requiredNops", "", "recordNopsRequiredForTryCatchBlocks", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "transform", "internalClassName", "", "kotlin-compiler"})
public final class RedundantNopsCleanupMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        HashSet requiredNops = new HashSet();
        AbstractInsnNode abstractInsnNode = methodNode.instructions.getFirst();
        Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "methodNode.instructions.first");
        this.recordNopsRequiredForSourceCodeLines(abstractInsnNode, requiredNops);
        this.recordNopsRequiredForTryCatchBlocks(methodNode, requiredNops);
        AbstractInsnNode current = methodNode.instructions.getFirst();
        while (current != null) {
            if (current.getOpcode() == 0 && !requiredNops.contains(current)) {
                AbstractInsnNode toRemove = current;
                current = current.getNext();
                methodNode.instructions.remove(toRemove);
                continue;
            }
            current = current.getNext();
        }
    }

    private final void recordNopsRequiredForSourceCodeLines(AbstractInsnNode first, Set<AbstractInsnNode> requiredNops) {
        AbstractInsnNode current = first;
        while (current != null) {
            if (current instanceof LineNumberNode) {
                LineNumberNode nextLineNumberNode = RedundantNopsCleanupMethodTransformerKt.getNextLineNumberNode((LineNumberNode)current);
                CollectionsKt.addIfNotNull((Collection)requiredNops, RedundantNopsCleanupMethodTransformerKt.getRequiredNopInRange(current, nextLineNumberNode));
                current = nextLineNumberNode;
                continue;
            }
            current = current.getNext();
        }
    }

    private final void recordNopsRequiredForTryCatchBlocks(MethodNode methodNode, Set<AbstractInsnNode> requiredNops) {
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            AbstractInsnNode nop;
            AbstractInsnNode it;
            AbstractInsnNode finger$iv;
            AbstractInsnNode $receiver$iv = tcb.start;
            for (finger$iv = $receiver$iv.getNext(); finger$iv != null && !UtilKt.isMeaningful(it = finger$iv); finger$iv = finger$iv.getNext()) {
            }
            AbstractInsnNode abstractInsnNode = nop = finger$iv;
            if (!Intrinsics.areEqual(abstractInsnNode != null ? Integer.valueOf(abstractInsnNode.getOpcode()) : null, (Object)0)) continue;
            requiredNops.add(nop);
        }
    }
}

