/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "ALLOWED_SCOPE_KINDS", "", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "kotlin-compiler"})
public final class CoroutineSuspendCallChecker
implements CallChecker {
    private static final Set<LexicalScopeKind> ALLOWED_SCOPE_KINDS;
    public static final CoroutineSuspendCallChecker INSTANCE;

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        block18: {
            Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
            Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
            Intrinsics.checkParameterIsNotNull(context, "context");
            v0 = resolvedCall.getCandidateDescriptor();
            if (!(v0 instanceof FunctionDescriptor)) {
                v0 = null;
            }
            v1 = (FunctionDescriptor)v0;
            if (v1 == null) {
                return;
            }
            descriptor = v1;
            if (!descriptor.isSuspend()) {
                return;
            }
            var6_5 = ScopeUtilsKt.getParentsWithSelf(context.getScope());
            var7_6 = $receiver$iv.iterator();
            while (var7_6.hasNext()) {
                element$iv = var7_6.next();
                it = (HierarchicalScope)element$iv;
                if (!(it instanceof LexicalScope) || !CoroutineSuspendCallChecker.ALLOWED_SCOPE_KINDS.contains((Object)((LexicalScope)it).getKind())) ** GOTO lbl-1000
                $receiver$iv = ((LexicalScope)it).getOwnerDescriptor();
                v2 = $receiver$iv;
                if (!(v2 instanceof FunctionDescriptor)) {
                    v2 = null;
                }
                v3 = (FunctionDescriptor)v2;
                if (Intrinsics.areEqual(v3 != null ? Boolean.valueOf(v3.isSuspend()) : null, true)) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                v5 = element$iv;
                break block18;
            }
            v5 = null;
        }
        if ((v6 = (HierarchicalScope)v5) == null) ** GOTO lbl-1000
        $receiver$iv = v6;
        v7 = $receiver$iv;
        if (v7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.LexicalScope");
        }
        v6 = (LexicalScope)v7;
        if (v6 != null && (v6 = v6.getOwnerDescriptor()) != null) {
            $receiver$iv = v6;
            v8 = $receiver$iv;
            if (v8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            v9 = (FunctionDescriptor)v8;
        } else lbl-1000:
        // 2 sources

        {
            v9 = enclosingSuspendFunction = null;
        }
        if (enclosingSuspendFunction != null) {
            v10 = resolvedCall.getCall().getCallElement();
            if (v10 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            callElement = (KtExpression)v10;
            if (!InlineUtil.checkNonLocalReturnUsage(enclosingSuspendFunction, callElement, context.getResolutionContext())) {
                context.getTrace().report(Errors.NON_LOCAL_SUSPENSION_POINT.on(reportOn));
            } else {
                block19: {
                    $receiver$iv = ScopeUtilsKt.getParentsWithSelf(context.getScope());
                    var8_7 = $receiver$iv.iterator();
                    while (var8_7.hasNext()) {
                        element$iv = var8_7.next();
                        it = element$iv;
                        if (!CoroutineCallCheckerKt.access$isScopeForDefaultParameterValuesOf(it, enclosingSuspendFunction)) continue;
                        v11 = true;
                        break block19;
                    }
                    v11 = false;
                }
                if (v11) {
                    context.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "suspend function calls in a context of default parameter value"));
                }
            }
            context.getTrace().record(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall.getCall(), enclosingSuspendFunction);
            CoroutineCallCheckerKt.access$checkRestrictsSuspension(enclosingSuspendFunction, resolvedCall, reportOn, context);
        } else {
            context.getTrace().report(Errors.ILLEGAL_SUSPEND_FUNCTION_CALL.on(reportOn, (CallableDescriptor)resolvedCall.getCandidateDescriptor()));
        }
    }

    private CoroutineSuspendCallChecker() {
        INSTANCE = this;
        ALLOWED_SCOPE_KINDS = SetsKt.setOf(new LexicalScopeKind[]{LexicalScopeKind.FUNCTION_INNER_SCOPE, LexicalScopeKind.FUNCTION_HEADER_FOR_DESTRUCTURING});
    }

    static {
        new CoroutineSuspendCallChecker();
    }
}

