/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.apdufile;

import java.io.File;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.spi.actions.Single;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SendAction
extends Single<DataObject> {
    public SendAction() {
        super(DataObject.class, NbBundle.getMessage(SendAction.class, (String)"ACTION_SEND_APDU"), null);
    }

    public static FileObject findBuildXml(Project project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    protected void actionPerformed(DataObject dataObject) {
        try {
            Project owner = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
            ProjectKind kind = (ProjectKind)owner.getLookup().lookup(ProjectKind.class);
            if (kind == null || !kind.isApplet()) {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SendAction.class, (String)"ERR_NO_PROJECT"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                return;
            }
            FileObject buildFo = SendAction.findBuildXml(owner);
            if (buildFo == null || !buildFo.isValid()) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SendAction.class, (String)"ERR_NO_BUILD_SCRIPT"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                return;
            }
            Properties p = new Properties();
            File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
            if (file == null) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SendAction.class, (String)"ERR_NOT_REGULAR_FILE", (Object)dataObject.getName()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                return;
            }
            p.setProperty("apdu.script.file", FileUtil.toFile((FileObject)dataObject.getPrimaryFile()).getAbsolutePath());
            ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{"--run-apdutool--"}, (Properties)p);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

