/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.resources.impl.model;

import java.util.ArrayList;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.javaee.resources.api.JmsDestination;
import org.netbeans.modules.javaee.resources.api.model.Location;
import org.netbeans.modules.javaee.resources.api.model.Refreshable;
import org.netbeans.modules.javaee.resources.impl.model.JndiResourcesValueHandlers;
import org.netbeans.modules.javaee.resources.impl.model.LocationHelper;

public final class JmsDestinationImpl
extends PersistentObject
implements JmsDestination,
Refreshable {
    private SimpleImpl holder;

    protected JmsDestinationImpl(AnnotationModelHelper helper, TypeElement typeElement) {
        super(helper, typeElement);
        boolean valid = this.refresh(typeElement);
        assert (valid);
    }

    @Override
    public String getDescription() {
        return this.holder.description;
    }

    @Override
    public String getName() {
        return this.holder.name;
    }

    @Override
    public String getClassName() {
        return this.holder.className;
    }

    @Override
    public String getInterfaceName() {
        return this.holder.interfaceName;
    }

    @Override
    public String getDestinationName() {
        return this.holder.destinationName;
    }

    @Override
    public String getResourceAdapterName() {
        return this.holder.resourceAdapterName;
    }

    @Override
    public String[] getProperties() {
        return this.holder.properties;
    }

    @Override
    public Location getLocation() {
        return this.holder.location;
    }

    @Override
    public boolean refresh(TypeElement type) {
        AnnotationMirror annotationMirror = JmsDestinationImpl.getSpecificAnnotationMirror(JmsDestinationImpl.getAllAnnotationTypes(this.getHelper(), type));
        if (annotationMirror == null) {
            return false;
        }
        this.holder = JmsDestinationImpl.parseAnnotation(this.getHelper(), annotationMirror);
        return true;
    }

    protected static SimpleImpl parseAnnotation(AnnotationModelHelper helper, AnnotationMirror annotationMirror) {
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)helper);
        parser.expectString("className", AnnotationParser.defaultValue((Object)""));
        parser.expectString("interfaceName", null);
        parser.expectString("description", AnnotationParser.defaultValue((Object)""));
        parser.expectString("destinationName", AnnotationParser.defaultValue((Object)""));
        parser.expectString("name", null);
        ArrayList<String> props = new ArrayList<String>();
        parser.expectStringArray("properties", (ArrayValueHandler)new JndiResourcesValueHandlers.PropertiesArrayValueHandler(props), AnnotationParser.defaultValue((Object)new String[0]));
        parser.expectString("resourceAdapterName", AnnotationParser.defaultValue((Object)""));
        ParseResult result = parser.parse(annotationMirror);
        String description = (String)result.get("description", String.class);
        String destinationName = (String)result.get("destinationName", String.class);
        String className = (String)result.get("className", String.class);
        String interfaceName = (String)result.get("interfaceName", String.class);
        String name = (String)result.get("name", String.class);
        String resourceAdapterName = (String)result.get("resourceAdapterName", String.class);
        String[] properties = (String[])result.get("properties", String[].class);
        Location location = LocationHelper.getClassLocation(helper, className);
        return new SimpleImpl(description, name, className, interfaceName, destinationName, resourceAdapterName, properties, location);
    }

    private static Map<String, ? extends AnnotationMirror> getAllAnnotationTypes(AnnotationModelHelper helper, TypeElement type) {
        return helper.getAnnotationsByType(helper.getCompilationController().getElements().getAllAnnotationMirrors(type));
    }

    private static AnnotationMirror getSpecificAnnotationMirror(Map<String, ? extends AnnotationMirror> types) {
        AnnotationMirror annotationMirror = types.get("javax.jms.JMSDestinationDefinition");
        return annotationMirror;
    }

    protected static class SimpleImpl
    implements JmsDestination {
        private final String description;
        private final String name;
        private final String className;
        private final String interfaceName;
        private final String destinationName;
        private final String resourceAdapterName;
        private final String[] properties;
        private final Location location;

        public SimpleImpl(String description, String name, String className, String interfaceName, String destinationName, String resourceAdapterName, String[] properties, Location location) {
            this.description = description;
            this.name = name;
            this.className = className;
            this.interfaceName = interfaceName;
            this.destinationName = destinationName;
            this.resourceAdapterName = resourceAdapterName;
            this.properties = properties;
            this.location = location;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public String getInterfaceName() {
            return this.interfaceName;
        }

        @Override
        public String getDestinationName() {
            return this.destinationName;
        }

        @Override
        public String getResourceAdapterName() {
            return this.resourceAdapterName;
        }

        @Override
        public String[] getProperties() {
            return this.properties;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }
    }
}

