/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.NbPreferences;

public final class TempEnv {
    private static final Map<ExecutionEnvironment, TempEnv> instances = new HashMap<ExecutionEnvironment, TempEnv>();
    private final ExecutionEnvironment execEnv;
    private final Object lock = new Object();
    private final Map<String, EnvElement> envVars = new HashMap<String, EnvElement>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TempEnv getInstance(ExecutionEnvironment env) {
        Map<ExecutionEnvironment, TempEnv> map = instances;
        synchronized (map) {
            TempEnv instance = instances.get(env);
            if (instance == null) {
                instance = new TempEnv(env);
                instances.put(env, instance);
            }
            return instance;
        }
    }

    private TempEnv(ExecutionEnvironment env) {
        this.execEnv = env;
        Preferences node = this.getPreferences();
        try {
            for (String key : node.keys()) {
                String val = node.get(key, null);
                if (val == null) continue;
                this.envVars.put(key, new EnvElement(val, false));
            }
        }
        catch (IllegalStateException | BackingStoreException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void storeTemporaryEnv() {
        assert (Thread.holdsLock(this.lock));
        Preferences node = this.getPreferences();
        this.envVars.entrySet().forEach(entry -> node.put((String)entry.getKey(), ((EnvElement)entry.getValue()).value));
    }

    private Preferences getPreferences() {
        String id = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.execEnv).replace(':', '_').replace('@', '_');
        return NbPreferences.forModule(TempEnv.class).node(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTemporaryEnv() {
        Object object = this.lock;
        synchronized (object) {
            return this.envVars != null && !this.envVars.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTemporaryEnvSet(String key) {
        Object object = this.lock;
        synchronized (object) {
            EnvElement e = this.envVars.get(key);
            if (e != null) {
                return e.explicit;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTemporaryEnv(Map<String, String> map2fill) {
        Object object = this.lock;
        synchronized (object) {
            this.envVars.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                if (!map2fill.containsKey(key)) {
                    map2fill.put(key, ((EnvElement)entry.getValue()).value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTemporaryEnv(String key) {
        Object object = this.lock;
        synchronized (object) {
            EnvElement value = this.envVars.get(key);
            return value == null ? null : value.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemporaryEnv(String key, String value) {
        Object object = this.lock;
        synchronized (object) {
            this.envVars.put(key, new EnvElement(value, true));
            this.storeTemporaryEnv();
        }
    }

    private static class EnvElement {
        public final String value;
        public final boolean explicit;

        public EnvElement(String value, boolean explicit) {
            this.value = value;
            this.explicit = explicit;
        }

        public String toString() {
            return this.value + (this.explicit ? " [explicit]" : " [restored]");
        }
    }
}

