/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileManager;
import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.ObjCRuntime;
import org.clang.basic.VersionTuple;
import org.clang.basic.target.TargetInfo;
import org.clang.frontend.FrontendOptions;
import org.clang.frontend.PCHContainerReader;
import org.clang.frontend.frontend;
import org.clang.lex.PTHManager;
import org.clang.lex.Preprocessor;
import org.clang.serialization.ASTReader;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.APFloat;
import org.llvm.adt.APInt;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.fltSemantics;
import org.llvm.support.llvm;
import org.llvm.support.raw_string_ostream;

public final class InitPreprocessorStatics {
    public static boolean MacroBodyEndsInBackslash(StringRef MacroBody) {
        while (!MacroBody.empty() && BasicClangGlobals.isWhitespace((byte)MacroBody.back())) {
            MacroBody.$assignMove(MacroBody.drop_back());
        }
        return !MacroBody.empty() && MacroBody.back() == 92;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DefineBuiltinMacro(MacroBuilder Builder, StringRef Macro, DiagnosticsEngine Diags) {
        std_pair.pair MacroPair = Macro.split((byte)61);
        StringRef MacroName = new StringRef((StringRef)MacroPair.first);
        StringRef MacroBody = new StringRef((StringRef)MacroPair.second);
        if (MacroName.size() != Macro.size()) {
            int End = MacroBody.find_first_of("\n\r");
            if (End != StringRef.npos) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)Diags.Report(577))), (StringRef)MacroName));
                }
                finally {
                    $c$.$destroy();
                }
            }
            MacroBody.$assignMove(MacroBody.substr(0, End));
            if (InitPreprocessorStatics.MacroBodyEndsInBackslash(new StringRef(MacroBody))) {
                Builder.defineMacro(new Twine(MacroName), llvm.$add_Twine((Twine)new Twine(MacroBody), (Twine)new Twine("\\\n")));
            } else {
                Builder.defineMacro(new Twine(MacroName), new Twine(MacroBody));
            }
        } else {
            Builder.defineMacro(new Twine(Macro));
        }
    }

    public static void AddImplicitInclude(MacroBuilder Builder, StringRef File2) {
        Builder.append(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine("#include \""), (Twine)new Twine(File2)), (Twine)new Twine(NativePointer.$DBL_QUOTE)));
    }

    public static void AddImplicitIncludeMacros(MacroBuilder Builder, StringRef File2) {
        Builder.append(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine("#__include_macros \""), (Twine)new Twine(File2)), (Twine)new Twine(NativePointer.$DBL_QUOTE)));
        Builder.append(new Twine(NativePointer.$HASH_HASH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AddImplicitIncludePTH(MacroBuilder Builder, Preprocessor PP, StringRef ImplicitIncludePTH) {
        PTHManager P = PP.getPTHManager();
        char.ptr OriginalFile = Native.$tryClone((char.ptr)(P != null ? P.getOriginalSourceFile() : null));
        if (OriginalFile == null) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)PP.getDiagnostics().Report(517))), (StringRef)ImplicitIncludePTH));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        InitPreprocessorStatics.AddImplicitInclude(Builder, new StringRef(OriginalFile));
    }

    public static void AddImplicitIncludePCH(MacroBuilder Builder, Preprocessor PP, PCHContainerReader PCHContainerRdr, StringRef ImplicitIncludePCH) {
        std.string OriginalFile = ASTReader.getOriginalSourceFile((std.string)ImplicitIncludePCH.$basic_string(), (FileManager)PP.getFileManager(), (org.clang.serialization.PCHContainerReader)PCHContainerRdr, (DiagnosticsEngine)PP.getDiagnostics());
        if (OriginalFile.empty()) {
            return;
        }
        InitPreprocessorStatics.AddImplicitInclude(Builder, new StringRef(OriginalFile));
    }

    public static <T> T PickFP(fltSemantics Sem, T IEEESingleVal, T IEEEDoubleVal, T X87DoubleExtendedVal, T PPCDoubleDoubleVal, T IEEEQuadVal) {
        if (Sem == APFloat.IEEEsingle) {
            return IEEESingleVal;
        }
        if (Sem == APFloat.IEEEdouble) {
            return IEEEDoubleVal;
        }
        if (Sem == APFloat.x87DoubleExtended) {
            return X87DoubleExtendedVal;
        }
        if (Sem == APFloat.PPCDoubleDouble) {
            return PPCDoubleDoubleVal;
        }
        assert (Sem == APFloat.IEEEquad);
        return IEEEQuadVal;
    }

    public static void DefineFloatMacros(MacroBuilder Builder, StringRef Prefix, fltSemantics Sem, StringRef Ext) {
        String DenormMin = (String)Native.$tryClone((Object)InitPreprocessorStatics.PickFP(Sem, "1.40129846e-45", "4.9406564584124654e-324", "3.64519953188247460253e-4951", "4.94065645841246544176568792868221e-324", "6.47517511943802511092443895822764655e-4966"));
        int Digits = InitPreprocessorStatics.PickFP(Sem, 6, 15, 18, 31, 33);
        int DecimalDigits = InitPreprocessorStatics.PickFP(Sem, 9, 17, 21, 33, 36);
        String Epsilon = (String)Native.$tryClone((Object)InitPreprocessorStatics.PickFP(Sem, "1.19209290e-7", "2.2204460492503131e-16", "1.08420217248550443401e-19", "4.94065645841246544176568792868221e-324", "1.92592994438723585305597794258492732e-34"));
        int MantissaDigits = InitPreprocessorStatics.PickFP(Sem, 24, 53, 64, 106, 113);
        int Min10Exp = InitPreprocessorStatics.PickFP(Sem, -37, -307, -4931, -291, -4931);
        int Max10Exp = InitPreprocessorStatics.PickFP(Sem, 38, 308, 4932, 308, 4932);
        int MinExp = InitPreprocessorStatics.PickFP(Sem, -125, -1021, -16381, -968, -16381);
        int MaxExp = InitPreprocessorStatics.PickFP(Sem, 128, 1024, 16384, 1024, 16384);
        String Min = (String)Native.$tryClone((Object)InitPreprocessorStatics.PickFP(Sem, "1.17549435e-38", "2.2250738585072014e-308", "3.36210314311209350626e-4932", "2.00416836000897277799610805135016e-292", "3.36210314311209350626267781732175260e-4932"));
        String Max = (String)Native.$tryClone((Object)InitPreprocessorStatics.PickFP(Sem, "3.40282347e+38", "1.7976931348623157e+308", "1.18973149535723176502e+4932", "1.79769313486231580793728971405301e+308", "1.18973149535723176508575932662800702e+4932"));
        SmallString DefPrefix = new SmallString(32);
        DefPrefix.$assign("__");
        DefPrefix.$addassign(Prefix);
        DefPrefix.$addassign("_");
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"DENORM_MIN__"), llvm.$add_Twine((Twine)new Twine(DenormMin), (Twine)new Twine(Ext)));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"HAS_DENORM__"));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"DIG__"), new Twine(JavaDifferentiators.JD$Int.INSTANCE, Digits));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"DECIMAL_DIG__"), new Twine(JavaDifferentiators.JD$Int.INSTANCE, DecimalDigits));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"EPSILON__"), llvm.$add_Twine((Twine)new Twine(Epsilon), (Twine)new Twine(Ext)));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"HAS_INFINITY__"));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"HAS_QUIET_NAN__"));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"MANT_DIG__"), new Twine(JavaDifferentiators.JD$Int.INSTANCE, MantissaDigits));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"MAX_10_EXP__"), new Twine(JavaDifferentiators.JD$Int.INSTANCE, Max10Exp));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"MAX_EXP__"), new Twine(JavaDifferentiators.JD$Int.INSTANCE, MaxExp));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"MAX__"), llvm.$add_Twine((Twine)new Twine(Max), (Twine)new Twine(Ext)));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"MIN_10_EXP__"), llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(NativePointer.$LPAREN), (Twine)new Twine(JavaDifferentiators.JD$Int.INSTANCE, Min10Exp)), (Twine)new Twine(NativePointer.$RPAREN)));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"MIN_EXP__"), llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(NativePointer.$LPAREN), (Twine)new Twine(JavaDifferentiators.JD$Int.INSTANCE, MinExp)), (Twine)new Twine(NativePointer.$RPAREN)));
        Builder.defineMacro(llvm.$add_StringRef_char$ptr$C((StringRef)DefPrefix.$StringRef(), (String)"MIN__"), llvm.$add_Twine((Twine)new Twine(Min), (Twine)new Twine(Ext)));
    }

    public static void DefineTypeSize(Twine MacroName, int TypeWidth, StringRef ValSuffix, boolean isSigned, MacroBuilder Builder) {
        APInt MaxVal = isSigned ? APInt.getSignedMaxValue((int)TypeWidth) : APInt.getMaxValue((int)TypeWidth);
        Builder.defineMacro(MacroName, llvm.$add_Twine((Twine)new Twine(MaxVal.__toString(10, isSigned)), (Twine)new Twine(ValSuffix)));
    }

    public static void DefineTypeSize(Twine MacroName, TargetInfo.IntType Ty, TargetInfo TI, MacroBuilder Builder) {
        InitPreprocessorStatics.DefineTypeSize(MacroName, TI.getTypeWidth(Ty), new StringRef(TI.getTypeConstantSuffix(Ty)), TargetInfo.isTypeSigned((TargetInfo.IntType)Ty), Builder);
    }

    public static void DefineFmt(Twine Prefix, TargetInfo.IntType Ty, TargetInfo TI, MacroBuilder Builder) {
        boolean IsSigned = TargetInfo.isTypeSigned((TargetInfo.IntType)Ty);
        StringRef FmtModifier = new StringRef(TargetInfo.getTypeFormatModifier((TargetInfo.IntType)Ty));
        char.ptr Fmt = Native.$tryClone((char.ptr)(IsSigned ? NativePointer.$((String)"di") : NativePointer.$((String)"ouxX")));
        while (Fmt.$star() != 0) {
            Builder.defineMacro(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)Prefix, (Twine)new Twine("_FMT")), (Twine)new Twine(JavaDifferentiators.JD$Char.INSTANCE, Fmt.$star())), (Twine)new Twine("__")), llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(NativePointer.$DBL_QUOTE), (Twine)new Twine(FmtModifier)), (Twine)new Twine(JavaDifferentiators.JD$Char.INSTANCE, Fmt.$star())), (Twine)new Twine(NativePointer.$DBL_QUOTE)));
            Fmt.$preInc();
        }
    }

    public static void DefineType(Twine MacroName, TargetInfo.IntType Ty, MacroBuilder Builder) {
        Builder.defineMacro(MacroName, new Twine(TargetInfo.getTypeName((TargetInfo.IntType)Ty)));
    }

    public static void DefineTypeWidth(StringRef MacroName, TargetInfo.IntType Ty, TargetInfo TI, MacroBuilder Builder) {
        Builder.defineMacro(new Twine(MacroName), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, TI.getTypeWidth(Ty)));
    }

    public static void DefineTypeSizeof(StringRef MacroName, int BitWidth, TargetInfo TI, MacroBuilder Builder) {
        Builder.defineMacro(new Twine(MacroName), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, BitWidth / TI.getCharWidth()));
    }

    public static void DefineExactWidthIntType(TargetInfo.IntType Ty, TargetInfo TI, MacroBuilder Builder) {
        int TypeWidth = TI.getTypeWidth(Ty);
        boolean IsSigned = TargetInfo.isTypeSigned((TargetInfo.IntType)Ty);
        if (TypeWidth == 64) {
            Ty = IsSigned ? TI.getInt64Type() : TI.getUInt64Type();
        }
        char.ptr Prefix = Native.$tryClone((char.ptr)(IsSigned ? NativePointer.$((String)"__INT") : NativePointer.$((String)"__UINT")));
        InitPreprocessorStatics.DefineType(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.JD$Int.INSTANCE, TypeWidth)), (Twine)new Twine("_TYPE__")), Ty, Builder);
        InitPreprocessorStatics.DefineFmt(llvm.$add_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.JD$Int.INSTANCE, TypeWidth)), Ty, TI, Builder);
        StringRef ConstSuffix = new StringRef(TI.getTypeConstantSuffix(Ty));
        Builder.defineMacro(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.JD$Int.INSTANCE, TypeWidth)), (Twine)new Twine("_C_SUFFIX__")), new Twine(ConstSuffix));
    }

    public static void DefineExactWidthIntTypeSize(TargetInfo.IntType Ty, TargetInfo TI, MacroBuilder Builder) {
        int TypeWidth = TI.getTypeWidth(Ty);
        boolean IsSigned = TargetInfo.isTypeSigned((TargetInfo.IntType)Ty);
        if (TypeWidth == 64) {
            Ty = IsSigned ? TI.getInt64Type() : TI.getUInt64Type();
        }
        char.ptr Prefix = Native.$tryClone((char.ptr)(IsSigned ? NativePointer.$((String)"__INT") : NativePointer.$((String)"__UINT")));
        InitPreprocessorStatics.DefineTypeSize(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.JD$Int.INSTANCE, TypeWidth)), (Twine)new Twine("_MAX__")), Ty, TI, Builder);
    }

    public static void DefineLeastWidthIntType(int TypeWidth, boolean IsSigned, TargetInfo TI, MacroBuilder Builder) {
        TargetInfo.IntType Ty = TI.getLeastIntTypeByWidth(TypeWidth, IsSigned);
        if (Ty == TargetInfo.IntType.NoInt) {
            return;
        }
        char.ptr Prefix = Native.$tryClone((char.ptr)(IsSigned ? NativePointer.$((String)"__INT_LEAST") : NativePointer.$((String)"__UINT_LEAST")));
        InitPreprocessorStatics.DefineType(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.JD$UInt.INSTANCE, TypeWidth)), (Twine)new Twine("_TYPE__")), Ty, Builder);
        InitPreprocessorStatics.DefineTypeSize(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.JD$UInt.INSTANCE, TypeWidth)), (Twine)new Twine("_MAX__")), Ty, TI, Builder);
        InitPreprocessorStatics.DefineFmt(llvm.$add_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.JD$UInt.INSTANCE, TypeWidth)), Ty, TI, Builder);
    }

    public static void DefineFastIntType(int TypeWidth, boolean IsSigned, TargetInfo TI, MacroBuilder Builder) {
        TargetInfo.IntType Ty = TI.getLeastIntTypeByWidth(TypeWidth, IsSigned);
        if (Ty == TargetInfo.IntType.NoInt) {
            return;
        }
        char.ptr Prefix = Native.$tryClone((char.ptr)(IsSigned ? NativePointer.$((String)"__INT_FAST") : NativePointer.$((String)"__UINT_FAST")));
        InitPreprocessorStatics.DefineType(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.JD$UInt.INSTANCE, TypeWidth)), (Twine)new Twine("_TYPE__")), Ty, Builder);
        InitPreprocessorStatics.DefineTypeSize(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.JD$UInt.INSTANCE, TypeWidth)), (Twine)new Twine("_MAX__")), Ty, TI, Builder);
        InitPreprocessorStatics.DefineFmt(llvm.$add_Twine((Twine)new Twine(Prefix), (Twine)new Twine(JavaDifferentiators.JD$UInt.INSTANCE, TypeWidth)), Ty, TI, Builder);
    }

    public static char.ptr getLockFreeValue(int TypeWidth, int TypeAlign, int InlineWidth) {
        if (TypeWidth == TypeAlign && (TypeWidth & TypeWidth - 1) == 0 && Unsigned.$lesseq_uint((int)TypeWidth, (int)InlineWidth)) {
            return NativePointer.$2;
        }
        return NativePointer.$1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AddObjCXXARCLibstdcxxDefines(LangOptions LangOpts, MacroBuilder Builder) {
        Builder.defineMacro(new Twine("_GLIBCXX_PREDEFINED_OBJC_ARC_IS_SCALAR"));
        std.string Result = new std.string();
        raw_string_ostream Out = null;
        try {
            Out = new raw_string_ostream(Result);
            Out.$out("namespace std {\n").$out(NativePointer.$LF).$out("struct __true_type;\n").$out("struct __false_type;\n").$out(NativePointer.$LF);
            Out.$out("template<typename _Tp> struct __is_scalar;\n").$out(NativePointer.$LF);
            if (LangOpts.ObjCAutoRefCount) {
                Out.$out("template<typename _Tp>\n").$out("struct __is_scalar<__attribute__((objc_ownership(strong))) _Tp> {\n").$out("  enum { __value = 0 };\n").$out("  typedef __false_type __type;\n").$out("};\n").$out(NativePointer.$LF);
            }
            if (LangOpts.ObjCWeak) {
                Out.$out("template<typename _Tp>\n").$out("struct __is_scalar<__attribute__((objc_ownership(weak))) _Tp> {\n").$out("  enum { __value = 0 };\n").$out("  typedef __false_type __type;\n").$out("};\n").$out(NativePointer.$LF);
            }
            if (LangOpts.ObjCAutoRefCount) {
                Out.$out("template<typename _Tp>\n").$out("struct __is_scalar<__attribute__((objc_ownership(autoreleasing)))").$out(" _Tp> {\n").$out("  enum { __value = 0 };\n").$out("  typedef __false_type __type;\n").$out("};\n").$out(NativePointer.$LF);
            }
            Out.$out("}\n");
        }
        finally {
            if (Out != null) {
                Out.$destroy();
            }
        }
        Builder.append(new Twine(Result));
    }

    public static void InitializeStandardPredefinedMacros(TargetInfo TI, LangOptions LangOpts, FrontendOptions FEOpts, MacroBuilder Builder) {
        if (!LangOpts.MSVCCompat && !LangOpts.TraditionalCPP) {
            Builder.defineMacro(new Twine("__STDC__"));
        }
        if (LangOpts.Freestanding) {
            Builder.defineMacro(new Twine("__STDC_HOSTED__"), new Twine(NativePointer.$0));
        } else {
            Builder.defineMacro(new Twine("__STDC_HOSTED__"));
        }
        if (!LangOpts.CPlusPlus) {
            if (LangOpts.C11) {
                Builder.defineMacro(new Twine("__STDC_VERSION__"), new Twine("201112L"));
            } else if (LangOpts.C99) {
                Builder.defineMacro(new Twine("__STDC_VERSION__"), new Twine("199901L"));
            } else if (!LangOpts.GNUMode && LangOpts.Digraphs) {
                Builder.defineMacro(new Twine("__STDC_VERSION__"), new Twine("199409L"));
            }
        } else if (LangOpts.CPlusPlus1z) {
            Builder.defineMacro(new Twine("__cplusplus"), new Twine("201406L"));
        } else if (LangOpts.CPlusPlus14) {
            Builder.defineMacro(new Twine("__cplusplus"), new Twine("201402L"));
        } else if (LangOpts.CPlusPlus11) {
            Builder.defineMacro(new Twine("__cplusplus"), new Twine("201103L"));
        } else {
            Builder.defineMacro(new Twine("__cplusplus"), new Twine("199711L"));
        }
        Builder.defineMacro(new Twine("__STDC_UTF_16__"), new Twine(NativePointer.$1));
        Builder.defineMacro(new Twine("__STDC_UTF_32__"), new Twine(NativePointer.$1));
        if (LangOpts.ObjC1) {
            Builder.defineMacro(new Twine("__OBJC__"));
        }
        if (LangOpts.AsmPreprocessor) {
            Builder.defineMacro(new Twine("__ASSEMBLER__"));
        }
        if (LangOpts.CUDA) {
            Builder.defineMacro(new Twine("__CUDA__"));
        }
    }

    public static void InitializeCPlusPlusFeatureTestMacros(LangOptions LangOpts, MacroBuilder Builder) {
        if (LangOpts.RTTI) {
            Builder.defineMacro(new Twine("__cpp_rtti"), new Twine("199711"));
        }
        if (LangOpts.CXXExceptions) {
            Builder.defineMacro(new Twine("__cpp_exceptions"), new Twine("199711"));
        }
        if (LangOpts.CPlusPlus11) {
            Builder.defineMacro(new Twine("__cpp_unicode_characters"), new Twine("200704"));
            Builder.defineMacro(new Twine("__cpp_raw_strings"), new Twine("200710"));
            Builder.defineMacro(new Twine("__cpp_unicode_literals"), new Twine("200710"));
            Builder.defineMacro(new Twine("__cpp_user_defined_literals"), new Twine("200809"));
            Builder.defineMacro(new Twine("__cpp_lambdas"), new Twine("200907"));
            Builder.defineMacro(new Twine("__cpp_constexpr"), new Twine(LangOpts.CPlusPlus14 ? NativePointer.$((String)"201304") : NativePointer.$((String)"200704")));
            Builder.defineMacro(new Twine("__cpp_range_based_for"), new Twine("200907"));
            Builder.defineMacro(new Twine("__cpp_static_assert"), new Twine("200410"));
            Builder.defineMacro(new Twine("__cpp_decltype"), new Twine("200707"));
            Builder.defineMacro(new Twine("__cpp_attributes"), new Twine("200809"));
            Builder.defineMacro(new Twine("__cpp_rvalue_references"), new Twine("200610"));
            Builder.defineMacro(new Twine("__cpp_variadic_templates"), new Twine("200704"));
            Builder.defineMacro(new Twine("__cpp_initializer_lists"), new Twine("200806"));
            Builder.defineMacro(new Twine("__cpp_delegating_constructors"), new Twine("200604"));
            Builder.defineMacro(new Twine("__cpp_nsdmi"), new Twine("200809"));
            Builder.defineMacro(new Twine("__cpp_inheriting_constructors"), new Twine("200802"));
            Builder.defineMacro(new Twine("__cpp_ref_qualifiers"), new Twine("200710"));
            Builder.defineMacro(new Twine("__cpp_alias_templates"), new Twine("200704"));
        }
        if (LangOpts.CPlusPlus14) {
            Builder.defineMacro(new Twine("__cpp_binary_literals"), new Twine("201304"));
            Builder.defineMacro(new Twine("__cpp_digit_separators"), new Twine("201309"));
            Builder.defineMacro(new Twine("__cpp_init_captures"), new Twine("201304"));
            Builder.defineMacro(new Twine("__cpp_generic_lambdas"), new Twine("201304"));
            Builder.defineMacro(new Twine("__cpp_decltype_auto"), new Twine("201304"));
            Builder.defineMacro(new Twine("__cpp_return_type_deduction"), new Twine("201304"));
            Builder.defineMacro(new Twine("__cpp_aggregate_nsdmi"), new Twine("201304"));
            Builder.defineMacro(new Twine("__cpp_variable_templates"), new Twine("201304"));
        }
        if (LangOpts.SizedDeallocation) {
            Builder.defineMacro(new Twine("__cpp_sized_deallocation"), new Twine("201309"));
        }
        if (LangOpts.ConceptsTS) {
            Builder.defineMacro(new Twine("__cpp_experimental_concepts"), new Twine(NativePointer.$1));
        }
        if (LangOpts.Coroutines) {
            Builder.defineMacro(new Twine("__cpp_coroutines"), new Twine(NativePointer.$1));
        }
    }

    public static void InitializePredefinedMacros(TargetInfo TI, LangOptions LangOpts, FrontendOptions FEOpts, MacroBuilder Builder) {
        byte PICLevel;
        Builder.defineMacro(new Twine("__llvm__"));
        Builder.defineMacro(new Twine("__clang__"));
        Builder.defineMacro(new Twine("__clang_major__"), new Twine(NativePointer.$3));
        Builder.defineMacro(new Twine("__clang_minor__"), new Twine(NativePointer.$9));
        Builder.defineMacro(new Twine("__clang_patchlevel__"), new Twine(NativePointer.$0));
        Builder.defineMacro(new Twine("__clang_version__"), new Twine(std.$add_string_T((std.string)std.$add_T_string((String)"\"3.9.0 ", (std.string)BasicClangGlobals.getClangFullRepositoryVersion()), (String)"\"")));
        if (!LangOpts.MSVCCompat) {
            Builder.defineMacro(new Twine("__GNUC_MINOR__"), new Twine(NativePointer.$2));
            Builder.defineMacro(new Twine("__GNUC_PATCHLEVEL__"), new Twine(NativePointer.$1));
            Builder.defineMacro(new Twine("__GNUC__"), new Twine(NativePointer.$4));
            Builder.defineMacro(new Twine("__GXX_ABI_VERSION"), new Twine("1002"));
        }
        Builder.defineMacro(new Twine("__ATOMIC_RELAXED"), new Twine(NativePointer.$0));
        Builder.defineMacro(new Twine("__ATOMIC_CONSUME"), new Twine(NativePointer.$1));
        Builder.defineMacro(new Twine("__ATOMIC_ACQUIRE"), new Twine(NativePointer.$2));
        Builder.defineMacro(new Twine("__ATOMIC_RELEASE"), new Twine(NativePointer.$3));
        Builder.defineMacro(new Twine("__ATOMIC_ACQ_REL"), new Twine(NativePointer.$4));
        Builder.defineMacro(new Twine("__ATOMIC_SEQ_CST"), new Twine(NativePointer.$5));
        Builder.defineMacro(new Twine("__PRAGMA_REDEFINE_EXTNAME"), new Twine(NativePointer.$1));
        Builder.defineMacro(new Twine("__VERSION__"), llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine("\"4.2.1 Compatible "), (Twine)new Twine(BasicClangGlobals.getClangFullCPPVersion())), (Twine)new Twine(NativePointer.$DBL_QUOTE)));
        if (!LangOpts.GNUMode && !LangOpts.MSVCCompat) {
            Builder.defineMacro(new Twine("__STRICT_ANSI__"));
        }
        if (!LangOpts.MSVCCompat && LangOpts.CPlusPlus11) {
            Builder.defineMacro(new Twine("__GXX_EXPERIMENTAL_CXX0X__"));
        }
        if (LangOpts.ObjC1) {
            if (LangOpts.ObjCRuntime.isNonFragile()) {
                Builder.defineMacro(new Twine("__OBJC2__"));
                if (LangOpts.ObjCExceptions) {
                    Builder.defineMacro(new Twine("OBJC_ZEROCOST_EXCEPTIONS"));
                }
            }
            if (LangOpts.getGC() != LangOptions.GCMode.NonGC) {
                Builder.defineMacro(new Twine("__OBJC_GC__"));
            }
            if (LangOpts.ObjCRuntime.isNeXTFamily()) {
                Builder.defineMacro(new Twine("__NEXT_RUNTIME__"));
            }
            if (LangOpts.ObjCRuntime.getKind() == ObjCRuntime.Kind.ObjFW) {
                VersionTuple tuple = new VersionTuple(LangOpts.ObjCRuntime.getVersion());
                int minor = 0;
                if (tuple.getMinor().hasValue()) {
                    minor = tuple.getMinor().getValue();
                }
                int subminor = 0;
                if (tuple.getSubminor().hasValue()) {
                    subminor = tuple.getSubminor().getValue();
                }
                Builder.defineMacro(new Twine("__OBJFW_RUNTIME_ABI__"), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, tuple.getMajor() * 10000 + minor * 100 + subminor));
            }
            Builder.defineMacro(new Twine("IBOutlet"), new Twine("__attribute__((iboutlet))"));
            Builder.defineMacro(new Twine("IBOutletCollection(ClassName)"), new Twine("__attribute__((iboutletcollection(ClassName)))"));
            Builder.defineMacro(new Twine("IBAction"), new Twine("void)__attribute__((ibaction)"));
            Builder.defineMacro(new Twine("IBInspectable"), new Twine(NativePointer.$EMPTY));
            Builder.defineMacro(new Twine("IB_DESIGNABLE"), new Twine(NativePointer.$EMPTY));
        }
        if (LangOpts.CPlusPlus) {
            InitPreprocessorStatics.InitializeCPlusPlusFeatureTestMacros(LangOpts, Builder);
        }
        if (!LangOpts.NoConstantCFStrings) {
            Builder.defineMacro(new Twine("__CONSTANT_CFSTRINGS__"));
        }
        if (LangOpts.ObjC2) {
            Builder.defineMacro(new Twine("OBJC_NEW_PROPERTIES"));
        }
        if (LangOpts.PascalStrings) {
            Builder.defineMacro(new Twine("__PASCAL_STRINGS__"));
        }
        if (LangOpts.Blocks) {
            Builder.defineMacro(new Twine("__block"), new Twine("__attribute__((__blocks__(byref)))"));
            Builder.defineMacro(new Twine("__BLOCKS__"));
        }
        if (!LangOpts.MSVCCompat && LangOpts.Exceptions) {
            Builder.defineMacro(new Twine("__EXCEPTIONS"));
        }
        if (!LangOpts.MSVCCompat && LangOpts.RTTI) {
            Builder.defineMacro(new Twine("__GXX_RTTI"));
        }
        if (LangOpts.SjLjExceptions) {
            Builder.defineMacro(new Twine("__USING_SJLJ_EXCEPTIONS__"));
        }
        if (LangOpts.Deprecated) {
            Builder.defineMacro(new Twine("__DEPRECATED"));
        }
        if (!LangOpts.MSVCCompat && LangOpts.CPlusPlus) {
            Builder.defineMacro(new Twine("__GNUG__"), new Twine(NativePointer.$4));
            Builder.defineMacro(new Twine("__GXX_WEAK__"));
            Builder.defineMacro(new Twine(NativePointer.$__private_extern__), new Twine(NativePointer.$extern));
        }
        if (LangOpts.MicrosoftExt && LangOpts.WChar) {
            Builder.defineMacro(new Twine("_WCHAR_T_DEFINED"));
            Builder.defineMacro(new Twine("_NATIVE_WCHAR_T_DEFINED"));
        }
        if (LangOpts.Optimize) {
            Builder.defineMacro(new Twine("__OPTIMIZE__"));
        }
        if (LangOpts.OptimizeSize) {
            Builder.defineMacro(new Twine("__OPTIMIZE_SIZE__"));
        }
        if (LangOpts.FastMath) {
            Builder.defineMacro(new Twine("__FAST_MATH__"));
        }
        Builder.defineMacro(new Twine("__ORDER_LITTLE_ENDIAN__"), new Twine("1234"));
        Builder.defineMacro(new Twine("__ORDER_BIG_ENDIAN__"), new Twine("4321"));
        Builder.defineMacro(new Twine("__ORDER_PDP_ENDIAN__"), new Twine("3412"));
        if (TI.isBigEndian()) {
            Builder.defineMacro(new Twine("__BYTE_ORDER__"), new Twine("__ORDER_BIG_ENDIAN__"));
            Builder.defineMacro(new Twine("__BIG_ENDIAN__"));
        } else {
            Builder.defineMacro(new Twine("__BYTE_ORDER__"), new Twine("__ORDER_LITTLE_ENDIAN__"));
            Builder.defineMacro(new Twine("__LITTLE_ENDIAN__"));
        }
        if (TI.getPointerWidth(0) == 64L && TI.getLongWidth() == 64 && TI.getIntWidth() == 32) {
            Builder.defineMacro(new Twine("_LP64"));
            Builder.defineMacro(new Twine("__LP64__"));
        }
        if (TI.getPointerWidth(0) == 32L && TI.getLongWidth() == 32 && TI.getIntWidth() == 32) {
            Builder.defineMacro(new Twine("_ILP32"));
            Builder.defineMacro(new Twine("__ILP32__"));
        }
        assert (TI.getCharWidth() == 8) : "Only support 8-bit char so far";
        Builder.defineMacro(new Twine("__CHAR_BIT__"), new Twine(NativePointer.$8));
        InitPreprocessorStatics.DefineTypeSize(new Twine("__SCHAR_MAX__"), TargetInfo.IntType.SignedChar, TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine("__SHRT_MAX__"), TargetInfo.IntType.SignedShort, TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine("__INT_MAX__"), TargetInfo.IntType.SignedInt, TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine("__LONG_MAX__"), TargetInfo.IntType.SignedLong, TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine("__LONG_LONG_MAX__"), TargetInfo.IntType.SignedLongLong, TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine("__WCHAR_MAX__"), TI.getWCharType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine("__INTMAX_MAX__"), TI.getIntMaxType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine("__SIZE_MAX__"), TI.getSizeType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine("__UINTMAX_MAX__"), TI.getUIntMaxType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine("__PTRDIFF_MAX__"), TI.getPtrDiffType(0), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine("__INTPTR_MAX__"), TI.getIntPtrType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine("__UINTPTR_MAX__"), TI.getUIntPtrType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_DOUBLE__"), TI.getDoubleWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_FLOAT__"), TI.getFloatWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_INT__"), TI.getIntWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_LONG__"), TI.getLongWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_LONG_DOUBLE__"), TI.getLongDoubleWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_LONG_LONG__"), TI.getLongLongWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_POINTER__"), Unsigned.$ulong2uint((long)TI.getPointerWidth(0)), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_SHORT__"), TI.getShortWidth(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_PTRDIFF_T__"), TI.getTypeWidth(TI.getPtrDiffType(0)), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_SIZE_T__"), TI.getTypeWidth(TI.getSizeType()), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_WCHAR_T__"), TI.getTypeWidth(TI.getWCharType()), TI, Builder);
        InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_WINT_T__"), TI.getTypeWidth(TI.getWIntType()), TI, Builder);
        if (TI.hasInt128Type()) {
            InitPreprocessorStatics.DefineTypeSizeof(new StringRef("__SIZEOF_INT128__"), 128, TI, Builder);
        }
        InitPreprocessorStatics.DefineType(new Twine("__INTMAX_TYPE__"), TI.getIntMaxType(), Builder);
        InitPreprocessorStatics.DefineFmt(new Twine("__INTMAX"), TI.getIntMaxType(), TI, Builder);
        Builder.defineMacro(new Twine("__INTMAX_C_SUFFIX__"), new Twine(TI.getTypeConstantSuffix(TI.getIntMaxType())));
        InitPreprocessorStatics.DefineType(new Twine("__UINTMAX_TYPE__"), TI.getUIntMaxType(), Builder);
        InitPreprocessorStatics.DefineFmt(new Twine("__UINTMAX"), TI.getUIntMaxType(), TI, Builder);
        Builder.defineMacro(new Twine("__UINTMAX_C_SUFFIX__"), new Twine(TI.getTypeConstantSuffix(TI.getUIntMaxType())));
        InitPreprocessorStatics.DefineTypeWidth(new StringRef("__INTMAX_WIDTH__"), TI.getIntMaxType(), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine("__PTRDIFF_TYPE__"), TI.getPtrDiffType(0), Builder);
        InitPreprocessorStatics.DefineFmt(new Twine("__PTRDIFF"), TI.getPtrDiffType(0), TI, Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef("__PTRDIFF_WIDTH__"), TI.getPtrDiffType(0), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine("__INTPTR_TYPE__"), TI.getIntPtrType(), Builder);
        InitPreprocessorStatics.DefineFmt(new Twine("__INTPTR"), TI.getIntPtrType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef("__INTPTR_WIDTH__"), TI.getIntPtrType(), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine("__SIZE_TYPE__"), TI.getSizeType(), Builder);
        InitPreprocessorStatics.DefineFmt(new Twine("__SIZE"), TI.getSizeType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef("__SIZE_WIDTH__"), TI.getSizeType(), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine("__WCHAR_TYPE__"), TI.getWCharType(), Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef("__WCHAR_WIDTH__"), TI.getWCharType(), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine("__WINT_TYPE__"), TI.getWIntType(), Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef("__WINT_WIDTH__"), TI.getWIntType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef("__SIG_ATOMIC_WIDTH__"), TI.getSigAtomicType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeSize(new Twine("__SIG_ATOMIC_MAX__"), TI.getSigAtomicType(), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine("__CHAR16_TYPE__"), TI.getChar16Type(), Builder);
        InitPreprocessorStatics.DefineType(new Twine("__CHAR32_TYPE__"), TI.getChar32Type(), Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef("__UINTMAX_WIDTH__"), TI.getUIntMaxType(), TI, Builder);
        InitPreprocessorStatics.DefineType(new Twine("__UINTPTR_TYPE__"), TI.getUIntPtrType(), Builder);
        InitPreprocessorStatics.DefineFmt(new Twine("__UINTPTR"), TI.getUIntPtrType(), TI, Builder);
        InitPreprocessorStatics.DefineTypeWidth(new StringRef("__UINTPTR_WIDTH__"), TI.getUIntPtrType(), TI, Builder);
        InitPreprocessorStatics.DefineFloatMacros(Builder, new StringRef("FLT"), TI.getFloatFormat(), new StringRef(NativePointer.$F));
        InitPreprocessorStatics.DefineFloatMacros(Builder, new StringRef("DBL"), TI.getDoubleFormat(), new StringRef(NativePointer.$EMPTY));
        InitPreprocessorStatics.DefineFloatMacros(Builder, new StringRef("LDBL"), TI.getLongDoubleFormat(), new StringRef(NativePointer.$L));
        Builder.defineMacro(new Twine("__POINTER_WIDTH__"), new Twine(JavaDifferentiators.JD$Int.INSTANCE, Unsigned.$ulong2int((long)TI.getPointerWidth(0))));
        Builder.defineMacro(new Twine("__BIGGEST_ALIGNMENT__"), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, TI.getSuitableAlign() / TI.getCharWidth()));
        if (!LangOpts.CharIsSigned) {
            Builder.defineMacro(new Twine("__CHAR_UNSIGNED__"));
        }
        if (!TargetInfo.isTypeSigned((TargetInfo.IntType)TI.getWCharType())) {
            Builder.defineMacro(new Twine("__WCHAR_UNSIGNED__"));
        }
        if (!TargetInfo.isTypeSigned((TargetInfo.IntType)TI.getWIntType())) {
            Builder.defineMacro(new Twine("__WINT_UNSIGNED__"));
        }
        InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.SignedChar, TI, Builder);
        if (Unsigned.$greater_uint((int)TI.getShortWidth(), (int)TI.getCharWidth())) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.SignedShort, TI, Builder);
        }
        if (Unsigned.$greater_uint((int)TI.getIntWidth(), (int)TI.getShortWidth())) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.SignedInt, TI, Builder);
        }
        if (Unsigned.$greater_uint((int)TI.getLongWidth(), (int)TI.getIntWidth())) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.SignedLong, TI, Builder);
        }
        if (Unsigned.$greater_uint((int)TI.getLongLongWidth(), (int)TI.getLongWidth())) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.SignedLongLong, TI, Builder);
        }
        InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.UnsignedChar, TI, Builder);
        InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.UnsignedChar, TI, Builder);
        InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.SignedChar, TI, Builder);
        if (Unsigned.$greater_uint((int)TI.getShortWidth(), (int)TI.getCharWidth())) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.UnsignedShort, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.UnsignedShort, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.SignedShort, TI, Builder);
        }
        if (Unsigned.$greater_uint((int)TI.getIntWidth(), (int)TI.getShortWidth())) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.UnsignedInt, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.UnsignedInt, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.SignedInt, TI, Builder);
        }
        if (Unsigned.$greater_uint((int)TI.getLongWidth(), (int)TI.getIntWidth())) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.UnsignedLong, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.UnsignedLong, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.SignedLong, TI, Builder);
        }
        if (Unsigned.$greater_uint((int)TI.getLongLongWidth(), (int)TI.getLongWidth())) {
            InitPreprocessorStatics.DefineExactWidthIntType(TargetInfo.IntType.UnsignedLongLong, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.UnsignedLongLong, TI, Builder);
            InitPreprocessorStatics.DefineExactWidthIntTypeSize(TargetInfo.IntType.SignedLongLong, TI, Builder);
        }
        InitPreprocessorStatics.DefineLeastWidthIntType(8, true, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(8, false, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(16, true, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(16, false, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(32, true, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(32, false, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(64, true, TI, Builder);
        InitPreprocessorStatics.DefineLeastWidthIntType(64, false, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(8, true, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(8, false, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(16, true, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(16, false, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(32, true, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(32, false, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(64, true, TI, Builder);
        InitPreprocessorStatics.DefineFastIntType(64, false, TI, Builder);
        byte[] UserLabelPrefix = NativePointer.new$char((int)2, (byte[])new byte[]{TI.getDataLayout().getGlobalPrefix(), 0});
        Builder.defineMacro(new Twine("__USER_LABEL_PREFIX__"), new Twine(UserLabelPrefix));
        if (LangOpts.FastMath || LangOpts.FiniteMathOnly) {
            Builder.defineMacro(new Twine("__FINITE_MATH_ONLY__"), new Twine(NativePointer.$1));
        } else {
            Builder.defineMacro(new Twine("__FINITE_MATH_ONLY__"), new Twine(NativePointer.$0));
        }
        if (!LangOpts.MSVCCompat) {
            if (LangOpts.GNUInline || LangOpts.CPlusPlus) {
                Builder.defineMacro(new Twine("__GNUC_GNU_INLINE__"));
            } else {
                Builder.defineMacro(new Twine("__GNUC_STDC_INLINE__"));
            }
            Builder.defineMacro(new Twine("__GCC_ATOMIC_TEST_AND_SET_TRUEVAL"), new Twine(NativePointer.$1));
            int InlineWidthBits = TI.getMaxAtomicInlineWidth();
            Builder.defineMacro(new Twine("__GCC_ATOMIC_BOOL_LOCK_FREE"), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getBoolWidth(), TI.getBoolAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine("__GCC_ATOMIC_CHAR_LOCK_FREE"), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getCharWidth(), TI.getCharAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine("__GCC_ATOMIC_CHAR16_T_LOCK_FREE"), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getChar16Width(), TI.getChar16Align(), InlineWidthBits)));
            Builder.defineMacro(new Twine("__GCC_ATOMIC_CHAR32_T_LOCK_FREE"), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getChar32Width(), TI.getChar32Align(), InlineWidthBits)));
            Builder.defineMacro(new Twine("__GCC_ATOMIC_WCHAR_T_LOCK_FREE"), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getWCharWidth(), TI.getWCharAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine("__GCC_ATOMIC_SHORT_LOCK_FREE"), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getShortWidth(), TI.getShortAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine("__GCC_ATOMIC_INT_LOCK_FREE"), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getIntWidth(), TI.getIntAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine("__GCC_ATOMIC_LONG_LOCK_FREE"), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getLongWidth(), TI.getLongAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine("__GCC_ATOMIC_LLONG_LOCK_FREE"), new Twine(InitPreprocessorStatics.getLockFreeValue(TI.getLongLongWidth(), TI.getLongLongAlign(), InlineWidthBits)));
            Builder.defineMacro(new Twine("__GCC_ATOMIC_POINTER_LOCK_FREE"), new Twine(InitPreprocessorStatics.getLockFreeValue(Unsigned.$ulong2uint((long)TI.getPointerWidth(0)), Unsigned.$ulong2uint((long)TI.getPointerAlign(0)), InlineWidthBits)));
        }
        if (LangOpts.NoInlineDefine) {
            Builder.defineMacro(new Twine("__NO_INLINE__"));
        }
        if ((PICLevel = LangOpts.PICLevel) != 0) {
            Builder.defineMacro(new Twine("__PIC__"), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, (int)PICLevel));
            Builder.defineMacro(new Twine("__pic__"), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, (int)PICLevel));
            if (LangOpts.PIE) {
                Builder.defineMacro(new Twine("__PIE__"), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, (int)PICLevel));
                Builder.defineMacro(new Twine("__pie__"), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, (int)PICLevel));
            }
        }
        Builder.defineMacro(new Twine("__FLT_EVAL_METHOD__"), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, TI.getFloatEvalMethod()));
        Builder.defineMacro(new Twine("__FLT_RADIX__"), new Twine(NativePointer.$2));
        Builder.defineMacro(new Twine("__DECIMAL_DIG__"), new Twine("__LDBL_DECIMAL_DIG__"));
        if (LangOpts.getStackProtector() == LangOptions.StackProtectorMode.SSPOn) {
            Builder.defineMacro(new Twine("__SSP__"));
        } else if (LangOpts.getStackProtector() == LangOptions.StackProtectorMode.SSPStrong) {
            Builder.defineMacro(new Twine("__SSP_STRONG__"), new Twine(NativePointer.$2));
        } else if (LangOpts.getStackProtector() == LangOptions.StackProtectorMode.SSPReq) {
            Builder.defineMacro(new Twine("__SSP_ALL__"), new Twine(NativePointer.$3));
        }
        if (FEOpts.ProgramAction == frontend.ActionKind.RunAnalysis) {
            Builder.defineMacro(new Twine("__clang_analyzer__"));
        }
        if (LangOpts.FastRelaxedMath) {
            Builder.defineMacro(new Twine("__FAST_RELAXED_MATH__"));
        }
        if (FEOpts.ProgramAction == frontend.ActionKind.RewriteObjC || LangOpts.getGC() != LangOptions.GCMode.NonGC) {
            Builder.defineMacro(new Twine("__weak"), new Twine("__attribute__((objc_gc(weak)))"));
            Builder.defineMacro(new Twine("__strong"), new Twine("__attribute__((objc_gc(strong)))"));
            Builder.defineMacro(new Twine("__autoreleasing"), new Twine(NativePointer.$EMPTY));
            Builder.defineMacro(new Twine("__unsafe_unretained"), new Twine(NativePointer.$EMPTY));
        } else if (LangOpts.ObjC1) {
            Builder.defineMacro(new Twine("__weak"), new Twine("__attribute__((objc_ownership(weak)))"));
            Builder.defineMacro(new Twine("__strong"), new Twine("__attribute__((objc_ownership(strong)))"));
            Builder.defineMacro(new Twine("__autoreleasing"), new Twine("__attribute__((objc_ownership(autoreleasing)))"));
            Builder.defineMacro(new Twine("__unsafe_unretained"), new Twine("__attribute__((objc_ownership(none)))"));
        }
        if (TI.getTriple().isOSDarwin()) {
            Builder.defineMacro(new Twine("__nonnull"), new Twine(NativePointer.$_Nonnull));
            Builder.defineMacro(new Twine("__null_unspecified"), new Twine(NativePointer.$_Null_unspecified));
            Builder.defineMacro(new Twine("__nullable"), new Twine(NativePointer.$_Nullable));
        }
        switch (LangOpts.OpenMP) {
            case 0: {
                break;
            }
            case 40: {
                Builder.defineMacro(new Twine("_OPENMP"), new Twine("201307"));
                break;
            }
            case 45: {
                Builder.defineMacro(new Twine("_OPENMP"), new Twine("201511"));
                break;
            }
            default: {
                Builder.defineMacro(new Twine("_OPENMP"), new Twine("201107"));
            }
        }
        if (LangOpts.CUDAIsDevice) {
            Builder.defineMacro(new Twine("__CUDA_ARCH__"));
        }
        if (LangOpts.CUDADeviceApproxTranscendentals || LangOpts.FastMath) {
            Builder.defineMacro(new Twine("__CLANG_CUDA_APPROX_TRANSCENDENTALS__"));
        }
        if (LangOpts.OpenCL) {
            if (TI.getSupportedOpenCLOpts().is_cl_khr_3d_image_writes_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_3d_image_writes"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_select_fprounding_mode_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_select_fprounding_mode"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_byte_addressable_store_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_byte_addressable_store"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_fp16_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_fp16"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_fp64_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_fp64"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_global_int32_base_atomics_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_global_int32_base_atomics"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_global_int32_extended_atomics_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_global_int32_extended_atomics"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_local_int32_base_atomics_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_local_int32_base_atomics"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_local_int32_extended_atomics_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_local_int32_extended_atomics"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_int64_base_atomics_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_int64_base_atomics"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_int64_extended_atomics_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_int64_extended_atomics"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_gl_sharing_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_gl_sharing"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_icd_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_icd"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_gl_event_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_gl_event"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_d3d10_sharing_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_d3d10_sharing"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_context_abort_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_context_abort"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_d3d11_sharing_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_d3d11_sharing"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_depth_images_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_depth_images"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_dx9_media_sharing_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_dx9_media_sharing"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_image2d_from_buffer_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_image2d_from_buffer"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_initialize_memory_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_initialize_memory"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_gl_depth_images_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_gl_depth_images"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_gl_msaa_sharing_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_gl_msaa_sharing"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_spir_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_spir"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_egl_event_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_egl_event"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_egl_image_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_egl_image"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_srgb_image_writes_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_srgb_image_writes"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_subgroups_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_subgroups"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_khr_terminate_context_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_khr_terminate_context"));
            }
            if (TI.getSupportedOpenCLOpts().is_cl_clang_storage_class_specifiers_supported(LangOpts.OpenCLVersion)) {
                Builder.defineMacro(new Twine("cl_clang_storage_class_specifiers"));
            }
        }
        TI.getTargetDefines(LangOpts, Builder);
    }
}

