/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.ReferenceCollector;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntitiesProvider;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntity;
import org.netbeans.modules.cnd.highlight.semantic.debug.InterrupterImpl;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.NamedOption;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.support.CancelSupport;
import org.netbeans.spi.editor.highlighting.support.PositionsBag;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public final class SemanticHighlighter
extends HighlighterBase {
    private static final String SLOW_POSITION_BAG = "CndSemanticHighlighterSlow";
    private static final String FAST_POSITION_BAG = "CndSemanticHighlighterFast";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.model.tasks");
    private static final RequestProcessor RP = new RequestProcessor("SemanticHighlighter profiler", 1);
    private static final RequestProcessor WORKER = new RequestProcessor("SemanticHighlighter worker", 1);
    private static final boolean VALIDATE = false;
    private final TaskContext taskContext;
    private final RequestProcessor.Task task;
    private final CancelSupport cancel = CancelSupport.create((SchedulerTask)this);
    private InterrupterImpl interrupter = new InterrupterImpl();
    private Parser.Result lastParserResult;
    private CountDownLatch latch = new CountDownLatch(1);
    private Set<Map.Entry<Thread, StackTraceElement[]>> stack;
    private AtomicBoolean done = new AtomicBoolean(false);
    private static final int MAX_LINE_NUMBER;

    public SemanticHighlighter(String mimeType) {
        this.init(mimeType);
        this.taskContext = new TaskContext(this);
        this.task = WORKER.create((Runnable)this.taskContext);
    }

    @Override
    protected void updateFontColors(FontColorProvider provider) {
        for (SemanticEntity semanticEntity : SemanticEntitiesProvider.instance().get()) {
            semanticEntity.updateFontColors(provider);
        }
    }

    public static PositionsBag getHighlightsBag(Document doc, boolean fast) {
        if (doc == null) {
            return null;
        }
        String name = fast ? FAST_POSITION_BAG : SLOW_POSITION_BAG;
        PositionsBag bag = (PositionsBag)doc.getProperty(name);
        if (bag == null) {
            bag = new PositionsBag(doc);
            doc.putProperty(name, bag);
        }
        return bag;
    }

    public static boolean isVeryBigDocument(Document doc) {
        if (!(doc instanceof BaseDocument) || MAX_LINE_NUMBER < 0) {
            return false;
        }
        try {
            if (doc.getLength() < MAX_LINE_NUMBER) {
                return false;
            }
            return LineDocumentUtils.getLineIndex((LineDocument)((BaseDocument)doc), (int)(doc.getLength() - 1)) > MAX_LINE_NUMBER;
        }
        catch (BadLocationException ex) {
            return true;
        }
    }

    public static PositionsBag getSemanticBagForTests(Document doc, InterrupterImpl interrupter, boolean fast) {
        if (doc != null) {
            SemanticHighlighter semanticHighlighter = new SemanticHighlighter(DocumentUtilities.getMimeType((Document)doc));
            SemanticHighlighter.updateImpl(semanticHighlighter, doc, interrupter);
        }
        return SemanticHighlighter.getHighlightsBag(doc, fast);
    }

    private static void updateImpl(SemanticHighlighter provider, Document doc, final InterrupterImpl interrupter) {
        if (doc == null) {
            return;
        }
        boolean macroExpansionView = doc.getProperty("macro-expansion-view-document") != null;
        PositionsBag newBagFast = new PositionsBag(doc);
        PositionsBag newBagSlow = new PositionsBag(doc);
        final CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
        long start = System.currentTimeMillis();
        if (csmFile != null && csmFile.isParsed()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Semantic Highlighting update() have started for file {0}", csmFile.getAbsolutePath());
            }
            ArrayList<SemanticEntity> entities = new ArrayList<SemanticEntity>(SemanticEntitiesProvider.instance().get());
            final ArrayList<ReferenceCollector> collectors = new ArrayList<ReferenceCollector>(entities.size());
            Iterator i = entities.iterator();
            while (i.hasNext() && !interrupter.cancelled()) {
                SemanticEntity se = (SemanticEntity)((Object)i.next());
                if (!(!NamedOption.getAccessor().getBoolean(se.getName()) || macroExpansionView && se.getName().equals("macros"))) {
                    ReferenceCollector collector = se.getCollector(doc, interrupter);
                    if (collector != null) {
                        collectors.add(collector);
                        continue;
                    }
                    provider.addHighlightsToBag(doc, newBagFast, se.getBlocks(csmFile, doc, interrupter), se);
                    i.remove();
                    continue;
                }
                i.remove();
            }
            if (!interrupter.cancelled()) {
                SemanticHighlighter.getHighlightsBag(doc, true).setHighlights(newBagFast);
                if (!entities.isEmpty() && !SemanticHighlighter.isVeryBigDocument(doc)) {
                    CsmFileReferences.getDefault().accept((CsmScope)csmFile, doc, new CsmFileReferences.Visitor(){

                        public void visit(CsmReferenceContext context) {
                            CsmReference ref = context.getReference();
                            for (ReferenceCollector c : collectors) {
                                if (interrupter.cancelled()) break;
                                c.visit(ref, csmFile);
                            }
                        }

                        public boolean cancelled() {
                            return interrupter.cancelled();
                        }
                    }, CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE_AND_PREPROCESSOR);
                    for (int i2 = 0; i2 < entities.size(); ++i2) {
                        provider.addHighlightsToBag(doc, newBagSlow, ((ReferenceCollector)collectors.get(i2)).getReferences(), (SemanticEntity)((Object)entities.get(i2)));
                    }
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Semantic Highlighting update() done in {0}ms for file {1}", new Object[]{System.currentTimeMillis() - start, csmFile.getAbsolutePath()});
                }
                if (!interrupter.cancelled()) {
                    SemanticHighlighter.getHighlightsBag(doc, false).setHighlights(newBagSlow);
                }
            }
        }
    }

    private void addHighlightsToBag(Document doc, PositionsBag bag, List<? extends CsmOffsetable> blocks, SemanticEntity entity) {
        if (doc != null) {
            String mimeType = DocumentUtilities.getMimeType((Document)doc);
            if (mimeType == null) {
                mimeType = "text/x-c++";
            }
            for (CsmOffsetable csmOffsetable : blocks) {
                int startOffset = csmOffsetable.getStartOffset();
                int endOffset = csmOffsetable.getEndOffset();
                if (endOffset == Integer.MAX_VALUE) {
                    endOffset = doc.getLength() + 1;
                }
                if (doc.getProperty("macro-expansion-view-document") == null || entity.isCsmFileBased()) {
                    startOffset = SemanticHighlighter.getDocumentOffset(doc, startOffset);
                    endOffset = SemanticHighlighter.getDocumentOffset(doc, endOffset);
                }
                if (startOffset < doc.getLength() && startOffset >= 0 && startOffset < endOffset) {
                    AttributeSet attributes = entity.getAttributes(csmOffsetable, mimeType);
                    if (attributes == null) {
                        assert (false) : "Color attributes set is not found for MIME " + mimeType + ". Document " + doc;
                        return;
                    }
                    this.addHighlightsToBag(doc, bag, startOffset, endOffset, attributes, entity.getName());
                    continue;
                }
                if (startOffset >= doc.getLength() || startOffset < 0 || startOffset <= endOffset) continue;
                CndUtils.assertTrueInConsole((boolean)false, (String)this.getInfo(doc, csmOffsetable, startOffset, endOffset));
            }
        }
    }

    private String getInfo(Document doc, CsmOffsetable block, int startOffset, int endOffset) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
        String start = Utilities.offsetToLineColumnString((BaseDocument)((BaseDocument)doc), (int)startOffset);
        String end = Utilities.offsetToLineColumnString((BaseDocument)((BaseDocument)doc), (int)endOffset);
        return "Block [" + block.getStartPosition().getLine() + ":" + block.getStartPosition().getColumn() + "-" + block.getEndPosition().getLine() + ":" + block.getEndPosition().getColumn() + "] " + block.getText().toString() + " transformed to [" + start + "-" + end + "] in file " + csmFile.getAbsolutePath();
    }

    private void addHighlightsToBag(Document doc, PositionsBag bag, int start, int end, AttributeSet attr, String nameToStateInLog) {
        try {
            if (doc != null) {
                if ("inactive".equals(nameToStateInLog)) {
                    bag.addHighlight(NbDocument.createPosition((Document)doc, (int)start, (Position.Bias)Position.Bias.Backward), NbDocument.createPosition((Document)doc, (int)end, (Position.Bias)Position.Bias.Forward), attr);
                } else {
                    bag.addHighlight(NbDocument.createPosition((Document)doc, (int)start, (Position.Bias)Position.Bias.Forward), NbDocument.createPosition((Document)doc, (int)end, (Position.Bias)Position.Bias.Backward), attr);
                }
            }
        }
        catch (BadLocationException ex) {
            LOG.log(Level.FINE, "Can't add highlight <" + start + ", " + end + ", " + nameToStateInLog + ">", ex);
        }
    }

    private static int getDocumentOffset(Document doc, int fileOffset) {
        return CsmMacroExpansion.getOffsetInExpandedText((Document)doc, (int)fileOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Parser.Result result, SchedulerEvent event) {
        SemanticHighlighter semanticHighlighter = this;
        synchronized (semanticHighlighter) {
            if (this.lastParserResult == result) {
                return;
            }
            this.interrupter.cancel();
            this.latch.countDown();
            this.interrupter = new InterrupterImpl();
            this.latch = new CountDownLatch(1);
            if (this.cancel.isCancelled()) {
                this.lastParserResult = null;
                LOG.log(Level.FINE, "SemanticHighlighter have been canceled before start, Task={0}, Result={1}", new Object[]{System.identityHashCode((Object)this), System.identityHashCode(result)});
                return;
            }
            this.lastParserResult = result;
        }
        long time = 0L;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "SemanticHighlighter started, Task={0}, Result={1}", new Object[]{System.identityHashCode((Object)this), System.identityHashCode(result)});
            time = System.currentTimeMillis();
            this.done = new AtomicBoolean(false);
        }
        this.taskContext.prepare(result.getSnapshot().getSource().getDocument(false), this.interrupter, this.latch);
        this.task.schedule(0);
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (LOG.isLoggable(Level.FINE)) {
            this.done.set(true);
            LOG.log(Level.FINE, "SemanticHighlighter finished for {0}ms", System.currentTimeMillis() - time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        SemanticHighlighter semanticHighlighter = this;
        synchronized (semanticHighlighter) {
            this.interrupter.cancel();
            this.lastParserResult = null;
            this.latch.countDown();
        }
        if (LOG.isLoggable(Level.FINE)) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    AtomicBoolean aDone = SemanticHighlighter.this.done;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!aDone.get()) {
                        SemanticHighlighter.this.stack = Thread.getAllStackTraces().entrySet();
                        StringBuilder buf = new StringBuilder();
                        boolean printHeader = false;
                        for (Map.Entry entry : SemanticHighlighter.this.stack) {
                            if (!((Thread)entry.getKey()).getName().startsWith("SemanticHighlighter worker") && !((Thread)entry.getKey()).getName().startsWith("Editor Parsing Loop")) continue;
                            if (!printHeader) {
                                buf.append("What have been semantic provider doing for 100 ms after canceling?");
                            }
                            printHeader = true;
                            buf.append("\nThread ").append(((Thread)entry.getKey()).getName());
                            for (StackTraceElement element : (StackTraceElement[])entry.getValue()) {
                                buf.append("\n\tat " + element.toString());
                            }
                        }
                        if (buf.length() > 0) {
                            LOG.log(Level.FINE, buf.toString());
                        }
                    }
                }
            });
            LOG.log(Level.FINE, "SemanticHighlighter canceled in {0}, Task={1}", new Object[]{Thread.currentThread().getName(), System.identityHashCode((Object)this)});
        }
    }

    public int getPriority() {
        return 300;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public String toString() {
        return "SemanticHighlighter runner";
    }

    static {
        String limit = System.getProperty("cnd.semantic.line.limit");
        int userInput = 5000;
        if (limit != null) {
            try {
                userInput = Integer.parseInt(limit);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MAX_LINE_NUMBER = userInput;
    }

    private static final class TaskContext
    implements Runnable {
        private final SemanticHighlighter provider;
        private volatile InterrupterImpl interrupter;
        private volatile Document doc;
        private volatile CountDownLatch latch;

        private TaskContext(SemanticHighlighter provider) {
            this.provider = provider;
        }

        private void prepare(Document doc, InterrupterImpl interrupter, CountDownLatch latch) {
            this.interrupter = interrupter;
            this.doc = doc;
            this.latch = latch;
        }

        @Override
        public void run() {
            CountDownLatch aLatch = this.latch;
            try {
                SemanticHighlighter.updateImpl(this.provider, this.doc, this.interrupter);
            }
            finally {
                aLatch.countDown();
            }
        }
    }
}

